/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.config;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import noppes.npcs.util.ValueUtil;
import org.apache.logging.log4j.Level;

public class ConfigCapsules {
    public static Configuration config;
    public static final String CAPSULES = "Capsules";
    public static final String KI = "Ki";
    public static final String HEALTH = "Health";
    public static final String STAMINA = "Stamina";
    public static final String MISC = "Misc";
    public static final String REGEN = "Regen";
    public static boolean EnableCapsules;
    public static boolean EnableCapsuleCooldowns;
    public static boolean EnableKiCapsule;
    public static int KiCapsuleCooldownType;
    public static int KiCapsuleMaxStack;
    public static boolean EnableHealthCapsule;
    public static int HealthCapsuleCooldownType;
    public static int HealthCapsuleMaxStack;
    public static boolean EnableStaminaCapsule;
    public static int StaminaCapsuleCooldownType;
    public static int StaminaCapsuleMaxStack;
    public static boolean EnableMiscCapsule;
    public static int MiscCapsuleMaxStack;
    public static boolean EnableRegenCapsules;
    public static int RegenCapsuleCooldownType;
    public static int RegenCapsuleMaxStack;
    public static int KiBaseStrength;
    public static int KiBaseCooldown;
    public static int KiSuperStrength;
    public static int KiSuperCooldown;
    public static int KiMegaStrength;
    public static int KiMegaCooldown;
    public static int KiGigaStrength;
    public static int KiGigaCooldown;
    public static int KiSuperiorStrength;
    public static int KiSuperiorCooldown;
    public static int KiMasterStrength;
    public static int KiMasterCooldown;
    public static int HealthBaseStrength;
    public static int HealthBaseCooldown;
    public static int HealthSuperStrength;
    public static int HealthSuperCooldown;
    public static int HealthMegaStrength;
    public static int HealthMegaCooldown;
    public static int HealthGigaStrength;
    public static int HealthGigaCooldown;
    public static int HealthSuperiorStrength;
    public static int HealthSuperiorCooldown;
    public static int HealthMasterStrength;
    public static int HealthMasterCooldown;
    public static int StaminaBaseStrength;
    public static int StaminaBaseCooldown;
    public static int StaminaSuperStrength;
    public static int StaminaSuperCooldown;
    public static int StaminaMegaStrength;
    public static int StaminaMegaCooldown;
    public static int StaminaGigaStrength;
    public static int StaminaGigaCooldown;
    public static int StaminaSuperiorStrength;
    public static int StaminaSuperiorCooldown;
    public static int StaminaMasterStrength;
    public static int StaminaMasterCooldown;
    public static byte RegenHPBaseStrength;
    public static int RegenHPBaseUseTime;
    public static int RegenHPBaseCooldown;
    public static byte RegenHPSuperStrength;
    public static int RegenHPSuperUseTime;
    public static int RegenHPSuperCooldown;
    public static byte RegenHPMegaStrength;
    public static int RegenHPMegaUseTime;
    public static int RegenHPMegaCooldown;
    public static byte RegenKiBaseStrength;
    public static int RegenKiBaseUseTime;
    public static int RegenKiBaseCooldown;
    public static byte RegenKiSuperStrength;
    public static int RegenKiSuperUseTime;
    public static int RegenKiSuperCooldown;
    public static byte RegenKiMegaStrength;
    public static int RegenKiMegaUseTime;
    public static int RegenKiMegaCooldown;
    public static byte RegenStaminaBaseStrength;
    public static int RegenStaminaBaseUseTime;
    public static int RegenStaminaBaseCooldown;
    public static byte RegenStaminaSuperStrength;
    public static int RegenStaminaSuperUseTime;
    public static int RegenStaminaSuperCooldown;
    public static byte RegenStaminaMegaStrength;
    public static int RegenStaminaMegaUseTime;
    public static int RegenStaminaMegaCooldown;
    public static int KOCooldown;
    public static int ReviveCooldown;
    public static int HeatCooldown;
    public static int PowerPointCooldown;
    public static int AbsorptionCooldown;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            config.setCategoryComment(CAPSULES, "All Capsule Strength configs are in PERCENT Restored. All cooldowns are in seconds.");
            EnableCapsules = config.get(CAPSULES, "Enable Capsules", true).getBoolean(true);
            EnableCapsuleCooldowns = config.get(CAPSULES, "Enable Capsule Cooldowns", true, "All Cooldowns are in SECONDS").getBoolean(true);
            EnableMiscCapsule = config.get(CAPSULES, "Misc Capsules", true, "Misc Capsules: Revive, Heat, KO").getBoolean(true);
            MiscCapsuleMaxStack = config.get(CAPSULES, "Misc Capsule Max Stack Size", 16, "Max Stack Size per Misc Capsules").getInt(16);
            EnableKiCapsule = config.get(CAPSULES, "Ki Capsules", true, "Enable Ki Capsules").getBoolean(true);
            KiCapsuleCooldownType = config.get(CAPSULES, "Ki Capsule Cooldown", 0, "0 - Cooldowns are per Type [All Ki Capsules],\n1 - Cooldowns are per Tier [Individual Ki Capsule Tier]").getInt(0);
            KiCapsuleMaxStack = config.get(CAPSULES, "Ki Capsule Max Stack Size", 16, "Max Stack Size per Ki Capsules").getInt(16);
            EnableHealthCapsule = config.get(CAPSULES, "Health Capsules", true, "Enable Health Capsule").getBoolean(true);
            HealthCapsuleCooldownType = config.get(CAPSULES, "Health Capsule Cooldown", 0, "0 - Cooldowns are per Type [All Health Capsules],\n1 - Cooldowns are per Tier [Individual Health Capsule Tier]").getInt(0);
            HealthCapsuleMaxStack = config.get(CAPSULES, "Health Capsule Max Stack Size", 16, "Max Stack Size per Health Capsule").getInt(16);
            EnableStaminaCapsule = config.get(CAPSULES, "Stamina Capsules", true, "Enable Stamina Capsules").getBoolean(true);
            StaminaCapsuleCooldownType = config.get(CAPSULES, "Stamina Capsule Cooldown", 0, "0 - Cooldowns are per Type [All Stamina Capsules],\n1 - Cooldowns are per Tier [Individual Stamina Capsule Tier]").getInt(0);
            StaminaCapsuleMaxStack = config.get(CAPSULES, "Stamina Capsule Max Stack Size", 16, "Max Stack Size per Stamina Capsule").getInt(16);
            EnableRegenCapsules = config.get(CAPSULES, "Regen Capsules", true, "Enable Regen Capsules").getBoolean(true);
            RegenCapsuleCooldownType = config.get(CAPSULES, "Regen Capsule Cooldown", 2, "0 - Cooldowns are per Type [All Regen Capsules], \n1 - Cooldowns are per Tier [Individual Regen Capsule Type and Tier], \n2 - Cooldowns are per Regen Type [HP, Ki and Stamina regens have separate cooldowns]").getInt(2);
            RegenCapsuleMaxStack = config.get(CAPSULES, "Regen Capsule Max Stack Size", 16, "Max Stack Size per Regen Capsule").getInt(16);
            KiCapsuleCooldownType = ValueUtil.clamp((int)KiCapsuleCooldownType, (int)0, (int)1);
            HealthCapsuleCooldownType = ValueUtil.clamp((int)HealthCapsuleCooldownType, (int)0, (int)1);
            StaminaCapsuleCooldownType = ValueUtil.clamp((int)StaminaCapsuleCooldownType, (int)0, (int)1);
            RegenCapsuleCooldownType = ValueUtil.clamp((int)RegenCapsuleCooldownType, (int)0, (int)2);
            KiCapsuleMaxStack = ValueUtil.clamp((int)KiCapsuleMaxStack, (int)1, (int)64);
            HealthCapsuleMaxStack = ValueUtil.clamp((int)HealthCapsuleMaxStack, (int)1, (int)64);
            StaminaCapsuleMaxStack = ValueUtil.clamp((int)StaminaCapsuleMaxStack, (int)1, (int)64);
            RegenCapsuleMaxStack = ValueUtil.clamp((int)RegenCapsuleMaxStack, (int)1, (int)64);
            KiBaseStrength = config.get(KI, "1. Base Ki Strength", 5).getInt(5);
            KiBaseCooldown = config.get(KI, "1. Base Ki Cooldown", 10).getInt(10);
            KiSuperStrength = config.get(KI, "2. Super Ki Strength", 10).getInt(10);
            KiSuperCooldown = config.get(KI, "2. Super Ki Cooldown", 10).getInt(10);
            KiMegaStrength = config.get(KI, "3. Mega Ki Strength", 25).getInt(25);
            KiMegaCooldown = config.get(KI, "3. Mega Ki Cooldown", 10).getInt(10);
            KiGigaStrength = config.get(KI, "4. Giga Ki Strength", 50).getInt(50);
            KiGigaCooldown = config.get(KI, "4. Giga Ki Cooldown", 10).getInt(10);
            KiSuperiorStrength = config.get(KI, "5. Superior Ki Strength", 75).getInt(75);
            KiSuperiorCooldown = config.get(KI, "5. Superior Ki Cooldown", 10).getInt(10);
            KiMasterStrength = config.get(KI, "6. Master Ki Strength", 100).getInt(100);
            KiMasterCooldown = config.get(KI, "6. Master Ki Cooldown", 10).getInt(10);
            HealthBaseStrength = config.get(HEALTH, "1. Base Health Strength", 5).getInt(5);
            HealthBaseCooldown = config.get(HEALTH, "1. Base Health Cooldown", 10).getInt(10);
            HealthSuperStrength = config.get(HEALTH, "2. Super Health Strength", 10).getInt(10);
            HealthSuperCooldown = config.get(HEALTH, "2. Super Health Cooldown", 10).getInt(10);
            HealthMegaStrength = config.get(HEALTH, "3. Mega Health Strength", 25).getInt(25);
            HealthMegaCooldown = config.get(HEALTH, "3. Mega Health Cooldown", 10).getInt(10);
            HealthGigaStrength = config.get(HEALTH, "4. Giga Health Strength", 50).getInt(50);
            HealthGigaCooldown = config.get(HEALTH, "4. Giga Health Cooldown", 10).getInt(10);
            HealthSuperiorStrength = config.get(HEALTH, "5. Superior Health Strength", 75).getInt(75);
            HealthSuperiorCooldown = config.get(HEALTH, "5. Superior Health Cooldown", 10).getInt(10);
            HealthMasterStrength = config.get(HEALTH, "6. Master Health Strength", 100).getInt(100);
            HealthMasterCooldown = config.get(HEALTH, "6. Master Health Cooldown", 10).getInt(10);
            StaminaBaseStrength = config.get(STAMINA, "1. Base Stamina Strength", 5).getInt(5);
            StaminaBaseCooldown = config.get(STAMINA, "1. Base Stamina Cooldown", 10).getInt(10);
            StaminaSuperStrength = config.get(STAMINA, "2. Super Stamina Strength", 10).getInt(10);
            StaminaSuperCooldown = config.get(STAMINA, "2. Super Stamina Cooldown", 10).getInt(10);
            StaminaMegaStrength = config.get(STAMINA, "3. Mega Stamina Strength", 25).getInt(25);
            StaminaMegaCooldown = config.get(STAMINA, "3. Mega Stamina Cooldown", 10).getInt(10);
            StaminaGigaStrength = config.get(STAMINA, "4. Giga Stamina Strength", 50).getInt(50);
            StaminaGigaCooldown = config.get(STAMINA, "4. Giga Stamina Cooldown", 10).getInt(10);
            StaminaSuperiorStrength = config.get(STAMINA, "5. Superior Stamina Strength", 75).getInt(75);
            StaminaSuperiorCooldown = config.get(STAMINA, "5. Superior Stamina Cooldown", 10).getInt(10);
            StaminaMasterStrength = config.get(STAMINA, "6. Master Stamina Strength", 100).getInt(100);
            StaminaMasterCooldown = config.get(STAMINA, "6. Master Stamina Cooldown", 10).getInt(10);
            config.setCategoryComment(REGEN, "Regen Capsules use time  are in seconds and strength is percent restored per second");
            RegenHPBaseStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "1. Base HP Regen Strength", 1).getInt(1), (int)1, (int)127);
            RegenHPBaseUseTime = ValueUtil.clamp((int)config.get(REGEN, "1. Base HP Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenHPBaseCooldown = ValueUtil.clamp((int)config.get(REGEN, "1. Base HP Regen Cooldown", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenHPSuperStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "2. Super HP Regen Strength", 2).getInt(2), (int)1, (int)127);
            RegenHPSuperUseTime = ValueUtil.clamp((int)config.get(REGEN, "2. Super HP Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenHPSuperCooldown = ValueUtil.clamp((int)config.get(REGEN, "2. Super HP Regen Cooldown", 20).getInt(20), (int)1, (int)Integer.MAX_VALUE);
            RegenHPMegaStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "3. Mega HP Regen Strength", 3).getInt(3), (int)1, (int)127);
            RegenHPMegaUseTime = ValueUtil.clamp((int)config.get(REGEN, "3. Mega HP Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenHPMegaCooldown = ValueUtil.clamp((int)config.get(REGEN, "3. Mega HP Regen Cooldown", 30).getInt(30), (int)1, (int)Integer.MAX_VALUE);
            RegenKiBaseStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "4. Base Ki Regen Strength", 1).getInt(1), (int)1, (int)127);
            RegenKiBaseUseTime = ValueUtil.clamp((int)config.get(REGEN, "4. Base Ki Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenKiBaseCooldown = ValueUtil.clamp((int)config.get(REGEN, "4. Base Ki Regen Cooldown", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenKiSuperStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "5. Super Ki Regen Strength", 2).getInt(2), (int)1, (int)127);
            RegenKiSuperUseTime = ValueUtil.clamp((int)config.get(REGEN, "5. Super Ki Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenKiSuperCooldown = ValueUtil.clamp((int)config.get(REGEN, "5. Super Ki Regen Cooldown", 20).getInt(20), (int)1, (int)Integer.MAX_VALUE);
            RegenKiMegaStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "6. Mega Ki Regen Strength", 3).getInt(3), (int)1, (int)127);
            RegenKiMegaUseTime = ValueUtil.clamp((int)config.get(REGEN, "6. Mega Ki Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenKiMegaCooldown = ValueUtil.clamp((int)config.get(REGEN, "6. Mega Ki Regen Cooldown", 30).getInt(30), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaBaseStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "7. Base Stamina Regen Strength", 1).getInt(1), (int)1, (int)127);
            RegenStaminaBaseUseTime = ValueUtil.clamp((int)config.get(REGEN, "7. Base Stamina Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaBaseCooldown = ValueUtil.clamp((int)config.get(REGEN, "7. Base Stamina Regen Cooldown", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaSuperStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "8. Super Stamina Regen Strength", 2).getInt(2), (int)1, (int)127);
            RegenStaminaSuperUseTime = ValueUtil.clamp((int)config.get(REGEN, "8. Super Stamina Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaSuperCooldown = ValueUtil.clamp((int)config.get(REGEN, "8. Super Stamina Regen Cooldown", 20).getInt(20), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaMegaStrength = (byte)ValueUtil.clamp((int)config.get(REGEN, "9. Mega Stamina Regen Strength", 3).getInt(3), (int)1, (int)127);
            RegenStaminaMegaUseTime = ValueUtil.clamp((int)config.get(REGEN, "9. Mega Stamina Regen Use Time", 10).getInt(10), (int)1, (int)Integer.MAX_VALUE);
            RegenStaminaMegaCooldown = ValueUtil.clamp((int)config.get(REGEN, "9. Mega Stamina Regen Cooldown", 30).getInt(30), (int)1, (int)Integer.MAX_VALUE);
            KOCooldown = config.get(MISC, "Ko Cooldown", 10).getInt(10);
            ReviveCooldown = config.get(MISC, "Revive Cooldown", 10).getInt(10);
            HeatCooldown = config.get(MISC, "Heat Cooldown", 10).getInt(10);
            PowerPointCooldown = config.get(MISC, "PowerPoint Cooldown", 10, "Only usable by Arcosians to restore PP Value").getInt(10);
            AbsorptionCooldown = config.get(MISC, "Absorption Cooldown", 10, "Only usable by Majins to restore absorption").getInt(10);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"DBC Addon has had a problem loading its capsule configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        EnableCapsules = true;
        EnableCapsuleCooldowns = true;
        EnableKiCapsule = true;
        KiCapsuleCooldownType = 0;
        KiCapsuleMaxStack = 16;
        EnableHealthCapsule = true;
        HealthCapsuleCooldownType = 0;
        HealthCapsuleMaxStack = 16;
        EnableStaminaCapsule = true;
        StaminaCapsuleCooldownType = 0;
        StaminaCapsuleMaxStack = 16;
        EnableMiscCapsule = true;
        MiscCapsuleMaxStack = 16;
        EnableRegenCapsules = true;
        RegenCapsuleCooldownType = 2;
        RegenCapsuleMaxStack = 16;
        KiBaseStrength = 5;
        KiBaseCooldown = 10;
        KiSuperStrength = 10;
        KiSuperCooldown = 10;
        KiMegaStrength = 25;
        KiMegaCooldown = 10;
        KiGigaStrength = 50;
        KiGigaCooldown = 10;
        KiSuperiorStrength = 75;
        KiSuperiorCooldown = 10;
        KiMasterStrength = 100;
        KiMasterCooldown = 10;
        HealthBaseStrength = 5;
        HealthBaseCooldown = 10;
        HealthSuperStrength = 10;
        HealthSuperCooldown = 10;
        HealthMegaStrength = 25;
        HealthMegaCooldown = 10;
        HealthGigaStrength = 50;
        HealthGigaCooldown = 10;
        HealthSuperiorStrength = 75;
        HealthSuperiorCooldown = 10;
        HealthMasterStrength = 100;
        HealthMasterCooldown = 10;
        StaminaBaseStrength = 5;
        StaminaBaseCooldown = 10;
        StaminaSuperStrength = 10;
        StaminaSuperCooldown = 10;
        StaminaMegaStrength = 25;
        StaminaMegaCooldown = 10;
        StaminaGigaStrength = 50;
        StaminaGigaCooldown = 10;
        StaminaSuperiorStrength = 75;
        StaminaSuperiorCooldown = 10;
        StaminaMasterStrength = 100;
        StaminaMasterCooldown = 10;
        RegenHPBaseStrength = 1;
        RegenHPBaseUseTime = 10;
        RegenHPBaseCooldown = 10;
        RegenHPSuperStrength = (byte)2;
        RegenHPSuperUseTime = 10;
        RegenHPSuperCooldown = 20;
        RegenHPMegaStrength = (byte)3;
        RegenHPMegaUseTime = 10;
        RegenHPMegaCooldown = 30;
        RegenKiBaseStrength = 1;
        RegenKiBaseUseTime = 10;
        RegenKiBaseCooldown = 10;
        RegenKiSuperStrength = (byte)2;
        RegenKiSuperUseTime = 10;
        RegenKiSuperCooldown = 20;
        RegenKiMegaStrength = (byte)3;
        RegenKiMegaUseTime = 10;
        RegenKiMegaCooldown = 30;
        RegenStaminaBaseStrength = 1;
        RegenStaminaBaseUseTime = 10;
        RegenStaminaBaseCooldown = 10;
        RegenStaminaSuperStrength = (byte)2;
        RegenStaminaSuperUseTime = 10;
        RegenStaminaSuperCooldown = 20;
        RegenStaminaMegaStrength = (byte)3;
        RegenStaminaMegaUseTime = 10;
        RegenStaminaMegaCooldown = 30;
        KOCooldown = 10;
        ReviveCooldown = 10;
        HeatCooldown = 10;
        PowerPointCooldown = 10;
        AbsorptionCooldown = 10;
    }
}

