/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.hud.formWheel.icon;

import JinRyuu.JRMCore.server.config.dbc.JGConfigUltraInstinct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import kamkeel.npcdbc.client.gui.hud.formWheel.HUDFormWheel;
import kamkeel.npcdbc.client.utils.Color;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes2D;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.aura.AuraDisplay;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.data.form.FormStackable;
import kamkeel.npcdbc.data.npc.KiWeaponData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FormIcon
extends Gui {
    public static final String PREFIX = "npcdbc:textures/gui/hud/formwheel/icon";
    public static final ResourceLocation bodyIcon = new ResourceLocation("npcdbc:textures/gui/hud/formwheel/icon/body.png");
    public static final ResourceLocation hairIcon = new ResourceLocation("npcdbc:textures/gui/hud/formwheel/icon/hairs.png");
    public static final ResourceLocation auraIcon = new ResourceLocation("npcdbc:textures/gui/hud/formwheel/icon/auras.png");
    public HUDFormWheel parent;
    public Color hairColor = new Color(0, 1.0f);
    public Color auraColor = new Color(11393254, 1.0f);
    public float width = 16.0f;
    public float height = 16.0f;
    private AuraIconType aura;
    private BodyIconType body;
    private HairIconType hair;

    public FormIcon(HUDFormWheel parent, Form formToCopy) {
        boolean isHumanoid;
        this.parent = parent;
        boolean isLegendary = parent.dbcData.isForm(25);
        boolean isDivine = parent.dbcData.isForm(26);
        boolean isMajin = parent.dbcData.isForm(27);
        FormStackable stackable = formToCopy.stackable;
        FormController formController = FormController.Instance;
        if (formController.has(stackable.divineID) && isDivine) {
            formToCopy = (Form)formController.get(stackable.divineID);
        } else if (formController.has(stackable.legendaryID) && isLegendary) {
            formToCopy = (Form)formController.get(stackable.legendaryID);
        } else if (formController.has(stackable.majinID) && isMajin) {
            formToCopy = (Form)formController.get(stackable.majinID);
        }
        this.aura = AuraIconType.DEFAULT;
        this.body = BodyIconType.HUMANOID;
        this.hair = HairIconType.HUMANOID;
        this.auraColor = new Color(11393254, 1.0f);
        this.hairColor = new Color(0, 1.0f);
        FormDisplay display = formToCopy.display;
        byte race = parent.dbcData.Race;
        boolean isEligible = formToCopy.raceEligible((EntityPlayer)parent.player);
        boolean bl = isHumanoid = race == 0 || race == 12 || race == 2 || race == 1;
        if (isHumanoid && isEligible) {
            boolean buff = false;
            if (display.formWidth >= 1.1f || display.formSize >= 1.1f) {
                buff = true;
            }
            if (display.bodyColors.hairColor != -1) {
                this.hairColor = new Color(display.bodyColors.hairColor, 1.0f);
            }
            if (!display.hairType.isEmpty()) {
                if (display.hairType.toLowerCase().contains("ssj3")) {
                    this.hair = buff ? HairIconType.SS3_BUFF : HairIconType.SS3;
                    this.body = buff ? BodyIconType.BUFF : BodyIconType.HUMANOID;
                } else if (display.hairType.toLowerCase().contains("ssj4")) {
                    this.hair = HairIconType.SS4;
                    this.body = BodyIconType.SS4;
                } else if (display.hairType.toLowerCase().contains("oozaru")) {
                    this.hair = HairIconType.OOZARU;
                    this.body = BodyIconType.OOZARU;
                    this.hairColor = new Color(display.bodyColors.furColor == -1 ? 7294519 : display.bodyColors.furColor, 1.0f);
                } else {
                    this.body = buff ? BodyIconType.BUFF : BodyIconType.HUMANOID;
                }
            }
        } else if (race == 4 && isEligible) {
            this.auraColor = new Color(11996430, 1.0f);
            this.hairColor = new Color(display.bodyColors.bodyC2 == -1 ? 10038165 : display.bodyColors.bodyC2, 1.0f);
            if (!display.bodyType.isEmpty()) {
                if (display.bodyType.toLowerCase().contains("first")) {
                    this.body = BodyIconType.ARC_FIRST;
                    this.hair = HairIconType.ARC_FIRST;
                } else if (display.bodyType.toLowerCase().contains("second")) {
                    this.body = BodyIconType.ARC_SECOND;
                    this.hair = HairIconType.ARC_SECOND;
                } else if (display.bodyType.toLowerCase().contains("third")) {
                    this.body = BodyIconType.ARC_THIRD;
                    this.hair = HairIconType.ARC_THIRD;
                } else if (display.bodyType.toLowerCase().contains("final") || display.bodyType.toLowerCase().contains("golden")) {
                    this.body = BodyIconType.ARC_FOURTH;
                    this.hair = HairIconType.ARC_FOURTH;
                } else if (display.bodyType.toLowerCase().contains("ultimate")) {
                    this.body = BodyIconType.ARC_FIFTH;
                    this.hair = HairIconType.ARC_FIFTH;
                }
            } else {
                this.body = BodyIconType.ARC_FIRST;
                this.hair = HairIconType.ARC_FIRST;
            }
        } else if (race == 3 && isEligible) {
            this.hair = HairIconType.NAMEK;
            this.body = BodyIconType.NAMEK;
            this.hairColor = new Color(display.bodyColors.bodyCM == -1 ? 7189562 : display.bodyColors.bodyCM, 1.0f);
        } else if (race == 5 && isEligible) {
            if (display.formSize <= 0.9f || display.formWidth <= 0.9f) {
                this.hair = HairIconType.MAJIN_PURE;
                this.body = BodyIconType.MAJIN_PURE;
            } else {
                this.hair = HairIconType.MAJIN;
                this.body = BodyIconType.MAJIN;
            }
            this.hairColor = new Color(display.bodyColors.bodyCM == -1 ? 0xFAAACC : display.bodyColors.bodyCM, 1.0f);
        } else {
            this.hair = HairIconType.NONE;
            if (display.formSize >= 1.1f || display.formWidth >= 1.1f) {
                this.body = BodyIconType.BUFF;
            }
        }
        int formAuraColor = formToCopy.display.auraColor;
        if (display.hasAura()) {
            this.setAuraType((AuraDisplay)display.getAura().getDisplay(), formAuraColor);
        } else if (formAuraColor != -1) {
            this.auraColor = new Color(formAuraColor, 1.0f);
        }
    }

    public FormIcon(HUDFormWheel parent, int DBCFormID) {
        this.parent = parent;
        boolean isLegendary = parent.dbcData.isForm(25);
        boolean isDivine = parent.dbcData.isForm(26);
        if (DBCFormID >= 20) {
            this.setNonRacialForms(DBCFormID);
            return;
        }
        switch (parent.dbcData.Race) {
            case 0: {
                this.setHumanForms(DBCFormID);
                break;
            }
            case 1: 
            case 2: {
                this.setSaiyanForms(DBCFormID, isLegendary, isDivine);
                break;
            }
            case 3: {
                this.setNamekForms(DBCFormID);
                break;
            }
            case 4: {
                this.setArcoForms(DBCFormID);
                break;
            }
            case 5: {
                this.setMajinForms(DBCFormID);
            }
        }
    }

    public void draw() {
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        GL11.glPushMatrix();
        GL11.glScalef((float)3.5f, (float)3.5f, (float)3.5f);
        if (this.aura != AuraIconType.NONE) {
            renderEngine.func_110577_a(auraIcon);
            this.auraColor.glColor();
            this.drawTexturedRect(-this.width / 2.0f, -this.height / 2.0f, this.width / 2.0f, this.height / 2.0f, this.aura.ordinal(), AuraIconType.values().length - 1);
        }
        if (this.body != BodyIconType.NONE) {
            renderEngine.func_110577_a(bodyIcon);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedRect(-this.width / 2.0f, -this.height / 2.0f, this.width / 2.0f, this.height / 2.0f, this.body.ordinal(), BodyIconType.values().length - 1);
        }
        if (this.hair != HairIconType.NONE) {
            renderEngine.func_110577_a(hairIcon);
            this.hairColor.glColor();
            this.drawTexturedRect(-this.width / 2.0f, -this.height / 2.0f, this.width / 2.0f, this.height / 2.0f, this.hair.ordinal(), HairIconType.values().length - 1);
        }
        GL11.glPopMatrix();
    }

    private void setAuraType(AuraDisplay auraDisplay, int formAuraColor) {
        this.auraColor = new Color(11393254, 1.0f);
        this.auraColor = formAuraColor == -1 ? new Color(KiWeaponData.getColorByAuraType(auraDisplay), 1.0f) : new Color(formAuraColor, 1.0f);
        this.aura = AuraIconType.getAuraType(auraDisplay);
    }

    private void drawTexturedRect(float left, float top, float right, float bottom, int index, int maxIndex) {
        if (maxIndex <= 0) {
            maxIndex = 1;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= maxIndex) {
            index = maxIndex - 1;
        }
        float step = 1.0f / (float)maxIndex;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)left, (double)bottom, (double)this.field_73735_i, (double)(step * (float)index), 1.0);
        tessellator.func_78374_a((double)right, (double)bottom, (double)this.field_73735_i, (double)(step * (float)(index + 1)), 1.0);
        tessellator.func_78374_a((double)right, (double)top, (double)this.field_73735_i, (double)(step * (float)(index + 1)), 0.0);
        tessellator.func_78374_a((double)left, (double)top, (double)this.field_73735_i, (double)(step * (float)index), 0.0);
        tessellator.func_78381_a();
    }

    private void setNonRacialForms(int state) {
        this.aura = AuraIconType.DEFAULT;
        this.body = BodyIconType.HUMANOID;
        this.hair = HairIconType.NONE;
        this.auraColor = new Color(11393254, 1.0f);
        this.hairColor = new Color(0, 1.0f);
        if (state >= 41) {
            this.hair = HairIconType.HUMANOID;
            this.aura = AuraIconType.UI;
            this.auraColor = new Color(0xFFFFFF, 1.0f);
            boolean[] whiteHair = JGConfigUltraInstinct.CONFIG_UI_HAIR_WHITE;
            int index = state - 41;
            if (whiteHair.length > index && whiteHair[index]) {
                this.hairColor = new Color(0xD0D0D0, 1.0f);
            }
            return;
        }
        switch (state) {
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                Aura aur = this.parent.dbcData.getAura();
                if (aur != null && aur.display.kaiokenColor != -1) {
                    this.auraColor = new Color(aur.display.kaiokenColor);
                    break;
                }
                this.auraColor = new Color(11935817, 1.0f).lerpRGBA(new Color(0xFF0000, 1.0f), ((float)state + 0.5f - 30.0f) / 6.0f);
                break;
            }
            case 21: {
                this.auraColor = new Color(0xFFFFFF, 1.0f);
                break;
            }
            case 24: {
                this.aura = AuraIconType.DESTROYER;
                this.auraColor = new Color(9446263, 1.0f);
            }
        }
    }

    private void setHumanForms(int state) {
        this.hairColor = new Color(0, 1.0f);
        this.auraColor = new Color(11393254, 1.0f);
        this.body = BodyIconType.HUMANOID;
        this.hair = HairIconType.NONE;
        this.aura = AuraIconType.DEFAULT;
        if (state == 2) {
            this.auraColor = new Color(16574610, 1.0f);
            this.body = BodyIconType.BUFF;
        }
        if (state == 3) {
            this.aura = AuraIconType.GOD;
            this.auraColor = new Color(16761125, 1.0f);
        }
    }

    private void setSaiyanForms(int state, boolean isLegendary, boolean isDivine) {
        Color basicSSJAuraColor = new Color(isLegendary ? 0x99FF66 : 16574610, 1.0f);
        Color basicSSJHairColor = basicSSJAuraColor.lerpRGBA(new Color(0xFFFF00, 1.0f), 0.3f);
        Color ssbAuraColor = new Color(isDivine ? 7536661 : 2805230, 1.0f);
        Color ssbHairColor = isDivine ? new Color(14985390, 1.0f) : ssbAuraColor.lerpRGBA(new Color(0, 1.0f), 0.2f);
        this.body = BodyIconType.HUMANOID;
        this.hair = HairIconType.HUMANOID;
        this.aura = AuraIconType.DEFAULT;
        this.auraColor = new Color(11393254, 1.0f);
        this.hairColor = new Color(0, 1.0f);
        switch (state) {
            case 2: 
            case 3: {
                this.body = BodyIconType.BUFF;
                this.auraColor = basicSSJAuraColor;
                this.hairColor = basicSSJHairColor;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                this.auraColor = basicSSJAuraColor;
                this.hairColor = basicSSJHairColor;
                break;
            }
            case 6: {
                this.hair = HairIconType.SS3;
                this.body = BodyIconType.SS3;
                this.auraColor = basicSSJAuraColor;
                this.hairColor = basicSSJHairColor;
                break;
            }
            case 7: {
                this.hair = HairIconType.OOZARU;
                this.body = BodyIconType.OOZARU;
                this.hairColor = new Color(4335630, 1.0f);
                break;
            }
            case 8: {
                this.hair = HairIconType.OOZARU;
                this.body = BodyIconType.OOZARU;
                this.auraColor = basicSSJAuraColor;
                this.hairColor = basicSSJHairColor;
                break;
            }
            case 9: {
                this.aura = AuraIconType.GOD;
                this.auraColor = new Color(16761125, 1.0f);
                this.hairColor = new Color(14028139, 1.0f);
                break;
            }
            case 10: {
                this.aura = AuraIconType.GOD;
                this.auraColor = ssbAuraColor;
                this.hairColor = ssbHairColor;
                break;
            }
            case 15: {
                this.aura = AuraIconType.GOD;
                this.body = BodyIconType.BUFF;
                this.auraColor = isDivine ? ssbAuraColor.lerpRGBA(new Color(16542853, 1.0f), 0.6f) : new Color(0x2233FF, 1.0f);
                this.hairColor = isDivine ? ssbHairColor.lerpRGBA(new Color(592137, 1.0f), 0.2f) : new Color(0x2233FF, 1.0f).lerpRGBA(new Color(0, 1.0f), 0.15f);
                break;
            }
            case 14: {
                this.body = BodyIconType.SS4;
                this.hair = HairIconType.SS4;
                this.hairColor = new Color(0, 1.0f);
                this.auraColor = basicSSJAuraColor;
            }
        }
    }

    private void setNamekForms(int state) {
        this.hairColor = new Color(7189562, 1.0f);
        this.auraColor = new Color(16574610, 1.0f);
        this.aura = AuraIconType.DEFAULT;
        this.body = BodyIconType.NAMEK;
        this.hair = HairIconType.NAMEK;
        if (state == 2) {
            this.auraColor = new Color(11393254, 1.0f);
        }
        if (state == 3) {
            this.aura = AuraIconType.GOD;
            this.auraColor = new Color(16761125, 1.0f);
        }
    }

    private void setArcoForms(int state) {
        this.hairColor = new Color(10038165, 1.0f);
        this.auraColor = new Color(11996430, 1.0f);
        this.aura = AuraIconType.DEFAULT;
        this.body = BodyIconType.ARC_FIRST;
        this.hair = HairIconType.ARC_FIRST;
        switch (state) {
            case 2: {
                this.body = BodyIconType.ARC_SECOND;
                this.hair = HairIconType.ARC_SECOND;
                break;
            }
            case 3: {
                this.body = BodyIconType.ARC_THIRD;
                this.hair = HairIconType.ARC_THIRD;
                break;
            }
            case 4: {
                this.body = BodyIconType.ARC_FOURTH;
                this.hair = HairIconType.ARC_FOURTH;
                break;
            }
            case 5: {
                this.body = BodyIconType.ARC_FIFTH;
                this.hair = HairIconType.ARC_FIFTH;
                this.auraColor = new Color(11393254, 1.0f);
                break;
            }
            case 6: {
                this.body = BodyIconType.ARC_FOURTH;
                this.hair = HairIconType.ARC_FOURTH;
                this.aura = AuraIconType.DESTROYER;
                this.auraColor = new Color(0xFFBF00, 1.0f);
                break;
            }
            case 7: {
                this.body = BodyIconType.ARC_FOURTH;
                this.hair = HairIconType.ARC_FOURTH;
                this.aura = AuraIconType.GOD;
                this.auraColor = new Color(16761125, 1.0f);
            }
        }
    }

    private void setMajinForms(int state) {
        this.hairColor = new Color(0xFAAACC, 1.0f);
        this.auraColor = new Color(11393254, 1.0f);
        this.aura = AuraIconType.DEFAULT;
        this.body = BodyIconType.MAJIN;
        this.hair = HairIconType.MAJIN;
        switch (state) {
            case 1: {
                this.auraColor = new Color(0xA6A6A6, 1.0f);
                this.hairColor = new Color(0xA6A6A6, 1.0f);
                break;
            }
            case 3: {
                this.auraColor = new Color(16758465, 1.0f);
                this.body = BodyIconType.MAJIN_PURE;
                this.hair = HairIconType.MAJIN_PURE;
                break;
            }
            case 4: {
                this.aura = AuraIconType.GOD;
                this.auraColor = new Color(16761125, 1.0f);
            }
        }
    }

    private static enum HairIconType {
        HUMANOID,
        SS4,
        SS3,
        SS3_BUFF,
        OOZARU,
        ARC_FIRST,
        ARC_SECOND,
        ARC_THIRD,
        ARC_FOURTH,
        ARC_FIFTH,
        NAMEK,
        MAJIN,
        MAJIN_PURE,
        NONE;

    }

    private static enum BodyIconType {
        HUMANOID,
        SS4,
        SS3,
        BUFF,
        OOZARU,
        ARC_FIRST,
        ARC_SECOND,
        ARC_THIRD,
        ARC_FOURTH,
        ARC_FIFTH,
        NAMEK,
        MAJIN,
        MAJIN_PURE,
        NONE;

    }

    private static enum AuraIconType {
        DEFAULT,
        GOD,
        DESTROYER,
        UI,
        NONE;


        static AuraIconType getAuraType(AuraDisplay display) {
            String name = null;
            if (name == null && display.type != EnumAuraTypes3D.None) {
                name = display.type.getName();
            }
            if (name == null && display.type2D != EnumAuraTypes2D.None) {
                name = display.type2D.getName();
            }
            if (name == null) {
                name = "";
            }
            return AuraIconType.getTypeByName(name);
        }

        private static AuraIconType getTypeByName(String name) {
            switch (name) {
                case "default": 
                case "base": {
                    return DEFAULT;
                }
                case "ssgod": 
                case "ssb": 
                case "shinka": 
                case "ssrose": 
                case "ssroseevo": {
                    return GOD;
                }
                case "jiren": 
                case "mui": 
                case "ui": {
                    return UI;
                }
                case "ultimate": 
                case "godofdestructiontoppo": 
                case "godofdestruction": {
                    return DESTROYER;
                }
            }
            return NONE;
        }
    }
}

