/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.api.lib;

import io.github.cruciblemc.omniconfig.api.OmniconfigAPI;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;

public enum Environment {
    CLIENT,
    DEDICATED_SERVER;


    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public void execute(Supplier<Runnable> code) {
        if (OmniconfigAPI.getEnvironment() == this) {
            code.get().run();
        }
    }

    public static <T> T createProxy(Class<T> commonClass, Class<? extends T> clientClass) {
        try {
            Class<Object> chosenClass = OmniconfigAPI.getEnvironment() == DEDICATED_SERVER ? commonClass : clientClass;
            Constructor<Object> constructor = chosenClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

