/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.mixins.late.impl.npc;

import kamkeel.npcdbc.mixins.late.IKiResistance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import noppes.npcs.Resistances;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Resistances.class}, remap=false)
public abstract class MixinResistances
implements IKiResistance {
    @Shadow(remap=false)
    public boolean disableDamage;
    @Unique
    public float ki = 1.0f;

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    public void writeNBT(CallbackInfoReturnable<NBTTagCompound> cir) {
        NBTTagCompound compound = (NBTTagCompound)cir.getReturnValue();
        if (compound != null) {
            compound.func_74776_a("KiRes", this.ki);
        }
    }

    @Inject(method={"readToNBT"}, at={@At(value="TAIL")}, remap=false)
    public void readNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (compound.func_74764_b("KiRes")) {
            this.ki = compound.func_74760_g("KiRes");
        }
    }

    @Inject(method={"applyResistance"}, at={@At(value="HEAD")}, cancellable=true)
    public void applyKiRes(DamageSource source, float damage, CallbackInfoReturnable<Float> cir) {
        if (!this.disableDamage && (source.field_76373_n.equals("EnergyAttack") || source.field_76373_n.equals("causeEnExplosion"))) {
            cir.setReturnValue((Object)Float.valueOf(damage *= 2.0f - this.ki));
            cir.cancel();
        }
    }

    @Override
    public float getKiResistance() {
        return this.ki;
    }

    @Override
    public void setKiResistance(float newKi) {
        this.ki = newKi;
    }
}

