/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.title;

import io.github.cruciblemc.necrotempus.api.title.TitleType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TitleElement {
    private final IChatComponent text;
    private final TitleType type;

    private TitleElement(IChatComponent text, TitleType type) {
        this.text = text;
        this.type = type;
    }

    public static TitleElement titleOf(IChatComponent text) {
        return new TitleElement(text, TitleType.TITLE);
    }

    public static TitleElement subtitleOf(IChatComponent text) {
        return new TitleElement(text, TitleType.SUBTITLE);
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a("text", this.text.func_150260_c());
        nbtTagCompound.func_74778_a("type", this.type.name());
        return nbtTagCompound;
    }

    public static TitleElement fromCompound(NBTTagCompound tagCompound) {
        return new TitleElement((IChatComponent)new ChatComponentText(tagCompound.func_74779_i("text")), TitleType.of(tagCompound.func_74779_i("type")));
    }

    public IChatComponent getText() {
        return this.text;
    }

    public TitleType getType() {
        return this.type;
    }
}

