/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.mixin.early.impl.client.sign;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import kamkeel.hextext.HexText;
import kamkeel.hextext.api.sign.IHexTextSign;
import kamkeel.hextext.api.sign.SignSide;
import kamkeel.hextext.client.render.FontRenderContext;
import kamkeel.hextext.common.sign.SignUpdatePacket;
import kamkeel.hextext.common.util.SignTextHelper;
import kamkeel.hextext.common.util.StringUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C12PacketUpdateSign;
import net.minecraft.tileentity.TileEntitySign;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={GuiEditSign.class})
public abstract class MixinGuiEditSign
extends GuiScreen {
    @Shadow
    private TileEntitySign field_146848_f;
    @Unique
    public SignSide editSide = SignSide.FRONT;
    @Unique
    public String[] editLines;
    @Unique
    private boolean hextext$rawRenderingActive;

    @Inject(method={"initGui"}, at={@At(value="HEAD")})
    private void initSide(CallbackInfo ci) {
        IHexTextSign hexTextSign = (IHexTextSign)this.field_146848_f;
        this.editSide = hexTextSign.getEditSide();
        this.editLines = hexTextSign.getLines(this.editSide);
        if (HexText.getActiveProxy().convertAmpersandsOnSigns()) {
            for (int i = 0; i < this.editLines.length; ++i) {
                this.editLines[i] = StringUtils.convertSectionSignsToAmpersands(this.editLines[i]);
            }
        }
    }

    @Inject(method={"drawScreen(IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher;renderTileEntityAt(Lnet/minecraft/tileentity/TileEntity;DDDF)V", shift=At.Shift.BEFORE)})
    private void hextext$rotateForBackSide(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        SignSide side = ((IHexTextSign)this.field_146848_f).getEditSide();
        if (side == SignSide.BACK) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @Inject(method={"drawScreen(IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher;renderTileEntityAt(Lnet/minecraft/tileentity/TileEntity;DDDF)V", shift=At.Shift.BEFORE)})
    private void hextext$enableRawRendering(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (HexText.getActiveProxy() == null) {
            return;
        }
        if (!HexText.getActiveProxy().convertAmpersandsOnSigns() && !HexText.getActiveProxy().allowUniversalAmpersand()) {
            return;
        }
        FontRenderContext.pushRawTextRendering();
        HexText.rawRenderingEnabled = true;
        this.hextext$rawRenderingActive = true;
    }

    @Inject(method={"drawScreen(IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher;renderTileEntityAt(Lnet/minecraft/tileentity/TileEntity;DDDF)V", shift=At.Shift.AFTER)})
    private void hextext$disableRawRendering(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (!this.hextext$rawRenderingActive) {
            return;
        }
        FontRenderContext.popRawTextRendering();
        HexText.rawRenderingEnabled = false;
        this.hextext$rawRenderingActive = false;
    }

    @Redirect(method={"keyTyped"}, at=@At(value="FIELD", target="Lnet/minecraft/tileentity/TileEntitySign;signText:[Ljava/lang/String;"))
    private String[] hextext$useCustomSignBuffer(TileEntitySign sign) {
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return this.field_146848_f.field_145915_a;
        }
        return this.editLines;
    }

    @Redirect(method={"keyTyped"}, at=@At(value="INVOKE", target="Ljava/lang/String;length()I", ordinal=2))
    private int hextext$measureVisibleLength(String line) {
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return line.length();
        }
        return SignTextHelper.visibleLength(line);
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="HEAD")}, cancellable=true)
    private void hextext$sendExtendedPacket(CallbackInfo ci) {
        ci.cancel();
        Keyboard.enableRepeatEvents((boolean)false);
        NetHandlerPlayClient handler = this.field_146297_k.func_147114_u();
        if (HexText.getActiveProxy().convertAmpersandsOnSigns()) {
            for (int i = 0; i < this.editLines.length; ++i) {
                String converted;
                this.editLines[i] = converted = StringUtils.convertAmpersandsToSectionSigns(this.editLines[i]);
            }
        }
        if (handler != null) {
            C12PacketUpdateSign packet = new C12PacketUpdateSign(this.field_146848_f.field_145851_c, this.field_146848_f.field_145848_d, this.field_146848_f.field_145849_e, this.editLines);
            ((SignUpdatePacket)packet).setSide(this.editSide);
            handler.func_147297_a((Packet)packet);
        }
        this.field_146848_f.func_145913_a(true);
    }
}

