/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public final class HexTextConfig {
    public static final String CATEGORY_EFFECTS = "effects";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_SIGN_MODIFIERS = "server.signModifiers";
    private static final float DEFAULT_RAINBOW_SPEED = 3000.0f;
    private static final int DEFAULT_SHAKE_INTERVAL = 50;
    private static final int DEFAULT_IGNITE_INTERVAL = 700;
    private static final boolean DEFAULT_ENABLE_RGB_HTML_FORMAT = false;
    private static final boolean DEFAULT_ALLOW_SIGN_EDITING = true;
    private static final boolean DEFAULT_UNIVERSAL_AMPERSAND = false;
    private static final boolean DEFAULT_CHAT_AMPERSAND_CONVERSION = true;
    private static final boolean DEFAULT_SIGN_AMPERSAND_CONVERSION = true;
    private static final boolean DEFAULT_REPAIR_AMPERSAND_CONVERSION = true;
    private static final boolean DEFAULT_GLOWSTONE_DUST_GLOW = true;
    private static final boolean DEFAULT_REDSTONE_DUST_OUTLINE = true;
    private static final boolean DEFAULT_SLIMEBALL_WAX = true;
    private static final boolean DEFAULT_INK_SAC_CLEANSE = true;
    private static final float MIN_RAINBOW_SPEED = 1.0f;
    private static final int MIN_SHAKE_INTERVAL = 1;
    private static final int MIN_IGNITE_INTERVAL = 1;
    private static final int MAX_SHAKE_INTERVAL = 1000;
    private static final int MAX_IGNITE_INTERVAL = 1000;
    private static final float MAX_RAINBOW_SPEED = 5000.0f;
    private static Configuration configuration;
    private static float rainbowSpeed;
    private static int shakeInterval;
    private static int igniteInterval;
    private static boolean enableRgbHtmlFormat;
    private static boolean allowSignEditing;
    private static boolean universalAmpersand;
    private static boolean chatAmpersandConversion;
    private static boolean signAmpersandConversion;
    private static boolean repairAmpersandConversion;
    private static boolean enableGlowstoneDustGlow;
    private static boolean enableRedstoneDustOutline;
    private static boolean enableSlimeballWax;
    private static boolean enableInkSacCleanse;

    private HexTextConfig() {
    }

    public static void init(File file) {
        if (configuration == null) {
            configuration = new Configuration(file);
        }
        HexTextConfig.sync();
    }

    public static void sync() {
        if (configuration == null) {
            return;
        }
        configuration.load();
        configuration.addCustomCategoryComment(CATEGORY_EFFECTS, "Timing controls for HexText's dynamic formatting effects.");
        configuration.addCustomCategoryComment(CATEGORY_SERVER, "Server-side behavioural toggles for HexText formatting and sign editing.");
        configuration.addCustomCategoryComment(CATEGORY_SIGN_MODIFIERS, "Enable or disable the built-in HexText sign modifier items.");
        rainbowSpeed = HexTextConfig.clamp(configuration.getFloat("rainbowCycleDurationMs", CATEGORY_EFFECTS, 3000.0f, 1.0f, 5000.0f, "Milliseconds required for the rainbow effect to rotate through the full spectrum. Lower values move faster."), 1.0f, 5000.0f);
        shakeInterval = HexTextConfig.clamp(configuration.getInt("shakeUpdateIntervalMs", CATEGORY_EFFECTS, 50, 1, 1000, "Milliseconds between shake offset updates. Lower values produce a more frantic shake."), 1, 1000);
        igniteInterval = HexTextConfig.clamp(configuration.getInt("igniteBlinkIntervalMs", CATEGORY_EFFECTS, 700, 1, 1000, "Milliseconds for ignite to fade from bright to dim and back again. Lower values animate faster."), 1, 1000);
        enableRgbHtmlFormat = configuration.getBoolean("enableRgbHtmlFormat", CATEGORY_SERVER, false, "Allow the <RRGGBB> and </RRGGBB> HTML-style colour tags to be parsed.");
        allowSignEditing = configuration.getBoolean("allowSignEditing", CATEGORY_SERVER, true, "Permit players to open the sign editor by right-clicking with an empty hand.");
        universalAmpersand = configuration.getBoolean("universalAmpersandFormatting", CATEGORY_SERVER, false, "Allow & as an alternative to the section sign when entering formatting codes.");
        chatAmpersandConversion = configuration.getBoolean("ampersandsInChat", CATEGORY_SERVER, true, "Convert & formatting tokens to section signs when sending chat or commands.");
        signAmpersandConversion = configuration.getBoolean("ampersandsInSigns", CATEGORY_SERVER, true, "Convert & formatting tokens to section signs when editing signs.");
        repairAmpersandConversion = configuration.getBoolean("ampersandsInRepairs", CATEGORY_SERVER, true, "Convert & formatting tokens to section signs when renaming items in anvils.");
        enableGlowstoneDustGlow = configuration.getBoolean("enableGlowstoneDustGlowModifier", CATEGORY_SIGN_MODIFIERS, true, "Allow glowstone dust to apply the glowing text modifier to signs.");
        enableRedstoneDustOutline = configuration.getBoolean("enableRedstoneDustOutlineModifier", CATEGORY_SIGN_MODIFIERS, true, "Allow redstone dust to apply the outlined text modifier to signs.");
        enableSlimeballWax = configuration.getBoolean("enableSlimeballWaxModifier", CATEGORY_SIGN_MODIFIERS, true, "Allow slimeballs to wax signs and preserve their current styling.");
        enableInkSacCleanse = configuration.getBoolean("enableInkSacCleanseModifier", CATEGORY_SIGN_MODIFIERS, true, "Allow ink sacs to cleanse glowing and outlined effects from signs.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static float getRainbowSpeed() {
        return rainbowSpeed;
    }

    public static int getShakeInterval() {
        return shakeInterval;
    }

    public static int getIgniteInterval() {
        return igniteInterval;
    }

    public static boolean isRgbHtmlFormatEnabled() {
        return enableRgbHtmlFormat;
    }

    public static boolean isSignEditingAllowed() {
        return allowSignEditing;
    }

    public static boolean isUniversalAmpersandEnabled() {
        return universalAmpersand;
    }

    public static boolean isChatAmpersandConversionEnabled() {
        return chatAmpersandConversion;
    }

    public static boolean isSignAmpersandConversionEnabled() {
        return signAmpersandConversion;
    }

    public static boolean isRepairAmpersandConversionEnabled() {
        return repairAmpersandConversion;
    }

    public static boolean isGlowstoneDustGlowEnabled() {
        return enableGlowstoneDustGlow;
    }

    public static boolean isRedstoneDustOutlineEnabled() {
        return enableRedstoneDustOutline;
    }

    public static boolean isSlimeballWaxEnabled() {
        return enableSlimeballWax;
    }

    public static boolean isInkSacCleanseEnabled() {
        return enableInkSacCleanse;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static void setEnableRgbHtmlFormat(boolean enabled) {
        enableRgbHtmlFormat = enabled;
    }

    public static void setAllowSignEditing(boolean allowed) {
        allowSignEditing = allowed;
    }

    public static void setUniversalAmpersandEnabled(boolean enabled) {
        universalAmpersand = enabled;
    }

    public static void setChatAmpersandConversionEnabled(boolean enabled) {
        chatAmpersandConversion = enabled;
    }

    public static void setSignAmpersandConversionEnabled(boolean enabled) {
        signAmpersandConversion = enabled;
    }

    public static void setRepairAmpersandConversionEnabled(boolean enabled) {
        repairAmpersandConversion = enabled;
    }

    public static void resetToDefaults() {
        rainbowSpeed = 3000.0f;
        shakeInterval = 50;
        igniteInterval = 700;
        enableRgbHtmlFormat = false;
        allowSignEditing = true;
        universalAmpersand = false;
        chatAmpersandConversion = true;
        signAmpersandConversion = true;
        repairAmpersandConversion = true;
        enableGlowstoneDustGlow = true;
        enableRedstoneDustOutline = true;
        enableSlimeballWax = true;
        enableInkSacCleanse = true;
    }

    private static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    private static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    static {
        rainbowSpeed = 3000.0f;
        shakeInterval = 50;
        igniteInterval = 700;
        enableRgbHtmlFormat = false;
        allowSignEditing = true;
        universalAmpersand = false;
        chatAmpersandConversion = true;
        signAmpersandConversion = true;
        repairAmpersandConversion = true;
        enableGlowstoneDustGlow = true;
        enableRedstoneDustOutline = true;
        enableSlimeballWax = true;
        enableInkSacCleanse = true;
    }
}

