/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.util;

import kamkeel.hextext.common.util.ColorCodeUtils;
import kamkeel.hextext.common.util.ColorMath;

public final class TextEffectMath {
    private static final float RAINBOW_SATURATION = 0.9f;
    private static final float RAINBOW_LIGHTEN_RATIO = 0.18f;

    private TextEffectMath() {
    }

    public static int computeRainbowColor(long now, double rainbowSpeed, int charIndex, int anchorIndex, float spread) {
        double safeSpeed = rainbowSpeed < 1.0 ? 1.0 : rainbowSpeed;
        double timeDegrees = (double)now / safeSpeed * 360.0;
        float hueDegrees = (float)((double)((float)(charIndex - anchorIndex) * spread) + timeDegrees);
        int base = ColorCodeUtils.hsvToRgb(hueDegrees, 0.9f, 1.0f);
        return ColorMath.blend(base, 0xFFFFFF, 0.18f);
    }

    public static float computeIgniteBrightness(long now, long interval, float minimumFactor) {
        long safeInterval = interval <= 0L ? 1L : interval;
        long period = safeInterval * 2L;
        long phase = now % period;
        if (phase < 0L) {
            phase += period;
        }
        float progress = phase <= safeInterval ? 1.0f - (float)phase / (float)safeInterval : (float)(phase - safeInterval) / (float)safeInterval;
        float minClamp = minimumFactor < 0.0f ? 0.0f : (minimumFactor > 1.0f ? 1.0f : minimumFactor);
        return minClamp + (1.0f - minClamp) * progress;
    }

    public static long computeShakeSeed(int charIndex, long now, long frameWindow) {
        long safeFrame = frameWindow <= 0L ? 1L : frameWindow;
        return (long)charIndex * 341873128712L ^ now / safeFrame;
    }

    public static float computeShakeOffset(long seed, float range) {
        float safeRange;
        float f = safeRange = range < 0.0f ? 0.0f : range;
        if (safeRange == 0.0f) {
            return 0.0f;
        }
        long mixed = TextEffectMath.mix(seed);
        float normalized = (float)(mixed >>> 40 & 0xFFFFFFL) / 1.6777215E7f;
        return (normalized * 2.0f - 1.0f) * safeRange;
    }

    private static long mix(long value) {
        value ^= value >>> 33;
        value *= -49064778989728563L;
        value ^= value >>> 33;
        value *= -4265267296055464877L;
        value ^= value >>> 33;
        return value;
    }
}

