/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.util;

import kamkeel.hextext.common.util.ColorCodeUtils;
import kamkeel.hextext.common.util.StringUtils;
import net.minecraft.util.ChatAllowedCharacters;

public final class SignTextHelper {
    public static final int SIGN_LINE_VISIBLE_LIMIT = 15;

    private SignTextHelper() {
    }

    public static int visibleLength(CharSequence text) {
        if (text == null) {
            return 0;
        }
        int visible = 0;
        ColorCodeUtils.FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        int index = 0;
        while (index < text.length()) {
            int codeLength = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, index, env);
            if (codeLength > 0) {
                index += codeLength;
                continue;
            }
            ++visible;
            ++index;
        }
        return visible;
    }

    public static String clampToVisibleLimit(String text) {
        int codeLength;
        if (text == null || text.isEmpty()) {
            return text;
        }
        ColorCodeUtils.FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        int index = 0;
        int visible = 0;
        while (index < text.length()) {
            int codeLength2 = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, index, env);
            if (codeLength2 > 0) {
                index += codeLength2;
                continue;
            }
            if (visible >= 15) break;
            ++visible;
            ++index;
        }
        if (index >= text.length()) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text.length());
        int copyIndex = 0;
        visible = 0;
        while (copyIndex < text.length()) {
            codeLength = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, copyIndex, env);
            if (codeLength > 0) {
                builder.append(text, copyIndex, copyIndex + codeLength);
                copyIndex += codeLength;
                continue;
            }
            if (visible >= 15) break;
            builder.append(text.charAt(copyIndex));
            ++visible;
            ++copyIndex;
        }
        while (copyIndex < text.length() && (codeLength = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, copyIndex, env)) > 0) {
            builder.append(text, copyIndex, copyIndex + codeLength);
            copyIndex += codeLength;
        }
        return builder.toString();
    }

    public static void copyText(String[] src, String[] dst) {
        if (dst == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            String s = src != null && i < src.length ? src[i] : "";
            dst[i] = s == null ? "" : s;
        }
    }

    public static void copyTextClamped(String[] src, String[] dst) {
        if (dst == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            String s = src != null && i < src.length ? src[i] : "";
            dst[i] = SignTextHelper.clampToVisibleLimit(s == null ? "" : s);
        }
    }

    public static void copyTextSanitizedClamped(String[] src, String[] dst) {
        if (dst == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            String s;
            String string = s = src != null && i < src.length ? src[i] : "";
            if (s == null) {
                s = "";
            }
            s = SignTextHelper.signedAllowCharacters(s);
            dst[i] = SignTextHelper.clampToVisibleLimit(s);
        }
    }

    public static String signedAllowCharacters(String input) {
        char[] achar;
        StringBuilder stringbuilder = new StringBuilder();
        for (char c0 : achar = input.toCharArray()) {
            if (!ChatAllowedCharacters.func_71566_a((char)c0) && c0 != StringUtils.SECTION_SIGN) continue;
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }
}

