/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.util;

import kamkeel.hextext.CommonProxy;
import kamkeel.hextext.HexText;

public final class ColorCodeUtils {
    private ColorCodeUtils() {
    }

    public static FormattingEnvironment captureFormattingEnvironment(boolean rawMode) {
        CommonProxy proxy = HexText.getActiveProxy();
        boolean allowHtml = proxy == null || proxy.allowHtmlFormatting();
        boolean allowAmpersand = rawMode || proxy == null || proxy.allowUniversalAmpersand();
        return new FormattingEnvironment(allowHtml, allowAmpersand);
    }

    public static FormattingEnvironment captureFormattingEnvironment() {
        return ColorCodeUtils.captureFormattingEnvironment(false);
    }

    public static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean isValidHexString(String hex) {
        if (hex == null || hex.length() != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (ColorCodeUtils.isValidHexChar(hex.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidHexString(CharSequence str, int start) {
        if (str == null || start < 0 || start + 6 > str.length()) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (ColorCodeUtils.isValidHexChar(str.charAt(start + i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFormattingCode(char c) {
        char lower = Character.toLowerCase(c);
        return ColorCodeUtils.isMinecraftColorCode(lower) || lower == 'g' || lower == 'h' || lower == 'i' || lower == 'j' || ColorCodeUtils.isStyleCode(lower) || ColorCodeUtils.isResetCode(lower);
    }

    public static boolean isMinecraftColorCode(char c) {
        char lower = Character.toLowerCase(c);
        return lower >= '0' && lower <= '9' || lower >= 'a' && lower <= 'f';
    }

    public static int getMinecraftColorIndex(char c) {
        char lower = Character.toLowerCase(c);
        if (lower >= '0' && lower <= '9') {
            return lower - 48;
        }
        if (lower >= 'a' && lower <= 'f') {
            return 10 + (lower - 97);
        }
        return -1;
    }

    public static boolean isStyleCode(char c) {
        char lower = Character.toLowerCase(c);
        return lower == 'k' || lower == 'l' || lower == 'm' || lower == 'n' || lower == 'o';
    }

    public static boolean isEffectCode(char c) {
        char lower = Character.toLowerCase(c);
        return lower == 'g' || lower == 'h' || lower == 'i' || lower == 'j';
    }

    public static boolean isResetCode(char c) {
        return Character.toLowerCase(c) == 'r';
    }

    public static boolean isHexColorToken(CharSequence input, int index, int codeLen) {
        if (input == null || codeLen <= 0 || index < 0 || index + codeLen > input.length()) {
            return false;
        }
        char start = input.charAt(index);
        if (codeLen == 8 && (start == '&' || start == '\u00a7')) {
            return true;
        }
        if (start == '<') {
            return codeLen == 8 || codeLen == 9;
        }
        if (codeLen == 2 && (start == '&' || start == '\u00a7')) {
            char fmt = Character.toLowerCase(input.charAt(index + 1));
            return ColorCodeUtils.isMinecraftColorCode(fmt) || fmt == 'g';
        }
        return false;
    }

    public static boolean isStandardColorToken(CharSequence input, int index, int codeLen) {
        if (input == null || codeLen != 2 || index < 0 || index + codeLen > input.length()) {
            return false;
        }
        char start = input.charAt(index);
        if (start != '&' && start != '\u00a7') {
            return false;
        }
        char fmt = Character.toLowerCase(input.charAt(index + 1));
        return ColorCodeUtils.isMinecraftColorCode(fmt) || fmt == 'g';
    }

    public static boolean isStyleOrEffectToken(CharSequence input, int index, int codeLen) {
        if (input == null || codeLen != 2 || index < 0 || index + codeLen > input.length()) {
            return false;
        }
        char start = input.charAt(index);
        if (start != '&' && start != '\u00a7') {
            return false;
        }
        char fmt = Character.toLowerCase(input.charAt(index + 1));
        return ColorCodeUtils.isStyleCode(fmt) || ColorCodeUtils.isEffectCode(fmt);
    }

    public static int detectAmpersandFormattingCodeLength(CharSequence text, int index) {
        if (text == null || index < 0 || index >= text.length() - 1) {
            return 0;
        }
        if (text.charAt(index) != '&') {
            return 0;
        }
        char next = text.charAt(index + 1);
        if (next == '#') {
            return index + 8 <= text.length() && ColorCodeUtils.isValidHexString(text, index + 2) ? 8 : 0;
        }
        return ColorCodeUtils.isFormattingCode(next) ? 2 : 0;
    }

    public static int parseHexColor(String hex) {
        if (!ColorCodeUtils.isValidHexString(hex)) {
            return -1;
        }
        try {
            return Integer.parseInt(hex, 16) & 0xFFFFFF;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int parseHexColor(CharSequence str, int start) {
        if (!ColorCodeUtils.isValidHexString(str, start)) {
            return -1;
        }
        try {
            String hex = str.subSequence(start, start + 6).toString();
            return Integer.parseInt(hex, 16) & 0xFFFFFF;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return -1;
        }
    }

    public static int detectColorCodeLength(CharSequence str, int pos, boolean rawMode) {
        return ColorCodeUtils.detectColorCodeLength(str, pos, rawMode, ColorCodeUtils.captureFormattingEnvironment(rawMode));
    }

    public static int detectColorCodeLength(CharSequence str, int pos, boolean rawMode, FormattingEnvironment env) {
        if (env == null) {
            env = ColorCodeUtils.captureFormattingEnvironment(rawMode);
        }
        return ColorCodeUtils.detectColorCodeLengthInternal(str, pos, rawMode, env.allowsHtmlFormatting(), env.allowsUniversalAmpersand());
    }

    public static int detectColorCodeLength(CharSequence str, int pos) {
        return ColorCodeUtils.detectColorCodeLength(str, pos, false);
    }

    public static int detectColorCodeLengthIgnoringRaw(CharSequence str, int pos) {
        return ColorCodeUtils.detectColorCodeLength(str, pos, false);
    }

    public static int detectColorCodeLengthIgnoringRaw(CharSequence str, int pos, FormattingEnvironment env) {
        return ColorCodeUtils.detectColorCodeLength(str, pos, false, env);
    }

    public static int detectColorCodeLength(CharSequence str, int pos, boolean rawMode, boolean allowHtml, boolean allowAmpersand) {
        return ColorCodeUtils.detectColorCodeLengthInternal(str, pos, rawMode, allowHtml, allowAmpersand);
    }

    private static int detectColorCodeLengthInternal(CharSequence str, int pos, boolean rawMode, boolean allowHtml, boolean allowAmpersand) {
        if (str == null || pos < 0 || pos >= str.length() || rawMode) {
            return 0;
        }
        char c = str.charAt(pos);
        if (c == '\u00a7') {
            if (pos + 2 <= str.length() && str.charAt(pos + 1) == '#' && pos + 8 <= str.length() && ColorCodeUtils.isValidHexString(str, pos + 2)) {
                return 8;
            }
            if (pos + 1 < str.length() && ColorCodeUtils.isFormattingCode(str.charAt(pos + 1))) {
                return 2;
            }
            return 0;
        }
        if (c == '&') {
            if (!allowAmpersand) {
                return 0;
            }
            if (pos + 2 <= str.length() && str.charAt(pos + 1) == '#' && pos + 8 <= str.length() && ColorCodeUtils.isValidHexString(str, pos + 2)) {
                return 8;
            }
            if (pos + 1 < str.length() && ColorCodeUtils.isFormattingCode(str.charAt(pos + 1))) {
                return 2;
            }
            return 0;
        }
        if (allowHtml && c == '<' && pos + 9 <= str.length() && str.charAt(pos + 1) == '/' && str.charAt(pos + 8) == '>' && ColorCodeUtils.isValidHexString(str, pos + 2)) {
            return 9;
        }
        if (allowHtml && c == '<' && pos + 8 <= str.length() && str.charAt(pos + 7) == '>' && ColorCodeUtils.isValidHexString(str, pos + 1)) {
            return 8;
        }
        return 0;
    }

    public static int calculateShadowColor(int rgb) {
        return (rgb & 0xFCFCFC) >> 2;
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        float b;
        float g;
        float r;
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        if (saturation == 0.0f) {
            int gray = (int)(value * 255.0f);
            return gray << 16 | gray << 8 | gray;
        }
        float h = hue / 60.0f;
        int sector = (int)Math.floor(h);
        float fractionalSector = h - (float)sector;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - saturation * fractionalSector);
        float t = value * (1.0f - saturation * (1.0f - fractionalSector));
        switch (sector) {
            case 0: {
                r = value;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = value;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = value;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = value;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = value;
                break;
            }
            default: {
                r = value;
                g = p;
                b = q;
            }
        }
        int red = (int)(r * 255.0f);
        int green = (int)(g * 255.0f);
        int blue = (int)(b * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static boolean containsFormattingCodes(CharSequence input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        for (int index = 0; index < input.length(); ++index) {
            if (ColorCodeUtils.detectColorCodeLengthIgnoringRaw(input, index, env) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int indexOfNextFormattingCode(CharSequence input, int start) {
        if (input == null || start < 0 || start >= input.length()) {
            return -1;
        }
        FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        for (int index = start; index < input.length(); ++index) {
            if (ColorCodeUtils.detectColorCodeLengthIgnoringRaw(input, index, env) <= 0) continue;
            return index;
        }
        return -1;
    }

    public static final class FormattingEnvironment {
        private final boolean allowHtmlFormatting;
        private final boolean allowUniversalAmpersand;

        private FormattingEnvironment(boolean allowHtmlFormatting, boolean allowUniversalAmpersand) {
            this.allowHtmlFormatting = allowHtmlFormatting;
            this.allowUniversalAmpersand = allowUniversalAmpersand;
        }

        public boolean allowsHtmlFormatting() {
            return this.allowHtmlFormatting;
        }

        public boolean allowsUniversalAmpersand() {
            return this.allowUniversalAmpersand;
        }
    }
}

