/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.sign;

import kamkeel.hextext.api.sign.SignSide;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntitySign;

public final class SignSideHelper {
    private SignSideHelper() {
    }

    public static SignSide determineSide(TileEntitySign sign, double playerX, double playerZ, float hitX, float hitZ) {
        double dot;
        double centerX = (double)sign.field_145851_c + 0.5;
        double centerZ = (double)sign.field_145849_e + 0.5;
        Block block = sign.func_145838_q();
        int metadata = sign.func_145832_p();
        double vecX = playerX - centerX;
        double vecZ = playerZ - centerZ;
        if (block == Blocks.field_150472_an) {
            if (SignSideHelper.isNearlyZero(vecX) && SignSideHelper.isNearlyZero(vecZ)) {
                vecX = (double)hitX - 0.5;
                vecZ = (double)hitZ - 0.5;
            }
            if (SignSideHelper.isNearlyZero(vecX) && SignSideHelper.isNearlyZero(vecZ)) {
                return SignSide.FRONT;
            }
            return SignSideHelper.isFacingFrontStanding(vecX, vecZ, metadata) ? SignSide.FRONT : SignSide.BACK;
        }
        double[] normal = SignSideHelper.computeWallFrontNormal(metadata);
        if (SignSideHelper.isNearlyZero(vecX) && SignSideHelper.isNearlyZero(vecZ)) {
            vecX = normal[0];
            vecZ = normal[1];
        }
        return (dot = vecX * normal[0] + vecZ * normal[1]) >= 0.0 ? SignSide.FRONT : SignSide.BACK;
    }

    private static boolean isFacingFrontStanding(double vecX, double vecZ, int metadata) {
        double facingAngle;
        double playerAngle = Math.atan2(vecZ, vecX);
        double delta = SignSideHelper.normalizeRadians(playerAngle - (facingAngle = SignSideHelper.computeStandingFacingAngle(metadata)));
        return Math.abs(delta) <= 1.5707963267948966;
    }

    private static double computeStandingFacingAngle(int metadata) {
        double rotationDegrees = (double)metadata * 360.0 / 16.0;
        double radians = Math.toRadians(rotationDegrees);
        return SignSideHelper.normalizeRadians(radians + 1.5707963267948966);
    }

    private static double[] computeWallFrontNormal(int metadata) {
        switch (metadata) {
            case 2: {
                return new double[]{0.0, -1.0};
            }
            case 3: {
                return new double[]{0.0, 1.0};
            }
            case 4: {
                return new double[]{-1.0, 0.0};
            }
            case 5: {
                return new double[]{1.0, 0.0};
            }
        }
        return new double[]{0.0, 1.0};
    }

    private static double normalizeRadians(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    private static boolean isNearlyZero(double value) {
        return Math.abs(value) < 1.0E-6;
    }
}

