/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.render;

import kamkeel.hextext.api.rendering.TokenHighlightService;
import kamkeel.hextext.common.util.ColorCodeUtils;

public final class HighlightComputations {
    private HighlightComputations() {
    }

    public static float measureLiteralWidth(TokenHighlightService.WidthProvider provider, CharSequence text, int start, int length) {
        if (provider == null || text == null || length <= 0 || start < 0 || start >= text.length()) {
            return 0.0f;
        }
        int end = Math.min(start + length, text.length());
        if (end <= start) {
            return 0.0f;
        }
        String segment = text.subSequence(start, end).toString();
        return provider.getStringWidth(segment);
    }

    public static int getTokenHighlightColor(CharSequence text, int index) {
        char c = text.charAt(index);
        if (c == '\u00a7' || c == '&' && index + 1 < text.length() && ColorCodeUtils.isFormattingCode(text.charAt(index + 1))) {
            return 809533695;
        }
        if (c == '&') {
            return 809093231;
        }
        if (c == '<') {
            if (index + 1 < text.length() && text.charAt(index + 1) == '/') {
                return 822053978;
            }
            return 811240703;
        }
        return 0x30222222;
    }
}

