/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.compat;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AngelicaCompatibility {
    private static final Logger LOGGER = LogManager.getLogger((String)"HexText|AngelicaCompat");
    private static final String ANGELICA_MOD_ID = "angelica";
    private static final String ANGELICA_FONT_RENDERER_MIXIN = "com.gtnewhorizons.angelica.mixins.early.angelica.fontrenderer.MixinFontRenderer";
    private static final String ANGELICA_MIXINS_ENUM = "com.gtnewhorizons.angelica.mixins.Mixins";
    private static final String ANGELICA_FONT_RENDERER_ENUM = "ANGELICA_FONT_RENDERER";
    private static final String MIXIN_BUILDER_CLASS = "com.gtnewhorizon.gtnhmixins.builders.MixinBuilder";
    private static final String ANGELICA_CONFIG_CLASS = "com.gtnewhorizons.angelica.config.AngelicaConfig";
    private static final String ANGELICA_FONT_CONFIG_FIELD = "enableFontRenderer";
    private static volatile Boolean cachedResult;

    private AngelicaCompatibility() {
    }

    public static boolean shouldDisableHexTextFontRendererMixin() {
        Boolean result = cachedResult;
        if (result != null) {
            return result;
        }
        cachedResult = result = Boolean.valueOf(AngelicaCompatibility.detectAngelicaFontRendererMixin());
        return result;
    }

    private static boolean detectAngelicaFontRendererMixin() {
        if (!AngelicaCompatibility.isAngelicaPresent()) {
            return false;
        }
        if (!AngelicaCompatibility.isClassPresent(ANGELICA_FONT_RENDERER_MIXIN)) {
            LOGGER.info("Angelica detected but no font renderer mixin class present; keeping HexText mixin enabled.");
            return false;
        }
        Boolean builderDecision = AngelicaCompatibility.queryMixinBuilderState();
        if (builderDecision != null) {
            if (!builderDecision.booleanValue()) {
                LOGGER.info("Angelica font renderer mixin reported as disabled by builder state; keeping HexText mixin enabled.");
                return false;
            }
            LOGGER.info("Angelica font renderer mixin reported as active; disabling HexText font renderer mixin.");
            return true;
        }
        Boolean configDecision = AngelicaCompatibility.readAngelicaFontRendererConfig();
        if (configDecision != null) {
            if (!configDecision.booleanValue()) {
                LOGGER.info("Angelica font renderer mixin disabled through configuration; keeping HexText mixin enabled.");
                return false;
            }
            LOGGER.info("Angelica font renderer mixin enabled through configuration; disabling HexText font renderer mixin.");
            return true;
        }
        return false;
    }

    private static boolean isAngelicaPresent() {
        try {
            return Loader.isModLoaded((String)ANGELICA_MOD_ID);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to query Forge mod loader for Angelica presence", t);
            return AngelicaCompatibility.isClassPresent("com.gtnewhorizons.angelica.AngelicaMod");
        }
    }

    private static Boolean queryMixinBuilderState() {
        try {
            Class<?> mixinsEnum = Class.forName(ANGELICA_MIXINS_ENUM, false, AngelicaCompatibility.class.getClassLoader());
            if (!mixinsEnum.isEnum()) {
                return null;
            }
            Object fontEntry = Enum.valueOf(mixinsEnum, ANGELICA_FONT_RENDERER_ENUM);
            Object builder = mixinsEnum.getMethod("getBuilder", new Class[0]).invoke(fontEntry, new Object[0]);
            if (builder == null) {
                return null;
            }
            Class<?> builderClass = Class.forName(MIXIN_BUILDER_CLASS, false, builder.getClass().getClassLoader());
            Set<String> mixinNames = AngelicaCompatibility.extractMixinNames(builder, builderClass);
            if (!mixinNames.contains("angelica.fontrenderer.MixinFontRenderer")) {
                return Boolean.FALSE;
            }
            Boolean decision = AngelicaCompatibility.evaluateBuilderApplicability(builder, builderClass);
            if (decision != null) {
                return decision;
            }
        }
        catch (LinkageError | ReflectiveOperationException ex) {
            LOGGER.debug("Unable to query Angelica mixin builder state", ex);
        }
        return null;
    }

    private static Set<String> extractMixinNames(Object builder, Class<?> builderClass) throws ReflectiveOperationException {
        Object raw = null;
        try {
            raw = builderClass.getMethod("getClientMixins", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (raw == null) {
            for (String candidate : Arrays.asList("clientMixins", "getClientMixinClasses", "getMixins")) {
                try {
                    raw = builderClass.getMethod(candidate, new Class[0]).invoke(builder, new Object[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (raw instanceof String[]) {
            return new HashSet<String>(Arrays.asList((String[])raw));
        }
        if (raw instanceof Collection) {
            Collection collection = (Collection)raw;
            HashSet<String> values = new HashSet<String>();
            for (Object entry : collection) {
                if (!(entry instanceof String)) continue;
                values.add((String)entry);
            }
            return values;
        }
        return Collections.emptySet();
    }

    private static Boolean evaluateBuilderApplicability(Object builder, Class<?> builderClass) throws ReflectiveOperationException {
        for (String candidate : Arrays.asList("shouldApply", "shouldApplyMixins", "isEnabled")) {
            try {
                Object value = builderClass.getMethod(candidate, new Class[0]).invoke(builder, new Object[0]);
                if (!(value instanceof Boolean)) continue;
                return (Boolean)value;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private static Boolean readAngelicaFontRendererConfig() {
        try {
            Class<?> config = Class.forName(ANGELICA_CONFIG_CLASS, false, AngelicaCompatibility.class.getClassLoader());
            Field field = config.getField(ANGELICA_FONT_CONFIG_FIELD);
            if (field.getType() == Boolean.TYPE) {
                return field.getBoolean(null);
            }
        }
        catch (ReflectiveOperationException ex) {
            LOGGER.debug("Unable to query Angelica font renderer configuration", (Throwable)ex);
        }
        return null;
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, AngelicaCompatibility.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return false;
        }
    }
}

