/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import java.util.List;
import kamkeel.hextext.api.rendering.HighlightSpan;
import kamkeel.hextext.api.rendering.TokenHighlightService;
import kamkeel.hextext.common.render.HighlightComputations;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.MathHelper;

public final class TokenHighlightUtils {
    private TokenHighlightUtils() {
    }

    public static float measureLiteralWidth(TokenHighlightService.WidthProvider provider, CharSequence text, int start, int length) {
        return HighlightComputations.measureLiteralWidth(provider, text, start, length);
    }

    public static float measureLiteralWidth(FontRenderer renderer, CharSequence text, int start, int length) {
        return TokenHighlightUtils.measureLiteralWidth(renderer == null ? null : arg_0 -> ((FontRenderer)renderer).func_78256_a(arg_0), text, start, length);
    }

    public static int getTokenHighlightColor(CharSequence text, int index) {
        return HighlightComputations.getTokenHighlightColor(text, index);
    }

    public static void drawHighlights(List<? extends HighlightSpan> highlights, int fontHeight) {
        if (highlights == null || highlights.isEmpty()) {
            return;
        }
        for (HighlightSpan highlightSpan : highlights) {
            TokenHighlightUtils.drawHighlight(highlightSpan, fontHeight);
        }
    }

    private static void drawHighlight(HighlightSpan highlight, int fontHeight) {
        float left = highlight.getX();
        float right = highlight.getX() + highlight.getWidth();
        float top = highlight.getY() - 1.0f;
        float bottom = highlight.getY() + (float)fontHeight;
        int x1 = MathHelper.func_76141_d((float)left);
        int y1 = MathHelper.func_76141_d((float)top);
        int x2 = MathHelper.func_76123_f((float)right);
        int y2 = MathHelper.func_76123_f((float)bottom);
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)highlight.getColor());
    }
}

