/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import kamkeel.hextext.api.sign.IHexTextSign;
import kamkeel.hextext.api.sign.SignSide;
import kamkeel.hextext.client.render.font.GlowingTextRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntitySign;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderSignPipeline {
    public static void renderTextForSide(TileEntitySign sign, IHexTextSign state, FontRenderer fontRenderer, SignSide side, float scale, float baseLightU, float baseLightV) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(0.5f * scale), (float)(side == SignSide.FRONT ? 0.07f * scale : -0.07f * scale));
        if (side == SignSide.BACK) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        float fontScale = 0.016666668f * scale;
        GL11.glScalef((float)fontScale, (float)(-fontScale), (float)fontScale);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * fontScale));
        boolean glowing = state.isGlowing(side);
        boolean outlined = state.isOutlined(side);
        GL11.glDepthMask((boolean)false);
        boolean changedLightmap = false;
        if (glowing) {
            GL11.glDisable((int)2896);
            if (OpenGlHelper.lastBrightnessX != 240.0f || OpenGlHelper.lastBrightnessY != 240.0f) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                changedLightmap = true;
            }
        }
        GlowingTextRenderer.setOutlineEnabled(outlined);
        String[] lines = state.getLines(side);
        int baseY = -lines.length * 5;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == sign.field_145918_i) {
                line = "> " + line + " <";
            }
            int lineWidth = fontRenderer.func_78256_a(line);
            fontRenderer.func_78276_b(line, -lineWidth / 2, i * 10 + baseY, 0);
        }
        GlowingTextRenderer.setOutlineEnabled(false);
        GL11.glDepthMask((boolean)true);
        if (glowing) {
            GL11.glEnable((int)2896);
            if (changedLightmap) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)baseLightU, (float)baseLightV);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

