/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import kamkeel.hextext.client.render.FormattedTextMetrics;
import kamkeel.hextext.common.util.ColorCodeUtils;
import kamkeel.hextext.common.util.StringUtils;
import net.minecraft.client.gui.FontRenderer;

public final class FontRendererUtils {
    private FontRendererUtils() {
    }

    public static float getCharWidth(FontRenderer renderer, char chr, boolean rawMode) {
        if (chr == '\u00a7') {
            return 0.0f;
        }
        return renderer.func_78263_a(chr);
    }

    public static float calculateMaxLineWidth(FontRenderer renderer, String text, boolean rawMode) {
        return FormattedTextMetrics.calculateMaxLineWidth(text, rawMode, character -> FontRendererUtils.getCharWidth(renderer, character, rawMode), 0.0f, 1.0f);
    }

    public static int computeLineBreakIndex(FontRenderer renderer, String text, int maxWidth, boolean rawMode) {
        return FormattedTextMetrics.computeLineBreakIndex(text, maxWidth, rawMode, character -> FontRendererUtils.getCharWidth(renderer, character, rawMode), 0.0f, 1.0f);
    }

    public static String trimStringFromEnd(FontRenderer renderer, String text, int width, boolean rawMode) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        float currentWidth = 0.0f;
        int firstSafePosition = text.length();
        boolean bold = false;
        int index = text.length() - 1;
        while (index >= 0) {
            char chr = text.charAt(index);
            if (!rawMode) {
                char fmt;
                if (index >= 6 && text.charAt(index - 6) == '&' && ColorCodeUtils.isValidHexString(text, index - 5)) {
                    firstSafePosition = (index -= 7) + 1;
                    bold = false;
                    continue;
                }
                if (index >= 1 && text.charAt(index - 1) == '\u00a7') {
                    char fmt2 = Character.toLowerCase(chr);
                    if (fmt2 == 'l') {
                        bold = true;
                    } else if (fmt2 == 'r' || ColorCodeUtils.isMinecraftColorCode(fmt2)) {
                        bold = false;
                    }
                    firstSafePosition = (index -= 2) + 1;
                    continue;
                }
                if (index >= 7 && text.charAt(index - 7) == '<' && text.charAt(index) == '>' && ColorCodeUtils.isValidHexString(text, index - 6)) {
                    firstSafePosition = (index -= 8) + 1;
                    bold = false;
                    continue;
                }
                if (index >= 8 && text.charAt(index - 8) == '<' && text.charAt(index - 7) == '/' && text.charAt(index) == '>' && ColorCodeUtils.isValidHexString(text, index - 6)) {
                    firstSafePosition = (index -= 9) + 1;
                    bold = false;
                    continue;
                }
                if (index >= 1 && text.charAt(index - 1) == '&' && ColorCodeUtils.isFormattingCode(fmt = Character.toLowerCase(chr))) {
                    if (fmt == 'l') {
                        bold = true;
                    } else if (fmt == 'r' || ColorCodeUtils.isMinecraftColorCode(fmt)) {
                        bold = false;
                    }
                    firstSafePosition = (index -= 2) + 1;
                    continue;
                }
            }
            if (chr == '\n') {
                return text.substring(index + 1);
            }
            float glyphWidth = FontRendererUtils.getCharWidth(renderer, chr, rawMode);
            if (glyphWidth < 0.0f) {
                glyphWidth = 0.0f;
            }
            float nextWidth = currentWidth + glyphWidth;
            if (bold && glyphWidth > 0.0f) {
                nextWidth += 1.0f;
            }
            if (nextWidth > (float)width) {
                return text.substring(firstSafePosition);
            }
            currentWidth = nextWidth;
            firstSafePosition = index--;
        }
        return text;
    }

    public static String wrapFormattedString(FontRenderer renderer, String text, int wrapWidth, boolean rawMode) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int breakPoint = FontRendererUtils.computeLineBreakIndex(renderer, text, wrapWidth, rawMode);
        if (breakPoint >= text.length()) {
            return text;
        }
        String firstPart = text.substring(0, breakPoint);
        char breakChar = text.charAt(breakPoint);
        boolean skipChar = breakChar == ' ' || breakChar == '\n';
        String remainder = StringUtils.extractFormatFromString(firstPart) + text.substring(breakPoint + (skipChar ? 1 : 0));
        if (remainder.length() == text.length()) {
            return firstPart + "\n" + remainder;
        }
        return firstPart + "\n" + FontRendererUtils.wrapFormattedString(renderer, remainder, wrapWidth, rawMode);
    }
}

