/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import java.util.ArrayDeque;
import java.util.Deque;
import kamkeel.hextext.client.render.TextEffectController;
import kamkeel.hextext.common.util.ColorCodeUtils;

public final class ColorStateTracker {
    private final Deque<Integer> colorStack = new ArrayDeque<Integer>();
    private final Deque<Integer> effectBaseStack = new ArrayDeque<Integer>();
    private int baseColor;
    private int currentColor;
    private boolean shadowPass;

    public void begin(int baseColor, boolean shadowPass) {
        this.currentColor = this.baseColor = baseColor & 0xFFFFFF;
        this.shadowPass = shadowPass;
        this.colorStack.clear();
        this.effectBaseStack.clear();
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public int getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentColor(int color) {
        this.currentColor = color & 0xFFFFFF;
    }

    public int applyRgb(int rgb, boolean clearStacks, TextEffectController effects, boolean renderingShadow) {
        int applied;
        if (clearStacks) {
            this.wipeStacks();
        }
        this.currentColor = applied = this.convert(rgb);
        this.resetEffects(effects, renderingShadow, applied);
        return applied;
    }

    public int applyVanillaColor(int colorIndex, int[] palette, boolean clearStacks, TextEffectController effects, boolean renderingShadow) {
        if (clearStacks) {
            this.wipeStacks();
        }
        int applied = this.baseColor;
        int clampedIndex = Math.max(0, Math.min(colorIndex, 15));
        if (palette != null) {
            int paletteIndex;
            int n = paletteIndex = this.shadowPass ? clampedIndex + 16 : clampedIndex;
            if (paletteIndex >= 0 && paletteIndex < palette.length) {
                applied = palette[paletteIndex] & 0xFFFFFF;
            }
        }
        this.currentColor = applied;
        this.resetEffects(effects, renderingShadow, applied);
        return applied;
    }

    public int push(int rgb, TextEffectController effects, boolean renderingShadow) {
        int applied;
        this.colorStack.push(this.currentColor);
        if (effects != null) {
            this.effectBaseStack.push(effects.getBaseColor());
            effects.resetDynamicEffects();
        }
        this.currentColor = applied = this.convert(rgb);
        if (effects != null && !renderingShadow) {
            effects.updateBaseColor(applied);
        }
        return applied;
    }

    public int pop(TextEffectController effects, boolean renderingShadow) {
        int n = this.currentColor = this.colorStack.isEmpty() ? this.baseColor : this.colorStack.pop();
        if (effects != null) {
            int base;
            effects.resetDynamicEffects();
            int n2 = base = this.effectBaseStack.isEmpty() ? this.baseColor : this.effectBaseStack.pop();
            if (!renderingShadow) {
                effects.updateBaseColor(base);
            }
        }
        return this.currentColor;
    }

    public int resetToBase(TextEffectController effects, boolean renderingShadow) {
        this.wipeStacks();
        this.currentColor = this.baseColor;
        this.resetEffects(effects, renderingShadow, this.baseColor);
        return this.currentColor;
    }

    public void clearStacks() {
        this.wipeStacks();
    }

    private int convert(int rgb) {
        int color = rgb & 0xFFFFFF;
        return this.shadowPass ? ColorCodeUtils.calculateShadowColor(color) : color;
    }

    private void wipeStacks() {
        this.colorStack.clear();
        this.effectBaseStack.clear();
    }

    private void resetEffects(TextEffectController effects, boolean renderingShadow, int applied) {
        if (effects == null) {
            return;
        }
        effects.resetDynamicEffects();
        if (!renderingShadow) {
            effects.updateBaseColor(applied);
        }
    }
}

