/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.api;

import kamkeel.hextext.api.HexTextApiProvider;
import kamkeel.hextext.api.rendering.ColorService;
import kamkeel.hextext.api.rendering.DynamicEffectService;
import kamkeel.hextext.api.rendering.RenderingEnvironmentService;
import kamkeel.hextext.api.rendering.TextRenderService;
import kamkeel.hextext.api.rendering.TokenHighlightService;
import kamkeel.hextext.api.sign.SignInteractionRegistry;
import kamkeel.hextext.api.sign.SignStateService;
import kamkeel.hextext.api.text.SignTextService;
import kamkeel.hextext.api.text.TextFormatter;
import kamkeel.hextext.api.text.TextSanitizer;

public final class HexTextApi {
    public static final String API_VERSION = "1.1.0";
    private static volatile HexTextApiProvider provider = UninitializedProvider.INSTANCE;

    private HexTextApi() {
    }

    public static void installProvider(HexTextApiProvider implementation) {
        if (implementation == null) {
            throw new NullPointerException("HexTextApiProvider cannot be null");
        }
        if (provider != UninitializedProvider.INSTANCE) {
            throw new IllegalStateException("HexText API provider has already been installed");
        }
        provider = implementation;
    }

    public static String apiVersion() {
        return API_VERSION;
    }

    public static String modVersion() {
        return HexTextApi.provider().modVersion();
    }

    public static SignInteractionRegistry signInteractions() {
        return HexTextApi.provider().signInteractions();
    }

    public static SignTextService signText() {
        return HexTextApi.provider().signText();
    }

    public static TextFormatter textFormatter() {
        return HexTextApi.provider().textFormatter();
    }

    public static TextSanitizer textSanitizer() {
        return HexTextApi.provider().textSanitizer();
    }

    public static TextRenderService textRenderer() {
        return HexTextApi.provider().textRenderer();
    }

    public static TokenHighlightService tokenHighlighter() {
        return HexTextApi.provider().tokenHighlighter();
    }

    public static SignStateService signState() {
        return HexTextApi.provider().signState();
    }

    public static RenderingEnvironmentService renderEnvironment() {
        return HexTextApi.provider().renderEnvironment();
    }

    public static DynamicEffectService dynamicEffects() {
        return HexTextApi.provider().dynamicEffects();
    }

    public static ColorService colors() {
        return HexTextApi.provider().colors();
    }

    private static HexTextApiProvider provider() {
        HexTextApiProvider result = provider;
        if (result == UninitializedProvider.INSTANCE) {
            throw new IllegalStateException("HexText API has not been initialized yet");
        }
        return result;
    }

    private static enum UninitializedProvider implements HexTextApiProvider
    {
        INSTANCE;


        @Override
        public String modVersion() {
            throw this.failure();
        }

        @Override
        public SignInteractionRegistry signInteractions() {
            throw this.failure();
        }

        @Override
        public SignTextService signText() {
            throw this.failure();
        }

        @Override
        public TextFormatter textFormatter() {
            throw this.failure();
        }

        @Override
        public TextSanitizer textSanitizer() {
            throw this.failure();
        }

        @Override
        public TextRenderService textRenderer() {
            throw this.failure();
        }

        @Override
        public TokenHighlightService tokenHighlighter() {
            throw this.failure();
        }

        @Override
        public SignStateService signState() {
            throw this.failure();
        }

        @Override
        public RenderingEnvironmentService renderEnvironment() {
            throw this.failure();
        }

        @Override
        public DynamicEffectService dynamicEffects() {
            throw this.failure();
        }

        @Override
        public ColorService colors() {
            throw this.failure();
        }

        private IllegalStateException failure() {
            return new IllegalStateException("HexText API accessed before provider installation");
        }
    }
}

