/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.config.ConfigScript;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.INpcScriptHandler;

public class ForgeDataScript
implements INpcScriptHandler {
    private List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    private String scriptLanguage = "ECMAScript";
    public long lastInited = -1L;
    private long lastForgeUpdate = -1L;
    private boolean enabled = false;

    public void clear() {
        this.scripts = new ArrayList<ScriptContainer>();
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = compound.func_74764_b("Scripts") ? NBTTags.GetScriptOld(compound.func_150295_c("Scripts", 10), this) : NBTTags.GetScript(compound, this);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        if (!ScriptController.Instance.languages.containsKey(this.scriptLanguage)) {
            this.scriptLanguage = !ScriptController.Instance.languages.isEmpty() ? (String)ScriptController.Instance.languages.keySet().toArray()[0] : "ECMAScript";
        }
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("TotalScripts", this.scripts.size());
        for (int i = 0; i < this.scripts.size(); ++i) {
            compound.func_74782_a("Tab" + i, (NBTBase)this.scripts.get(i).writeToNBT(new NBTTagCompound()));
        }
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    @Override
    public void callScript(EnumScriptType var1, Event var2) {
        this.callScript(var1.function, var2);
    }

    @Override
    public void callScript(String type, Event event) {
        if (this.isEnabled()) {
            if (ScriptController.Instance.lastLoaded > this.lastInited || ScriptController.Instance.lastForgeUpdate > this.lastForgeUpdate) {
                this.lastInited = ScriptController.Instance.lastLoaded;
                this.lastForgeUpdate = ScriptController.Instance.lastForgeUpdate;
                for (ScriptContainer script : this.scripts) {
                    script.errored = false;
                }
                if (!type.equals("init")) {
                    EventHooks.onForgeInit(this);
                }
            }
            for (ScriptContainer script : this.scripts) {
                if (script == null || script.errored || !script.hasCode()) continue;
                script.run(type, (Object)event);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled && ConfigScript.GlobalForgeScripts && ScriptController.HasStart && this.scripts.size() > 0;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setScripts(List<ScriptContainer> list) {
        this.scripts = list;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        return "ForgeScript";
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> longStringEntry : script.console.entrySet()) {
                map.put(longStringEntry.getKey(), " tab " + tab + ":\n" + longStringEntry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }
}

