/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.config;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import noppes.npcs.CustomNpcs;
import noppes.npcs.config.legacy.LegacyConfig;
import org.apache.logging.log4j.Level;

public class ConfigClient {
    public static Configuration config;
    public static final String GENERAL = "General";
    public static final String VISUAL = "Visual";
    public static final String MODEL = "Model";
    public static final String TEXTURE = "Texture";
    public static final String HUD = "Hud";
    public static Property CacheLifeProperty;
    public static int CacheLife;
    public static Property EnableChatBubblesProperty;
    public static boolean EnableChatBubbles;
    public static Property InventoryGuiEnabledProperty;
    public static boolean InventoryGuiEnabled;
    public static Property enableFactionTabProperty;
    public static boolean enableFactionTab;
    public static Property FontTypeProperty;
    public static String FontType;
    public static Property FontSizeProperty;
    public static int FontSize;
    public static Property ChatBubblesFontTypeProperty;
    public static boolean ChatBubblesFontType;
    public static Property HideEffectsBarProperty;
    public static boolean HideEffectsBar;
    public static Property DialogSpeedProperty;
    public static int DialogSpeed;
    public static Property DialogSoundProperty;
    public static boolean DialogSound;
    public static Property ChatAlertsProperty;
    public static boolean ChatAlerts;
    public static Property BannerAlertsProperty;
    public static boolean BannerAlerts;
    public static Property QuestOverlayXProperty;
    public static int QuestOverlayX;
    public static Property QuestOverlayYProperty;
    public static int QuestOverlayY;
    public static Property QuestOverlayScaleProperty;
    public static int QuestOverlayScale;
    public static Property QuestOverlayTextAlignProperty;
    public static int QuestOverlayTextAlign;
    public static Property CompassEnabledProperty;
    public static boolean CompassEnabled;
    public static Property CompassOverlayXProperty;
    public static int CompassOverlayX;
    public static Property CompassOverlayYProperty;
    public static int CompassOverlayY;
    public static Property CompassOverlayScaleProperty;
    public static int CompassOverlayScale;
    public static Property CompassOverlayWidthProperty;
    public static int CompassOverlayWidth;
    public static boolean WoodTextures;
    public static boolean LegacyCampfire;
    public static boolean LegacyBanner;
    public static boolean LegacyChair;
    public static boolean LegacyStool;
    public static boolean LegacyCouch;
    public static boolean LegacyTable;
    public static boolean LegacyBarrel;
    public static boolean LegacyCarpentryBench;
    public static boolean LegacyAnvil;
    public static boolean LegacyLantern;
    public static boolean LegacyCandle;
    public static boolean LegacyTallLamp;
    public static boolean LegacyPedestal;
    public static boolean LegacyMailbox;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            QuestOverlayXProperty = config.get(HUD, "Quest Hud X", 0, "X position of the quest overlay.");
            QuestOverlayX = QuestOverlayXProperty.getInt(0);
            QuestOverlayYProperty = config.get(HUD, "Quest Hud Y", 31, "Y position of the quest overlay.");
            QuestOverlayY = QuestOverlayYProperty.getInt(31);
            QuestOverlayScaleProperty = config.get(HUD, "Quest Hud Scale", 223, "Scale percentage of the quest overlay.");
            QuestOverlayScale = QuestOverlayScaleProperty.getInt(223);
            QuestOverlayTextAlignProperty = config.get(HUD, "Quest Hud Text Alignment", 0, "Text alignment in quest overlay (0: Left, 1: Center, 2: Right).");
            QuestOverlayTextAlign = QuestOverlayTextAlignProperty.getInt(0);
            CompassEnabledProperty = config.get(HUD, "Compass Hud Enabled", true, "Enable Compass Hud Component");
            CompassEnabled = CompassEnabledProperty.getBoolean();
            CompassOverlayXProperty = config.get(HUD, "Compass Hud X", 37, "Horizontal position of compass overlay (0-100 percentage)", 0, 100);
            CompassOverlayX = CompassOverlayXProperty.getInt();
            CompassOverlayYProperty = config.get(HUD, "Compass Hud Y", 0, "Vertical position of compass overlay (0-100 percentage)", 0, 100);
            CompassOverlayY = CompassOverlayYProperty.getInt();
            CompassOverlayScaleProperty = config.get(HUD, "Compass Hud Scale", 276, "Scale percentage of compass overlay", 50, 300);
            CompassOverlayScale = CompassOverlayScaleProperty.getInt();
            CompassOverlayWidthProperty = config.get(HUD, "Compass Hud Width", 200, "Base width of compass bar in pixels", 100, 1000);
            CompassOverlayWidth = CompassOverlayWidthProperty.getInt();
            CacheLifeProperty = config.get(GENERAL, "Cache Life", 10, "How long should downloaded imagery data be saved client side? (In minutes)");
            CacheLife = CacheLifeProperty.getInt(10);
            EnableChatBubblesProperty = config.get(VISUAL, "Enable Chat Bubbles", true, "Enable/Disable Chat Bubbles");
            EnableChatBubbles = EnableChatBubblesProperty.getBoolean(true);
            InventoryGuiEnabledProperty = config.get(VISUAL, "Enable Inventory Tabs", true, "Enable/Disable Inventory Tabs");
            InventoryGuiEnabled = InventoryGuiEnabledProperty.getBoolean(true);
            enableFactionTabProperty = config.get(VISUAL, "Enable Faction Tab", true, "Enable the Faction Tab");
            enableFactionTab = enableFactionTabProperty.getBoolean(true);
            FontTypeProperty = config.get(VISUAL, "Font Type", "Default", "When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC");
            FontType = FontTypeProperty.getString();
            FontSizeProperty = config.get(VISUAL, "Font Size", 18, "Font size for custom fonts (doesn't work with minecrafts font)");
            FontSize = FontSizeProperty.getInt(18);
            ChatBubblesFontTypeProperty = config.get(VISUAL, "Chat Bubbles Font Type", false, "Enable the use of Custom Font for Chat Bubbles");
            ChatBubblesFontType = ChatBubblesFontTypeProperty.getBoolean(false);
            HideEffectsBarProperty = config.get(VISUAL, "Hide Effects Bar", false, "Hides CNPC+ Inventory Effects Bar");
            HideEffectsBar = HideEffectsBarProperty.getBoolean(false);
            DialogSpeedProperty = config.get(VISUAL, "Dialog Speed", true, "Only set for gradual dialogs");
            DialogSpeed = DialogSpeedProperty.getInt(10);
            DialogSoundProperty = config.get(VISUAL, "Dialog Sound", true, "Only for dialogs with sounds");
            DialogSound = DialogSoundProperty.getBoolean(true);
            ChatAlertsProperty = config.get(VISUAL, "All Chat Alerts", true, "Universal enable/disable for Banner Alerts");
            ChatAlerts = ChatAlertsProperty.getBoolean(true);
            BannerAlertsProperty = config.get(VISUAL, "All Banner Alerts", true, "Universal enable/disable for Banner Alerts");
            BannerAlerts = BannerAlertsProperty.getBoolean(true);
            WoodTextures = config.get(TEXTURE, "Wood Textures", false, "Models like Chairs and Stools will use default MC Wood Textures").getBoolean(false);
            LegacyCampfire = config.get(MODEL, "Legacy Campfire Model", false).getBoolean(false);
            LegacyBanner = config.get(MODEL, "Legacy Banner Model", false).getBoolean(false);
            LegacyBarrel = config.get(MODEL, "Legacy Barrel Model", false).getBoolean(false);
            LegacyChair = config.get(MODEL, "Legacy Chair Model", false).getBoolean(false);
            LegacyStool = config.get(MODEL, "Legacy Stool Model", false).getBoolean(false);
            LegacyCouch = config.get(MODEL, "Legacy Couch Model", false).getBoolean(false);
            LegacyTable = config.get(MODEL, "Legacy Table Model", false).getBoolean(false);
            LegacyAnvil = config.get(MODEL, "Legacy Anvil Model", false).getBoolean(false);
            LegacyCarpentryBench = config.get(MODEL, "Legacy Carpentry Bench Model", false).getBoolean(false);
            LegacyLantern = config.get(MODEL, "Legacy Lantern Model", false).getBoolean(false);
            LegacyCandle = config.get(MODEL, "Legacy Candle Model", false).getBoolean(false);
            LegacyTallLamp = config.get(MODEL, "Legacy Tall Lamp Model", false).getBoolean(false);
            LegacyPedestal = config.get(MODEL, "Legacy Pedestal Model", false).getBoolean(false);
            LegacyMailbox = config.get(MODEL, "Legacy Mailbox Model", false).getBoolean(false);
            if (CustomNpcs.legacyExist) {
                EnableChatBubbles = LegacyConfig.EnableChatBubbles;
                EnableChatBubblesProperty.set(EnableChatBubbles);
                FontType = LegacyConfig.FontType;
                FontTypeProperty.set(FontType);
                InventoryGuiEnabled = LegacyConfig.InventoryGuiEnabled;
                InventoryGuiEnabledProperty.set(InventoryGuiEnabled);
                FontSize = LegacyConfig.FontSize;
                FontSizeProperty.set(FontSize);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"CNPC+ has had a problem loading its client configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        CacheLife = 10;
        EnableChatBubbles = true;
        InventoryGuiEnabled = true;
        enableFactionTab = true;
        FontType = "Default";
        FontSize = 18;
        ChatBubblesFontType = false;
        HideEffectsBar = false;
        DialogSpeed = 10;
        DialogSound = true;
        ChatAlerts = true;
        BannerAlerts = true;
        QuestOverlayX = 0;
        QuestOverlayY = 31;
        QuestOverlayScale = 223;
        QuestOverlayTextAlign = 0;
        CompassEnabled = true;
        CompassOverlayX = 37;
        CompassOverlayY = 0;
        CompassOverlayScale = 276;
        CompassOverlayWidth = 200;
        WoodTextures = false;
        LegacyCampfire = false;
        LegacyBanner = false;
        LegacyChair = false;
        LegacyStool = false;
        LegacyCouch = false;
        LegacyTable = false;
        LegacyBarrel = false;
        LegacyCarpentryBench = false;
        LegacyAnvil = false;
        LegacyLantern = false;
        LegacyCandle = false;
        LegacyTallLamp = false;
        LegacyPedestal = false;
        LegacyMailbox = false;
    }
}

