/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kamkeel.npcs.network.packets.request.script.NPCScriptPacket;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiScriptList;
import noppes.npcs.client.gui.script.GuiNPCEventScripts;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiScriptTextArea;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IJTextAreaListener;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.DataScript;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiScript
extends GuiNPCInterface
implements IGuiData,
GuiYesNoCallback,
ICustomScrollListener,
IJTextAreaListener,
ITextChangeListener {
    public boolean showScript = false;
    private int activeTab = 0;
    public DataScript script;
    public Map<String, List<String>> languages = new HashMap<String, List<String>>();
    private static int activeConsole = 0;
    boolean loaded = false;

    public GuiScript(EntityNPCInterface npc) {
        super(npc);
        this.script = npc.script;
        this.drawDefaultBackground = true;
        this.closeOnEsc = true;
        this.xSize = 420;
        this.setBackground("menubg.png");
        NPCScriptPacket.Get();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        GuiMenuTopButton top = new GuiMenuTopButton(13, this.guiLeft + 4, this.guiTop - 17, "script.scripts");
        this.addTopButton(top);
        this.addTopButton(new GuiMenuTopButton(16, this.guiLeft + (this.xSize - 102), this.guiTop - 17, "eventscript.eventScripts"));
        this.addTopButton(new GuiMenuTopButton(17, this.guiLeft + (this.xSize - 22), this.guiTop - 17, "X"));
        top.active = this.showScript;
        top = new GuiMenuTopButton(14, top, "gui.settings");
        this.addTopButton(top);
        top.active = !this.showScript;
        this.addTopButton(new GuiMenuTopButton(15, top, "gui.website"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("script.init");
        list.add("script.update");
        list.add("script.interact");
        list.add("dialog.dialog");
        list.add("script.damaged");
        list.add("script.killed");
        list.add("script.attack");
        list.add("script.target");
        list.add("script.collide");
        list.add("script.kills");
        list.add("script.dialog_closed");
        list.add("script.timer");
        list.add("script.targetLost");
        list.add("script.projectileTick");
        list.add("script.projectileImpact");
        if (this.showScript) {
            this.addLabel(new GuiNpcLabel(0, "script.hooks", this.guiLeft + 4, this.guiTop + 5));
            GuiCustomScroll hooks = new GuiCustomScroll(this, 1);
            hooks.setSize(68, 198);
            hooks.guiLeft = this.guiLeft + 4;
            hooks.guiTop = this.guiTop + 14;
            hooks.setUnsortedList(list);
            hooks.selected = this.activeTab;
            this.addScroll(hooks);
            ScriptContainer container = this.script.getNPCScript(this.activeTab);
            GuiScriptTextArea ta = new GuiScriptTextArea(this, 2, this.guiLeft + 74, this.guiTop + 4, 239, 208, container == null ? "" : container.script);
            ta.enableCodeHighlighting();
            ta.setListener(this);
            this.addTextField(ta);
            this.addButton(new GuiNpcButton(102, this.guiLeft + 315, this.guiTop + 4, 50, 20, "gui.clear"));
            this.addButton(new GuiNpcButton(101, this.guiLeft + 366, this.guiTop + 4, 50, 20, "gui.paste"));
            this.addButton(new GuiNpcButton(100, this.guiLeft + 315, this.guiTop + 25, 50, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(107, this.guiLeft + 315, this.guiTop + 70, 80, 20, "script.loadscript"));
            GuiCustomScroll scroll = new GuiCustomScroll(this, 0).setUnselectable();
            scroll.setSize(100, 120);
            scroll.guiLeft = this.guiLeft + 315;
            scroll.guiTop = this.guiTop + 92;
            if (container != null) {
                scroll.setList(container.scripts);
            }
            this.addScroll(scroll);
        } else {
            this.addLabel(new GuiNpcLabel(0, "script.console", this.guiLeft + 4, this.guiTop + 16));
            this.getTopButton((int)14).active = true;
            this.addTextField(new GuiNpcTextArea(2, this, this.guiLeft + 4, this.guiTop + 26, 226, 186, this.getConsoleText()));
            this.getTextField((int)2).canEdit = false;
            this.addButton(new GuiNpcButton(100, this.guiLeft + 232, this.guiTop + 170, 56, 20, "gui.copy"));
            this.addButton(new GuiNpcButton(102, this.guiLeft + 232, this.guiTop + 192, 56, 20, "gui.clear"));
            ArrayList<String> l = new ArrayList<String>();
            l.add("All");
            l.addAll(list);
            this.addButton(new GuiNpcButton(105, this.guiLeft + 60, this.guiTop + 4, 80, 20, l.toArray(new String[l.size()]), activeConsole));
            this.addLabel(new GuiNpcLabel(1, "script.language", this.guiLeft + 232, this.guiTop + 30));
            this.addButton(new GuiNpcButton(103, this.guiLeft + 294, this.guiTop + 25, 80, 20, this.languages.keySet().toArray(new String[this.languages.keySet().size()]), this.getScriptIndex()));
            this.getButton((int)103).field_146124_l = this.languages.size() > 0;
            this.addLabel(new GuiNpcLabel(2, "gui.enabled", this.guiLeft + 232, this.guiTop + 53));
            this.addButton(new GuiNpcButton(104, this.guiLeft + 294, this.guiTop + 48, 50, 20, new String[]{"gui.no", "gui.yes"}, this.script.enabled ? 1 : 0));
            if (MinecraftServer.func_71276_C() != null) {
                this.addButton(new GuiNpcButton(106, this.guiLeft + 232, this.guiTop + 71, 150, 20, "script.openfolder"));
            }
        }
    }

    private int getScriptIndex() {
        int i = 0;
        for (String language : this.languages.keySet()) {
            if (language.equalsIgnoreCase(this.script.scriptLanguage)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private String getConsoleText() {
        Map<Long, String> map = this.script.getOldConsoleText();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Long, String> entry : map.entrySet()) {
            builder.insert(0, new Date(entry.getKey()) + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        if (id == 0) {
            this.openLink("https://kamkeel.github.io/CustomNPC-Plus/");
        }
        if (id == 101) {
            this.getTextField(2).func_146180_a(NoppesStringUtils.getClipboardContents());
        }
        if (id == 102) {
            this.getTextField(2).func_146180_a("");
            if (!this.showScript) {
                if (activeConsole == 0) {
                    for (ScriptContainer container : this.script.getNPCScripts()) {
                        container.console.clear();
                    }
                } else {
                    ScriptContainer container = this.script.getNPCScript(activeConsole - 1);
                    if (container != null) {
                        container.console.clear();
                    }
                }
            }
        }
        this.displayGuiScreen(this);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        GuiConfirmOpenLink guiyesno;
        if (guibutton.field_146127_k == 13) {
            this.showScript = true;
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 14) {
            this.setScript();
            this.showScript = false;
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 15) {
            guiyesno = new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://kamkeel.github.io/CustomNPC-Plus/", 0, true);
            this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
        }
        if (guibutton.field_146127_k == 16) {
            this.close();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiNPCEventScripts(this.npc));
        }
        if (guibutton.field_146127_k == 17) {
            this.close();
        }
        if (guibutton.field_146127_k == 100) {
            NoppesStringUtils.setClipboardContents(this.getTextField(2).func_146179_b());
        }
        if (guibutton.field_146127_k == 101) {
            guiyesno = new GuiYesNo((GuiYesNoCallback)this, StatCollector.func_74838_a((String)"gui.paste"), StatCollector.func_74838_a((String)"gui.sure"), 101);
            this.displayGuiScreen((GuiScreen)guiyesno);
        }
        if (guibutton.field_146127_k == 102) {
            guiyesno = new GuiYesNo((GuiYesNoCallback)this, StatCollector.func_74838_a((String)"gui.clear"), StatCollector.func_74838_a((String)"gui.sure"), 102);
            this.displayGuiScreen((GuiScreen)guiyesno);
        }
        if (guibutton.field_146127_k == 103) {
            this.script.scriptLanguage = ((GuiNpcButton)guibutton).field_146126_j;
        }
        if (guibutton.field_146127_k == 104) {
            boolean bl = this.script.enabled = ((GuiNpcButton)guibutton).getValue() == 1;
        }
        if (guibutton.field_146127_k == 105) {
            activeConsole = ((GuiNpcButton)guibutton).getValue();
            this.func_73866_w_();
        }
        if (guibutton.field_146127_k == 106) {
            NoppesUtil.openFolder(ScriptController.Instance.dir);
        }
        if (guibutton.field_146127_k == 107) {
            ScriptContainer container = this.script.getNPCScript(this.activeTab);
            if (container == null) {
                container = new ScriptContainer(this.script);
                this.script.setNPCScript(this.activeTab, container);
            }
            this.setSubGui(new GuiScriptList(this.languages.get(this.script.scriptLanguage), container));
        }
    }

    private void setScript() {
        if (this.showScript) {
            ScriptContainer container = this.script.getNPCScript(this.activeTab);
            if (container == null) {
                container = new ScriptContainer(this.script);
                this.script.setNPCScript(this.activeTab, container);
            }
            String text = this.getTextField(2).func_146179_b();
            text = text.replace("\r\n", "\n");
            container.script = text = text.replace("\r", "\n");
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.script.readFromNBT(compound);
        NBTTagList data = compound.func_150295_c("Languages", 10);
        HashMap<String, List<String>> languages = new HashMap<String, List<String>>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound comp = data.func_150305_b(i);
            ArrayList<String> scripts = new ArrayList<String>();
            NBTTagList list = comp.func_150295_c("Scripts", 8);
            for (int j = 0; j < list.func_74745_c(); ++j) {
                scripts.add(list.func_150307_f(j));
            }
            languages.put(comp.func_74779_i("Language"), scripts);
        }
        this.languages = languages;
        this.func_73866_w_();
        this.loaded = true;
    }

    @Override
    public void save() {
        if (this.loaded) {
            this.setScript();
            NPCScriptPacket.Save(this.script.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        if (scroll.id == 1) {
            this.setScript();
            this.activeTab = scroll.selected;
            this.func_73866_w_();
        }
    }

    @Override
    public void textUpdate(String text) {
        ScriptContainer container = this.script.getNPCScript(this.activeTab);
        if (container != null) {
            container.script = text;
        }
    }

    @Override
    public void saveText(String text) {
        ScriptContainer container = this.script.getNPCScript(this.activeTab);
        if (container != null) {
            container.script = text;
        }
        this.func_73866_w_();
    }
}

