/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcs.network.packets.request.animation;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcs.network.AbstractPacket;
import kamkeel.npcs.network.PacketChannel;
import kamkeel.npcs.network.PacketHandler;
import kamkeel.npcs.network.PacketUtil;
import kamkeel.npcs.network.enums.EnumItemPacketType;
import kamkeel.npcs.network.enums.EnumRequestPacket;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.data.Animation;

public final class AnimationRemovePacket
extends AbstractPacket {
    public static String packetName = "Request|AnimationRemove";
    private int animationID;

    public AnimationRemovePacket() {
    }

    public AnimationRemovePacket(int animationID) {
        this.animationID = animationID;
    }

    @Override
    public Enum getType() {
        return EnumRequestPacket.AnimationRemove;
    }

    @Override
    public PacketChannel getChannel() {
        return PacketHandler.REQUEST_PACKET;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.GLOBAL_ANIMATION;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.animationID);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (!PacketUtil.verifyItemPacket(packetName, EnumItemPacketType.WAND, player)) {
            return;
        }
        int id = in.readInt();
        AnimationController.getInstance().delete(id);
        NoppesUtilServer.sendAnimationDataAll((EntityPlayerMP)player);
        NBTTagCompound compound = new Animation().writeToNBT();
        GuiDataPacket.sendGuiData((EntityPlayerMP)player, compound);
    }
}

