/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player.outline;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public final class DBCRequestOutline
extends AbstractPacket {
    public static final String packetName = "NPC|RequestOutline";
    private int outlineID;

    public DBCRequestOutline(int outlineID) {
        this.outlineID = outlineID;
    }

    public DBCRequestOutline() {
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.OutlineList;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.outlineID);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.outlineID = in.readInt();
        if (this.outlineID != -1) {
            Outline customOutline = (Outline)OutlineController.getInstance().get(this.outlineID);
            if (customOutline != null) {
                NBTTagCompound compound = customOutline.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Outline");
                GuiDataPacket.sendGuiData((EntityPlayerMP)((EntityPlayerMP)player), (NBTTagCompound)compound);
            }
        } else {
            NetworkUtility.sendCustomOutlineDataAll((EntityPlayerMP)player);
        }
    }
}

