/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.get;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import kamkeel.npcdbc.controllers.DBCSyncController;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.LargeAbstractPacket;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketGet;
import kamkeel.npcs.network.enums.EnumSyncAction;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.ClientCacheHandler;

public final class DBCInfoSyncPacket
extends LargeAbstractPacket {
    public static final String packetName = "NPC|SyncDBC";
    private int enumSyncType;
    private EnumSyncAction enumSyncAction;
    private NBTTagCompound syncData;
    private int operationID;

    public DBCInfoSyncPacket() {
    }

    public DBCInfoSyncPacket(int enumSyncType, EnumSyncAction enumSyncAction, int catId, NBTTagCompound syncData) {
        this.enumSyncType = enumSyncType;
        this.enumSyncAction = enumSyncAction;
        this.syncData = syncData;
        this.operationID = catId;
    }

    @Override
    public Enum getType() {
        return EnumPacketGet.InfoSync;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.GET_PACKETS;
    }

    @Override
    protected byte[] getData() throws IOException {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(this.enumSyncType);
        buffer.writeInt(this.enumSyncAction.ordinal());
        buffer.writeInt(this.operationID);
        ByteBufUtils.writeBigNBT((ByteBuf)buffer, (NBTTagCompound)this.syncData);
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    @Override
    protected void handleCompleteData(ByteBuf data, EntityPlayer player) throws IOException {
        if (CustomNpcs.side() != Side.CLIENT) {
            return;
        }
        int syncType = data.readInt();
        int syncActionOrdinal = data.readInt();
        int categoryID = data.readInt();
        EnumSyncAction action = EnumSyncAction.values()[syncActionOrdinal];
        try {
            NBTTagCompound tag = ByteBufUtils.readBigNBT((ByteBuf)data);
            if (syncType == 0) {
                ClientCacheHandler.playerData.setDBCSync(tag);
                return;
            }
            this.handleSyncPacketClient(syncType, action, categoryID, tag);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void handleSyncPacketClient(int syncType, EnumSyncAction enumSyncAction, int id, NBTTagCompound data) {
        switch (enumSyncAction) {
            case RELOAD: {
                DBCSyncController.clientSync(syncType, data);
                break;
            }
            case UPDATE: {
                DBCSyncController.clientSyncUpdate(syncType, data);
                break;
            }
            case REMOVE: {
                DBCSyncController.clientSyncRemove(syncType, id);
            }
        }
    }
}

