/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.entity;

import JinRyuu.DragonBC.common.Npcs.EntityAuraRing;
import JinRyuu.JRMCore.client.config.jrmc.JGConfigClientSettings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import kamkeel.npcdbc.client.ParticleFormHandler;
import kamkeel.npcdbc.client.gui.global.auras.SubGuiAuraDisplay;
import kamkeel.npcdbc.client.sound.AuraSound;
import kamkeel.npcdbc.config.ConfigDBCClient;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.constants.DBCRace;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes2D;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.SoundSource;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.aura.AuraDisplay;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.mixins.early.IEntityMC;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAura
extends Entity {
    public final Entity entity;
    public Aura aura;
    public IAuraData auraData;
    @SideOnly(value=Side.CLIENT)
    public AuraSound auraSound;
    public boolean isKaioken;
    public boolean isInKaioken;
    public boolean isGUIAura;
    public boolean isTransforming;
    public boolean isCharging;
    public boolean isVanillaDefault;
    public EnumAuraTypes3D type3D;
    public EnumAuraTypes2D type2D;
    public int color1 = -1;
    public int color2 = -1;
    public int color3 = -1;
    public int speed = 10;
    public int renderPass;
    public float alpha;
    public float maxAlpha = 0.05f;
    public float size = 1.0f;
    public float effectiveSize;
    public float skinColorAlpha = 0.25f;
    public boolean hasLightning;
    public int lightningColor = 2476495;
    public int lightningAlpha = 255;
    public boolean isInner;
    public boolean fadeOut = false;
    public boolean fadeIn = true;
    public String name;
    public EntityAura parent;
    public HashMap<String, EntityAura> children = new HashMap();
    public float fadeFactor = 0.005f;
    public ResourceLocation text1;
    public ResourceLocation text2;
    public ResourceLocation text3;

    public EntityAura(Entity entity, Aura aura) {
        super(entity.field_70170_p);
        this.entity = entity;
        this.aura = aura;
        if (entity instanceof EntityPlayer) {
            this.auraData = DBCData.get((EntityPlayer)entity);
        } else if (entity instanceof EntityNPCInterface) {
            this.auraData = ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay();
        }
        this.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.text1 = new ResourceLocation("jinryuudragonbc:aura.png");
    }

    public EntityAura load(boolean all) {
        Object secondaryAura;
        Form form;
        int mimicColor;
        boolean isRoot = this.isRoot();
        if (isRoot && !this.field_70128_L && this.auraData.getAuraEntity() != this) {
            this.auraData.setAuraEntity(this);
        }
        this.color1 = this.auraData.getAuraColor();
        AuraDisplay display = this.aura.display;
        if (this.aura.display.type == EnumAuraTypes3D.Base) {
            EnumAuraTypes3D newType = EnumAuraTypes3D.getType(this.auraData);
            if (newType != this.type3D) {
                this.onTypeChange(newType);
            }
            this.type3D = newType;
        } else {
            this.type3D = display.type;
        }
        this.type2D = display.type2D;
        if (this.aura.display.type2D == EnumAuraTypes2D.Default) {
            this.type2D = EnumAuraTypes2D.getFrom3D(this.type3D);
        }
        if ((this.type3D == EnumAuraTypes3D.None || this.type3D == EnumAuraTypes3D.Base) && this.aura.display.type2D == EnumAuraTypes2D.Default) {
            this.type2D = EnumAuraTypes2D.Base;
        }
        if (this.auraData instanceof DBCData && ((DBCData)this.auraData).State > 0 && display.copyDBCSuperformColors) {
            this.color1 = this.auraData.getDBCColor();
        }
        if ((mimicColor = EnumAuraTypes3D.getManualAuraColor(this.type3D, true)) != -1) {
            this.color1 = mimicColor;
        }
        if (display.hasColor("color1")) {
            this.color1 = display.color1;
        }
        if ((form = PlayerDataUtil.getForm(this.entity)) != null && form.display.hasColor("aura")) {
            this.color1 = form.display.auraColor;
        }
        if (this.isVanillaDefault) {
            this.hasLightning = DBCRace.isSaiyan(this.auraData.getRace()) && (this.auraData.getState() == 5 || this.auraData.getState() == 6);
        }
        if (isRoot && this.aura.hasSecondaryAura()) {
            secondaryAura = this.aura.getSecondaryAur();
            EntityAura root = this.auraData.getAuraEntity();
            if (!this.children.containsKey("Secondary") && root != null && root.aura.id != ((Aura)secondaryAura).id) {
                new EntityAura(this.entity, (Aura)secondaryAura).setParent(this, "Secondary").load(true).spawn();
            }
        } else if (this.children.containsKey("Secondary")) {
            secondaryAura = this.children.get("Secondary");
            ((EntityAura)((Object)secondaryAura)).despawn();
        }
        if (this.isInKaioken) {
            boolean kaiokenOverride = display.kaiokenOverrides;
            if (this.isVanillaDefault && DBCForm.isSaiyanGod(this.auraData.getState())) {
                kaiokenOverride = false;
            }
            if (!kaiokenOverride && !this.children.containsKey("Kaioken")) {
                new EntityAura(this.entity, this.aura).setParent(this, "Kaioken").loadKaioken().spawn();
            }
            if (this.children.containsKey("Kaioken")) {
                EntityAura kaiokenAura = this.children.get("Kaioken");
                if (kaiokenOverride) {
                    kaiokenAura.despawn();
                }
            }
            if (kaiokenOverride) {
                this.lightningColor = 0xFE0000;
                this.color1 = 0xFE0000;
            }
        } else if (this.lightningColor == 0xFE0000) {
            this.lightningColor = 2476495;
        }
        if (isRoot) {
            this.auraData.setActiveAuraColor(this.color1);
        }
        if (all) {
            if (display.hasColor("color2")) {
                this.color2 = display.color2;
            }
            if (display.hasColor("color3")) {
                this.color3 = display.color3;
            }
            if (display.hasAlpha("aura")) {
                this.maxAlpha = (float)display.alpha / 1275.0f;
                if (SubGuiAuraDisplay.useGUIAura) {
                    this.alpha = this.maxAlpha;
                }
            }
            if (display.hasSpeed()) {
                this.speed = display.speed;
            }
            if (display.hasSize()) {
                this.size = display.size;
            }
            this.hasLightning = display.hasLightning;
            if (display.hasColor("lightning")) {
                this.lightningColor = display.lightningColor;
            }
            if (display.hasAlpha("lightning")) {
                this.lightningAlpha = display.lightningAlpha;
            }
        }
        return this;
    }

    public void onTypeChange(EnumAuraTypes3D newType) {
        if (this.auraSound != null) {
            this.auraSound.soundSource.fadeOut = true;
            this.auraSound.soundSource.fadeFactor = 0.075f;
            this.playSound(newType);
        }
    }

    public EntityAura loadKaioken() {
        AuraDisplay display = this.aura.display;
        this.color1 = 0xFE0000;
        this.text1 = new ResourceLocation("jinryuudragonbc:aurak.png");
        this.renderPass = 0;
        this.maxAlpha = 0.1f;
        if (this.aura.display.hasAlpha("kaioken")) {
            this.maxAlpha = (float)display.kaiokenAlpha / 255.0f;
        }
        if (this.aura.display.hasColor("kaioken")) {
            this.color1 = display.kaiokenColor;
        }
        if (this.aura.display.hasSpeed()) {
            this.speed = display.speed;
        }
        this.size = display.size * display.kaiokenSize;
        this.hasLightning = display.hasLightning;
        if (display.hasColor("lightning")) {
            this.lightningColor = display.lightningColor;
        }
        if (display.hasAlpha("lightning")) {
            this.lightningAlpha = display.lightningAlpha;
        }
        this.isKaioken = true;
        return this;
    }

    public void loadType() {
        String auraDir = "jinryuudragonbc:";
        if (this.type3D == EnumAuraTypes3D.SaiyanGod) {
            this.maxAlpha = 0.2f;
            this.text1 = new ResourceLocation(auraDir + "aurai.png");
            this.text2 = new ResourceLocation(auraDir + "auraj.png");
            this.color2 = 16747301;
        } else if (this.type3D == EnumAuraTypes3D.SaiyanBlue) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurag.png");
            this.text3 = new ResourceLocation(auraDir + "auragb.png");
            this.color3 = 0xEFFAFA;
        } else if (this.type3D == EnumAuraTypes3D.SaiyanBlueEvo) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurag.png");
            this.text3 = new ResourceLocation(auraDir + "auragb.png");
            this.color3 = 12310271;
        } else if (this.type3D == EnumAuraTypes3D.SaiyanRose) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurai.png");
            this.text2 = new ResourceLocation(auraDir + "auraj.png");
            this.color2 = 7872713;
        } else if (this.type3D == EnumAuraTypes3D.SaiyanRoseEvo) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurai.png");
            this.text2 = new ResourceLocation(auraDir + "auraj.png");
            this.color2 = 8592109;
        } else if (this.type3D == EnumAuraTypes3D.UI) {
            this.maxAlpha = 0.15f;
            this.color1 = 0xF0F0F0;
            this.text1 = new ResourceLocation(auraDir + "auras.png");
            this.color3 = 4746495;
            this.text3 = new ResourceLocation(auraDir + "auragb.png");
        } else if (this.type3D == EnumAuraTypes3D.GoD) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurag.png");
            this.text3 = new ResourceLocation(auraDir + "auragb.png");
            this.color2 = 12464847;
        } else if (this.type3D == EnumAuraTypes3D.UltimateArco) {
            this.maxAlpha = 0.05f;
            this.text1 = new ResourceLocation(auraDir + "aurau.png");
            this.text2 = new ResourceLocation(auraDir + "aurau2.png");
            this.color2 = 16776724;
        }
    }

    public EntityAura setParent(EntityAura aura, String thisName) {
        this.parent = aura;
        this.name = thisName;
        this.parent.children.put(this.name, this);
        return this;
    }

    protected void func_70088_a() {
        this.field_70158_ak = true;
        this.renderPass = 1;
        this.field_70131_O = 2.2f;
    }

    public void updateDisplay() {
        if (this.entity.func_70090_H() && !this.isKaioken) {
            this.renderPass = 0;
            ((IEntityMC)this.entity).setRenderPass(0);
        } else if (this.renderPass == 0 && !this.isKaioken) {
            this.renderPass = 1684;
            ((IEntityMC)this.entity).setRenderPass(1684);
        }
        if (this.isKaioken) {
            if (this.entity.field_70173_aa % 10 == 0) {
                this.loadKaioken();
            }
            if (this.parent.isVanillaDefault && !DBCForm.isSaiyanGod(this.auraData.getState())) {
                this.fadeOut = true;
            }
            return;
        }
        if (this.entity.field_70173_aa % 10 == 0) {
            this.load(false);
        }
        if (!this.fadeOut && this.aura.display.type2D != EnumAuraTypes2D.None) {
            float height = this.effectiveSize <= 0.0f ? this.entity.field_70131_O : this.field_70131_O * 0.53f * this.effectiveSize;
            ParticleFormHandler.spawnAura2D(this.type2D, this.color1, this.entity, this.auraData, height, this.isGUIAura);
        }
        if (this.aura.display.kettleModeEnabled) {
            ParticleFormHandler.spawnAura2D(EnumAuraTypes2D.KettleMode, 0, this.entity, this.auraData, 0.0f, this.isGUIAura);
        }
        String auraDir = "jinryuudragonbc:";
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void despawn() {
        if (this.fadeOut) {
            return;
        }
        this.fadeOut = true;
        this.fadeOutSound();
        for (EntityAura child : this.children.values()) {
            child.despawn();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        ((IEntityMC)this.entity).setRenderPass(0);
        this.entity.field_70158_ak = false;
        if (this.isRoot() && this.auraData.getAuraEntity() == this) {
            this.auraData.setAuraEntity(null);
            this.auraData.setActiveAuraColor(-1);
        }
        if (this.parent != null && this.parent.children != null && this.parent.children.containsKey(this.name)) {
            this.parent.children.remove(this.name);
        }
    }

    public void func_70071_h_() {
        if (this.isRoot() && !this.fadeOut) {
            Aura currentAura = PlayerDataUtil.getToggledAura(this.entity);
            if (!this.isVanillaDefault && (this.entity == null || this.entity.field_70128_L || currentAura == null || this.aura.id != currentAura.id || this.auraData.getAuraEntity() != this || this.auraData.isFusionSpectator())) {
                this.despawn();
            } else if (this.isVanillaDefault && (!this.auraData.isAuraOn() || this.auraData.isFusionSpectator() || this.entity == null || this.entity.field_70128_L || currentAura != null || !ConfigDBCClient.RevampAura || this.auraData.isFusionSpectator())) {
                this.despawn();
            }
        }
        this.isInKaioken = this.auraData.isInKaioken();
        if (!this.isInKaioken && this.isKaioken && !this.fadeOut) {
            this.despawn();
        }
        if (this.fadeIn && !this.fadeOut && this.alpha < this.maxAlpha) {
            float fadeFactor = this.fadeFactor + this.maxAlpha / 1.0f * 0.04f;
            this.alpha = Math.min(this.alpha + fadeFactor, this.maxAlpha);
            if (this.alpha >= this.maxAlpha) {
                this.fadeIn = false;
            }
        }
        if (this.fadeOut) {
            float fadeFactor = this.fadeFactor + this.maxAlpha / 1.0f * 0.04f;
            this.alpha -= fadeFactor;
            if (this.alpha <= 0.0f) {
                this.func_70106_y();
            }
        }
        this.func_70080_a(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.entity.field_70177_z, this.entity.field_70125_A);
        this.isTransforming = this.auraData.isTransforming();
        this.isCharging = this.auraData.isChargingKi() || this.isTransforming;
        this.updateDisplay();
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound(EnumAuraTypes3D soundType) {
        String sound;
        if (SubGuiAuraDisplay.useGUIAura) {
            return;
        }
        if (this.isVanillaDefault) {
            this.aura.display.auraSound = "default";
        }
        String string = sound = !this.isKaioken ? this.aura.display.getFinalSound(soundType) : this.aura.display.getFinalKKSound();
        if (sound != null) {
            this.auraSound = new AuraSound(this.aura, new SoundSource(sound, this.entity));
            if (this.isTransforming) {
                this.auraSound.setVolume(0.2f);
            }
            this.auraSound.setRepeat(true).play(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void fadeOutSound() {
        if (this.auraSound != null) {
            this.auraSound.soundSource.fadeOut = true;
        }
    }

    public EntityAuraRing spawnAuraRing(Entity entity, int color) {
        if (entity.field_70173_aa % 20 != 0) {
            return null;
        }
        boolean isPlayer = entity instanceof EntityPlayer;
        EntityAuraRing ring = new EntityAuraRing(entity.field_70170_p, isPlayer ? entity.func_70005_c_() : Utility.getEntityID(entity), color, 0.0f, 0.0f, 0);
        entity.field_70170_p.func_72838_d((Entity)ring);
        return ring;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == this.renderPass;
    }

    public double getYOffset(float size) {
        float scaledAuraHeight = this.field_70131_O * size;
        float yOffset = 0.0f;
        if (this.entity instanceof EntityNPCInterface) {
            // empty if block
        }
        yOffset = -0.05f + scaledAuraHeight + scaledAuraHeight * (scaledAuraHeight / 50.0f) * 2.25f;
        boolean client = Minecraft.func_71410_x().field_71439_g == this.entity;
        float clientOffset = !client ? 1.62f : 0.0f;
        return yOffset + clientOffset;
    }

    public EntityAura spawn() {
        if (!this.isKaioken) {
            this.renderPass = 1684;
        }
        ((IEntityMC)this.entity).setRenderPass(1684);
        this.entity.field_70158_ak = true;
        this.entity.field_70170_p.func_72838_d((Entity)this);
        this.playSound(this.type3D);
        return this;
    }

    public boolean shouldRender() {
        return (this.type3D != EnumAuraTypes3D.None || this.type3D == EnumAuraTypes3D.None && this.hasLightning) && (JGConfigClientSettings.CLIENT_DA14 || SubGuiAuraDisplay.useGUIAura);
    }

    public void setTexture(int type, String path) {
        ResourceLocation loc = path == null ? null : new ResourceLocation(path);
        switch (type) {
            case 2: {
                this.text2 = loc;
                break;
            }
            case 3: {
                this.text3 = loc;
                break;
            }
            default: {
                this.text1 = loc;
            }
        }
    }

    public EntityAura setIsVanilla(boolean bo) {
        this.isVanillaDefault = bo;
        this.aura.display.copyDBCSuperformColors = true;
        return this;
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
    }
}

