/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kamkeel.npcdbc.data.form.Form;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FormAttributes {
    private static final String TAG_FORM_ATTRIBUTES = "formAttributes";
    private static final String TAG_FORM_MAGIC_ATTRIBUTES = "formMagicAttributes";
    private final Form parent;
    private final Map<String, Float> attrs = new HashMap<String, Float>();
    private final Map<String, Map<Integer, Float>> magic = new HashMap<String, Map<Integer, Float>>();

    public FormAttributes(Form parent) {
        this.parent = parent;
    }

    public void setAttribute(String key, float value) {
        this.attrs.put(key, Float.valueOf(value));
    }

    public void removeAttribute(String key) {
        this.attrs.remove(key);
    }

    public Map<String, Float> getAllAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public void applyMagicAttribute(String attributeTag, int magicId, float value) {
        Map<Integer, Float> map = this.magic.get(attributeTag);
        if (map == null) {
            map = new HashMap<Integer, Float>();
            this.magic.put(attributeTag, map);
        }
        map.put(magicId, Float.valueOf(value));
    }

    public void removeMagicAttribute(String attributeTag, int magicId) {
        Map<Integer, Float> map = this.magic.get(attributeTag);
        if (map != null) {
            map.remove(magicId);
            if (map.isEmpty()) {
                this.magic.remove(attributeTag);
            }
        }
    }

    public Map<Integer, Float> getMagicMap(String attributeTag) {
        Map<Integer, Float> map = this.magic.get(attributeTag);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, Map<Integer, Float>> getAllMagic() {
        return Collections.unmodifiableMap(this.magic);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.attrs.clear();
        if (compound.func_74764_b(TAG_FORM_ATTRIBUTES)) {
            NBTTagCompound at = compound.func_74775_l(TAG_FORM_ATTRIBUTES);
            Set keys = at.func_150296_c();
            for (String k : keys) {
                this.attrs.put(k, Float.valueOf(at.func_74760_g(k)));
            }
        }
        this.magic.clear();
        if (compound.func_74764_b(TAG_FORM_MAGIC_ATTRIBUTES)) {
            NBTTagCompound mg = compound.func_74775_l(TAG_FORM_MAGIC_ATTRIBUTES);
            Set tags = mg.func_150296_c();
            for (String tagName : tags) {
                NBTTagCompound mapTag = mg.func_74775_l(tagName);
                Set ids = mapTag.func_150296_c();
                HashMap<Integer, Float> map = new HashMap<Integer, Float>();
                for (String idStr : ids) {
                    try {
                        int id = Integer.parseInt(idStr);
                        map.put(id, Float.valueOf(mapTag.func_74760_g(idStr)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (map.isEmpty()) continue;
                this.magic.put(tagName, map);
            }
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound at = new NBTTagCompound();
        for (Map.Entry<String, Float> e : this.attrs.entrySet()) {
            at.func_74776_a(e.getKey(), e.getValue().floatValue());
        }
        compound.func_74782_a(TAG_FORM_ATTRIBUTES, (NBTBase)at);
        NBTTagCompound mg = new NBTTagCompound();
        for (Map.Entry<String, Map<Integer, Float>> tagEntry : this.magic.entrySet()) {
            String tagName = tagEntry.getKey();
            Map<Integer, Float> map = tagEntry.getValue();
            NBTTagCompound mapTag = new NBTTagCompound();
            for (Map.Entry<Integer, Float> m : map.entrySet()) {
                mapTag.func_74776_a(String.valueOf(m.getKey()), m.getValue().floatValue());
            }
            mg.func_74782_a(tagName, (NBTBase)mapTag);
        }
        compound.func_74782_a(TAG_FORM_MAGIC_ATTRIBUTES, (NBTBase)mg);
    }
}

