/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.effects.types;

import kamkeel.npcdbc.config.ConfigDBCEffects;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.effects.AddonEffect;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.data.PlayerEffect;
import noppes.npcs.scripted.event.player.PlayerEvent;

public class FruitOfMight
extends AddonEffect {
    public static Aura fruitOfMightAura = null;
    public float kiToDrain;
    public PlayerBonus fruitOfMightBonus;

    public FruitOfMight() {
        this.name = "FruitOfMight";
        this.langName = "effect.fruitofmight";
        this.id = 5;
        this.iconX = 64;
        this.iconY = 0;
        this.length = ConfigDBCEffects.FOM_EffectLength;
        this.fruitOfMightBonus = new PlayerBonus(this.name, 0, (float)ConfigDBCEffects.FOM_Strength, (float)ConfigDBCEffects.FOM_Dex, (float)ConfigDBCEffects.FOM_Will);
        this.kiToDrain = (float)ConfigDBCEffects.FOM_KiDrain;
        if (fruitOfMightAura == null) {
            fruitOfMightAura = new Aura();
            FruitOfMight.fruitOfMightAura.id = -10;
            FruitOfMight.fruitOfMightAura.display.setColor("color1", 0);
            FruitOfMight.fruitOfMightAura.display.setColor("color3", 11741626);
            FruitOfMight.fruitOfMightAura.display.hasLightning = true;
            FruitOfMight.fruitOfMightAura.display.lightningColor = 11741626;
        }
    }

    public void onAdded(EntityPlayer player, PlayerEffect playerEffect) {
        BonusController.getInstance().applyBonus(player, this.fruitOfMightBonus);
        if (ConfigDBCEffects.FOM_Aura) {
            PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(player);
            c.currentAura = FruitOfMight.fruitOfMightAura.id;
            c.updateClient();
        }
    }

    public void onTick(EntityPlayer player, PlayerEffect playerEffect) {
        DBCData dbcData = DBCData.get(player);
        dbcData.stats.restoreKiPercent(this.kiToDrain);
        if (dbcData.Ki <= 0) {
            playerEffect.kill();
        }
    }

    public void onRemoved(EntityPlayer player, PlayerEffect playerEffect, PlayerEvent.EffectEvent.ExpirationType type) {
        PlayerDBCInfo c = PlayerDataUtil.getDBCInfo(player);
        if (c.currentAura == FruitOfMight.fruitOfMightAura.id) {
            c.currentAura = -1;
            c.updateClient();
        }
        BonusController.getInstance().removeBonus(player, this.fruitOfMightBonus);
    }
}

