/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.inventory;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import kamkeel.npcdbc.client.gui.component.GuiFormAuraScroll;
import kamkeel.npcdbc.config.ConfigDBCClient;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.packets.get.aura.DBCGetAura;
import kamkeel.npcdbc.network.packets.get.form.DBCGetForm;
import kamkeel.npcdbc.network.packets.player.aura.DBCRequestAura;
import kamkeel.npcdbc.network.packets.player.aura.DBCSelectAura;
import kamkeel.npcdbc.network.packets.player.aura.DBCSetAura;
import kamkeel.npcdbc.network.packets.player.form.DBCRequestForm;
import kamkeel.npcdbc.network.packets.player.form.DBCSelectForm;
import kamkeel.npcdbc.util.DBCUtils;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.inventory.GuiCNPCInventory;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumScrollData;
import org.lwjgl.opengl.GL11;
import tconstruct.client.tabs.AbstractTab;

public class GuiDBC
extends GuiCNPCInventory
implements IGuiData,
ICustomScrollListener,
IScrollData,
ITextfieldListener {
    public static int activePage = 0;
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/standardbg.png");
    public int prevAura = 0;
    public int currentAura = 0;
    public int showingAura = 0;
    private GuiFormAuraScroll guiScroll;
    private boolean loaded = false;
    private String selected = null;
    private String search = "";
    private PlayerDBCInfo dbcInfo;
    private Form selectedForm;
    private Form viewingForm;
    private ArrayList<String> stackables = new ArrayList();
    private Aura selectedAura;
    private Aura viewingAura;
    private HashMap<String, Integer> loadedData = new HashMap();
    private static DecimalFormat decimalFormat = new DecimalFormat("#.###");

    public GuiDBC() {
        this.xSize = 280;
        this.ySize = 180;
        this.drawDefaultBackground = false;
        this.title = "";
        if (activePage == 0) {
            DBCPacketHandler.Instance.sendToServer(new DBCRequestForm(-1, true, false));
        } else {
            DBCPacketHandler.Instance.sendToServer(new DBCRequestAura(-1, true));
        }
        this.dbcInfo = PlayerDataUtil.getClientDBCInfo();
        if (this.dbcInfo != null) {
            this.showingAura = this.dbcInfo.currentAura != -1 ? 0 : 1;
            this.currentAura = this.dbcInfo.currentAura;
            this.prevAura = this.dbcInfo.currentAura;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.guiScroll == null) {
            this.guiScroll = new GuiFormAuraScroll((GuiScreen)this, 0);
            this.guiScroll.setSize(135, 118);
        }
        GuiNpcButton formsButton = new GuiNpcButton(40, this.guiLeft + 5, this.guiTop + 4, "global.customforms");
        formsButton.field_146120_f = 65;
        formsButton.field_146124_l = activePage != 0;
        formsButton.packedFGColour = 16762406;
        this.addButton(formsButton);
        GuiNpcButton extras = new GuiNpcButton(41, this.guiLeft + 75, this.guiTop + 4, "inventory.extras");
        extras.packedFGColour = 0xF04FFF;
        extras.field_146124_l = activePage != 1;
        extras.field_146120_f = 65;
        this.addButton(extras);
        this.guiScroll.guiLeft = this.guiLeft + 4;
        this.guiScroll.guiTop = this.guiTop + 26;
        GuiNpcButton selectButton = new GuiNpcButton(1, this.guiLeft + 5, this.guiTop + this.ySize - 11, "form.select");
        selectButton.field_146120_f = 65;
        this.addButton(selectButton);
        GuiNpcButton clearButton = new GuiNpcButton(2, this.guiLeft + 75, this.guiTop + this.ySize - 11, "form.clear");
        clearButton.field_146120_f = 65;
        this.addButton(clearButton);
        this.addScroll(this.guiScroll);
        this.addTextField(new GuiNpcTextField(55, (GuiScreen)this, this.field_146289_q, this.guiLeft + 5, this.guiTop + this.ySize - 34, 134, 20, this.search));
        if (activePage == 1) {
            GuiNpcButton hideAura = new GuiNpcButton(3, this.guiLeft + 250, this.guiTop + this.ySize - 11, new String[]{"aura.shown", "aura.hidden"}, this.showingAura);
            hideAura.field_146120_f = 65;
            this.addButton(hideAura);
            int y = this.guiTop + 34;
            this.addLabel(new GuiNpcLabel(1, (Object)"npcdbc.inventory.revampAura", this.guiLeft + 144, y, 0xFFFFFF));
            GuiNpcButton revampAura = new GuiNpcButton(5, this.guiLeft + 265, y - 5, 50, 20, new String[]{"gui.enabled", "gui.disabled"}, ConfigDBCClient.RevampAura ? 0 : 1);
            this.addButton(revampAura);
            this.addLabel(new GuiNpcLabel(10, (Object)"display.bloom", this.guiLeft + 144, y += 24, 0xFFFFFF));
            GuiNpcButton button = new GuiNpcButton(10, this.guiLeft + 265, y - 5, 50, 20, new String[]{"gui.enabled", "gui.disabled"}, ConfigDBCClient.EnableBloom ? 0 : 1);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(11, (Object)"display.outlines", this.guiLeft + 144, y += 24, 0xFFFFFF));
            button = new GuiNpcButton(11, this.guiLeft + 265, y - 5, 50, 20, new String[]{"gui.enabled", "gui.disabled"}, ConfigDBCClient.EnableOutlines ? 0 : 1);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(12, (Object)"display.shaders", this.guiLeft + 144, y += 24, 0xFFFFFF));
            button = new GuiNpcButton(12, this.guiLeft + 265, y - 5, 50, 20, new String[]{"gui.enabled", "gui.disabled"}, ConfigDBCClient.EnableShaders ? 0 : 1);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(13, (Object)"display.firstPersonAura", this.guiLeft + 144, y += 24, 0xFFFFFF));
            this.addTextField(new GuiNpcTextField(66, (GuiScreen)this, this.field_146289_q, this.guiLeft + 279, y - 5, 35, 20, ConfigDBCClient.FirstPerson3DAuraOpacity + ""));
            this.getTextField((int)66).integersOnly = true;
        }
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.resource);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 252, 195);
        this.func_73729_b(this.guiLeft + 252, this.guiTop, 188, 0, 67, 195);
        this.renderScreen();
        super.func_73863_a(i, j, f);
    }

    public void setSelected(String selected) {
        this.selected = selected;
        this.guiScroll.setSelected(selected);
    }

    private void renderScreen() {
        this.func_73733_a(this.guiLeft + 140, this.guiTop + 4, this.guiLeft + this.xSize + 36, this.guiTop + 24, -1072689136, -1072689136);
        this.func_73730_a(this.guiLeft + 140, this.guiLeft + this.xSize + 35, this.guiTop + 25, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        this.func_73733_a(this.guiLeft + 140, this.guiTop + 27, this.guiLeft + this.xSize + 36, this.guiTop + this.ySize - 14, -1609560048, -1609560048);
        this.func_73733_a(this.guiLeft + 140, this.guiTop + this.ySize - 12, this.guiLeft + this.xSize + 36, this.guiTop + this.ySize + 9, -1072689136, -1072689136);
        if (activePage == 0 && this.loaded) {
            String drawString = "";
            if (this.viewingForm != null) {
                drawString = this.viewingForm.getMenuName();
            }
            int textWidth = this.getStringWidthWithoutColor(drawString);
            int centerX = this.guiLeft + 140 + (this.xSize - textWidth + 30 - 140) / 2;
            this.field_146289_q.func_85187_a(drawString, centerX, this.guiTop + 10, CustomNpcResourceListener.DefaultTextColor, true);
            if (this.viewingForm != null) {
                String parent;
                DBCData dbcData = DBCData.getClient();
                byte race = dbcData.Race;
                int y = this.guiTop + 18;
                if (this.viewingForm.requiredForm.containsKey(race)) {
                    parent = "\u00a7fPrev: " + DBCUtils.getFormattedStateName(race, this.viewingForm.requiredForm.get(race).byteValue());
                    parent = Utility.removeBoldColorCode(parent);
                    this.field_146289_q.func_85187_a(parent, this.guiLeft + 143, y += 12, CustomNpcResourceListener.DefaultTextColor, true);
                } else if (this.viewingForm.hasParent() && this.viewingForm.getParent() != null) {
                    parent = "\u00a7fPrev: " + this.viewingForm.getParent().getMenuName();
                    parent = Utility.removeBoldColorCode(parent);
                    this.field_146289_q.func_85187_a(parent, this.guiLeft + 143, y += 12, CustomNpcResourceListener.DefaultTextColor, true);
                }
                if (this.viewingForm.hasChild() && this.viewingForm.getChild() != null) {
                    String child = "\u00a7fNext: " + this.viewingForm.getChild().getMenuName();
                    child = Utility.removeBoldColorCode(child);
                    this.field_146289_q.func_85187_a(child, this.guiLeft + 143, y += 12, CustomNpcResourceListener.DefaultTextColor, true);
                }
                double masteryMulti = this.viewingForm.mastery.calculateMulti("attribute", this.dbcInfo.getFormLevel(this.viewingForm.id));
                int stats = this.guiTop + 18 + 48;
                String label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.strength") + ":";
                String info = "\u00a74x\u00a7c" + decimalFormat.format((double)this.viewingForm.strengthMulti * masteryMulti);
                this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats, CustomNpcResourceListener.DefaultTextColor, true);
                this.field_146289_q.func_85187_a(info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.dexterity") + ":";
                info = "\u00a73x\u00a7b" + decimalFormat.format((double)this.viewingForm.dexMulti * masteryMulti);
                this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats += 12, CustomNpcResourceListener.DefaultTextColor, true);
                this.field_146289_q.func_85187_a(info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.willpower") + ":";
                info = "\u00a76x\u00a7e" + decimalFormat.format((double)this.viewingForm.willMulti * masteryMulti);
                this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats += 12, CustomNpcResourceListener.DefaultTextColor, true);
                this.field_146289_q.func_85187_a(info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                if (this.dbcInfo != null && this.dbcInfo.formLevels.containsKey(this.viewingForm.id)) {
                    label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.mastery") + ":";
                    double masteryValue = this.dbcInfo.formLevels.get(this.viewingForm.id).floatValue();
                    String roundedMastery = String.format("%.2f", masteryValue);
                    info = "\u00a7a" + roundedMastery + " \u00a77/ \u00a7a" + this.viewingForm.mastery.maxLevel;
                    this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats += 12, CustomNpcResourceListener.DefaultTextColor, true);
                    this.field_146289_q.func_85187_a(info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                }
                if (!this.stackables.isEmpty()) {
                    label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable") + ":";
                    info = String.join((CharSequence)"\u00a77, ", this.stackables);
                    this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats += 12, CustomNpcResourceListener.DefaultTextColor, true);
                    this.field_146289_q.func_85187_a(info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                }
                if (this.viewingForm.mastery.hasDodge()) {
                    label = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.dodge") + ":";
                    double dodgeChance = this.viewingForm.mastery.getDodgeChance();
                    double dodgeMultiplier = this.viewingForm.mastery.calculateMulti("dodge", this.dbcInfo.getFormLevel(this.viewingForm.id));
                    double result = dodgeChance * dodgeMultiplier;
                    String resultString = String.format("%.1f", result);
                    info = String.join((CharSequence)"\u00a76, ", resultString + "%");
                    this.field_146289_q.func_85187_a(label, this.guiLeft + 143, stats += 12, CustomNpcResourceListener.DefaultTextColor, true);
                    this.field_146289_q.func_85187_a("\u00a76" + info, this.guiLeft + 200, stats, CustomNpcResourceListener.DefaultTextColor, true);
                }
            }
            if (this.selectedForm != null) {
                String drawSelected = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.selected") + ": " + this.selectedForm.getMenuName();
                this.field_146289_q.func_85187_a(drawSelected, this.guiLeft + 145, this.guiTop + this.ySize - 5, CustomNpcResourceListener.DefaultTextColor, true);
            }
        } else if (this.loaded) {
            String drawString = "\u00a7f" + StatCollector.func_74838_a((String)"npcdbc.inventory.tweaks");
            int textWidth = this.getStringWidthWithoutColor(drawString);
            int centerX = this.guiLeft + 140 + (this.xSize - textWidth + 30 - 140) / 2;
            this.field_146289_q.func_85187_a(drawString, centerX, this.guiTop + 10, CustomNpcResourceListener.DefaultTextColor, true);
            if (this.selectedAura != null) {
                String drawSelected = this.selectedAura.getMenuName();
                this.field_146289_q.func_85187_a(drawSelected, this.guiLeft + 145, this.guiTop + this.ySize - 5, CustomNpcResourceListener.DefaultTextColor, true);
            }
        }
    }

    public int getStringWidthWithoutColor(String text) {
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                if (i >= text.length() - 1) continue;
                ++i;
                continue;
            }
            width += this.field_146289_q.func_78263_a(c);
        }
        return width;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton instanceof AbstractTab) {
            return;
        }
        if (guibutton.field_146127_k <= -100) {
            super.func_146284_a(guibutton);
            return;
        }
        if (guibutton.field_146127_k == 40 && activePage != 0) {
            activePage = 0;
            DBCPacketHandler.Instance.sendToServer(new DBCRequestForm(-1, true, false));
            this.loaded = false;
        }
        if (guibutton.field_146127_k == 41 && activePage != 1) {
            activePage = 1;
            DBCPacketHandler.Instance.sendToServer(new DBCRequestAura(-1, true));
            this.loaded = false;
        }
        if (activePage == 0) {
            if (guibutton.field_146127_k == 1) {
                if (this.selected != null && this.loadedData.containsKey(this.selected)) {
                    int formID = this.loadedData.get(this.selected);
                    DBCPacketHandler.Instance.sendToServer(new DBCSelectForm(formID, false));
                    this.loaded = false;
                }
            } else if (guibutton.field_146127_k == 2) {
                DBCPacketHandler.Instance.sendToServer(new DBCSelectForm(-1, false));
                this.selected = null;
                this.guiScroll.selected = -1;
                this.loaded = false;
            }
        } else if (guibutton.field_146127_k == 1) {
            if (this.selected != null && this.loadedData.containsKey(this.selected)) {
                int auraID = this.loadedData.get(this.selected);
                DBCPacketHandler.Instance.sendToServer(new DBCSelectAura(auraID));
                this.currentAura = auraID;
                this.showingAura = 0;
                this.loaded = false;
            }
        } else if (guibutton.field_146127_k == 2) {
            DBCPacketHandler.Instance.sendToServer(new DBCSelectAura(-1));
            this.selected = null;
            this.guiScroll.selected = -1;
            this.currentAura = -1;
            this.showingAura = 1;
            this.loaded = false;
        } else if (guibutton.field_146127_k == 3) {
            this.showingAura = ((GuiNpcButton)guibutton).getValue();
            if (this.showingAura == 0) {
                if (this.viewingAura != null) {
                    this.currentAura = this.viewingAura.id;
                }
            } else {
                this.currentAura = -1;
            }
        } else if (guibutton.field_146127_k == 5) {
            ConfigDBCClient.RevampAura = ((GuiNpcButton)guibutton).getValue() == 0;
            ConfigDBCClient.RevampAuraProperty.set(ConfigDBCClient.RevampAura);
            ConfigDBCClient.config.save();
        } else if (guibutton.field_146127_k == 10) {
            ConfigDBCClient.EnableBloom = ((GuiNpcButton)guibutton).getValue() == 0;
            ConfigDBCClient.EnableBloomProperty.set(ConfigDBCClient.EnableBloom);
            ConfigDBCClient.config.save();
        } else if (guibutton.field_146127_k == 11) {
            ConfigDBCClient.EnableOutlines = ((GuiNpcButton)guibutton).getValue() == 0;
            ConfigDBCClient.EnableOutlinesProperty.set(ConfigDBCClient.EnableOutlines);
            ConfigDBCClient.config.save();
        } else if (guibutton.field_146127_k == 12) {
            ConfigDBCClient.EnableShaders = ((GuiNpcButton)guibutton).getValue() == 0;
            ConfigDBCClient.EnableShadersProperty.set(ConfigDBCClient.EnableShaders);
            ConfigDBCClient.config.save();
        }
    }

    public void func_73869_a(char c, int i) {
        if ((i == 1 || this.isInventoryKey(i)) && !this.getTextField(55).func_146206_l()) {
            this.close();
        }
        if (this.getTextField(55).func_146206_l() && i == 1) {
            this.getTextField(55).func_146180_a("");
        }
        super.func_73869_a(c, i);
        if (this.getTextField(55) != null && this.getTextField(55).func_146206_l()) {
            if (this.search.equals(this.getTextField(55).func_146179_b())) {
                return;
            }
            this.search = this.getTextField(55).func_146179_b().toLowerCase();
            this.guiScroll.resetScroll();
            this.guiScroll.setList(this.getSearch());
            if (this.viewingForm != null) {
                this.setSelected(this.viewingForm.name);
            } else if (this.viewingAura != null) {
                this.setSelected(this.viewingAura.name);
            }
        }
    }

    public void func_73864_a(int i, int j, int k) {
        if (this.getTextField(55).func_146206_l() && k == 1) {
            this.getTextField(55).func_146180_a("");
            this.search = "";
            this.guiScroll.setList(this.getSearch());
            this.setSelected(this.selected);
        }
        super.func_73864_a(i, j, k);
    }

    private List<String> getSearch() {
        if (this.search.isEmpty()) {
            return new ArrayList<String>(this.loadedData.keySet());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.loadedData.keySet()) {
            if (!name.toLowerCase().contains(this.search)) continue;
            list.add(name);
        }
        return list;
    }

    public void setData(Vector<String> list, HashMap<String, Integer> data, EnumScrollData dataType) {
        String name = this.guiScroll.getSelected();
        this.loadedData = data;
        if (this.guiScroll != null) {
            this.guiScroll.setList(this.getSearch());
        }
        if (this.guiScroll != null && name != null) {
            this.guiScroll.setSelected(name);
        }
        this.func_73866_w_();
    }

    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_82582_d()) {
            this.viewingAura = null;
            this.viewingForm = null;
            this.selectedAura = null;
            this.selectedForm = null;
            this.selected = null;
            this.setSelected(this.selected);
            this.registerStackables();
        } else if (!compound.func_74764_b("Skip")) {
            if (compound.func_74764_b("Type") && compound.func_74779_i("Type").equals("ViewAura")) {
                this.viewingAura = new Aura();
                this.viewingForm = null;
                this.viewingAura.readFromNBT(compound);
                this.setSelected(this.viewingAura.name);
                this.registerStackables();
            } else if (compound.func_74764_b("Type") && compound.func_74779_i("Type").equals("ViewForm")) {
                this.viewingForm = new Form();
                this.viewingAura = null;
                this.viewingForm.readFromNBT(compound);
                this.setSelected(this.viewingForm.name);
                this.registerStackables();
            } else if (compound.func_74764_b("attributes")) {
                this.viewingForm = new Form();
                this.selectedForm = new Form();
                this.viewingAura = null;
                this.selectedAura = null;
                this.selectedForm.readFromNBT(compound);
                this.viewingForm.readFromNBT(compound);
                this.setSelected(this.viewingForm.name);
                this.registerStackables();
            } else {
                this.selectedAura = new Aura();
                this.viewingAura = new Aura();
                this.selectedForm = null;
                this.viewingForm = null;
                this.selectedAura.readFromNBT(compound);
                this.viewingAura.readFromNBT(compound);
                this.setSelected(this.viewingAura.name);
                this.registerStackables();
            }
        }
        this.loaded = true;
        this.func_73866_w_();
    }

    public void customScrollClicked(int i, int j, int k, GuiCustomScroll guiCustomScroll) {
        if (this.guiScroll != null && guiCustomScroll.id == this.guiScroll.id) {
            if (activePage == 0) {
                if (this.selected != null && this.selected.equals(this.guiScroll.getSelected())) {
                    this.selected = "";
                    this.guiScroll.selected = -1;
                    this.viewingForm = null;
                    return;
                }
                this.selected = this.guiScroll.getSelected();
                DBCPacketHandler.Instance.sendToServer(new DBCGetForm(this.loadedData.get(this.selected)));
            } else {
                if (this.selected != null && this.selected.equals(this.guiScroll.getSelected())) {
                    this.selected = "";
                    this.guiScroll.selected = -1;
                    this.viewingAura = null;
                    return;
                }
                this.selected = this.guiScroll.getSelected();
                DBCPacketHandler.Instance.sendToServer(new DBCGetAura(this.loadedData.get(this.selected)));
            }
        }
    }

    public void customScrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }

    public void close() {
        if (this.prevAura != this.currentAura) {
            DBCPacketHandler.Instance.sendToServer(new DBCSetAura(this.currentAura));
        }
        super.close();
    }

    public void registerStackables() {
        this.stackables.clear();
        if (this.viewingForm != null) {
            if (this.viewingForm.stackable.vanillaStackable) {
                this.stackables.add("\u00a7e" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable.dbc"));
            }
            if (this.viewingForm.stackable.kaiokenStackable) {
                this.stackables.add("\u00a7c" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable.kk"));
            }
            if (this.viewingForm.stackable.uiStackable) {
                this.stackables.add("\u00a77" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable.ui"));
            }
            if (this.viewingForm.stackable.godStackable) {
                this.stackables.add("\u00a75" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable.godofdestruction"));
            }
            if (this.viewingForm.stackable.mysticStackable) {
                this.stackables.add("\u00a7d" + StatCollector.func_74838_a((String)"npcdbc.inventory.stackable.mystic"));
            }
        }
    }

    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 66) {
            ConfigDBCClient.FirstPerson3DAuraOpacity = textfield.getInteger();
            ConfigDBCClient.FirstPerson3DAuraOpacityProperty.set(ConfigDBCClient.FirstPerson3DAuraOpacity);
            ConfigDBCClient.config.save();
        }
    }
}

