/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.EnumChannelType;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.get.CapsuleInfo;
import kamkeel.npcdbc.network.packets.get.DBCInfoSyncPacket;
import kamkeel.npcdbc.network.packets.get.aura.DBCGetAura;
import kamkeel.npcdbc.network.packets.get.form.DBCGetForm;
import kamkeel.npcdbc.network.packets.get.outline.DBCGetOutline;
import kamkeel.npcdbc.network.packets.player.DBCSetFlight;
import kamkeel.npcdbc.network.packets.player.DBCSetValPacket;
import kamkeel.npcdbc.network.packets.player.DBCUpdateLockOn;
import kamkeel.npcdbc.network.packets.player.LoginInfo;
import kamkeel.npcdbc.network.packets.player.NPCUpdateForcedColors;
import kamkeel.npcdbc.network.packets.player.PingFormColorPacket;
import kamkeel.npcdbc.network.packets.player.PingPacket;
import kamkeel.npcdbc.network.packets.player.PlaySound;
import kamkeel.npcdbc.network.packets.player.SaveFormCustomization;
import kamkeel.npcdbc.network.packets.player.SendChat;
import kamkeel.npcdbc.network.packets.player.StopSound;
import kamkeel.npcdbc.network.packets.player.TransformPacket;
import kamkeel.npcdbc.network.packets.player.TurboPacket;
import kamkeel.npcdbc.network.packets.player.aura.DBCRequestAura;
import kamkeel.npcdbc.network.packets.player.aura.DBCSelectAura;
import kamkeel.npcdbc.network.packets.player.aura.DBCSetAura;
import kamkeel.npcdbc.network.packets.player.form.DBCRequestForm;
import kamkeel.npcdbc.network.packets.player.form.DBCRequestFormWheel;
import kamkeel.npcdbc.network.packets.player.form.DBCSaveFormWheel;
import kamkeel.npcdbc.network.packets.player.form.DBCSelectForm;
import kamkeel.npcdbc.network.packets.player.outline.DBCRequestOutline;
import kamkeel.npcdbc.network.packets.request.aura.DBCRemoveAura;
import kamkeel.npcdbc.network.packets.request.aura.DBCSaveAura;
import kamkeel.npcdbc.network.packets.request.form.DBCRemoveForm;
import kamkeel.npcdbc.network.packets.request.form.DBCSaveForm;
import kamkeel.npcdbc.network.packets.request.outline.DBCRemoveOutline;
import kamkeel.npcdbc.network.packets.request.outline.DBCSaveOutline;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.config.ConfigMain;
import noppes.npcs.entity.EntityNPCInterface;

public class DBCPacketHandler {
    public static DBCPacketHandler Instance;
    public Map<EnumChannelType, FMLEventChannel> channels = new Hashtable<EnumChannelType, FMLEventChannel>();
    public static final PacketChannel REQUEST_PACKETS;
    public static final PacketChannel GET_PACKETS;
    public static final PacketChannel PLAYER_PACKETS;
    public static final List<PacketChannel> packetChannels;

    public DBCPacketHandler() {
        packetChannels.add(REQUEST_PACKETS);
        packetChannels.add(GET_PACKETS);
        packetChannels.add(PLAYER_PACKETS);
        this.registerRequestPackets();
        this.registerGetPackets();
        this.registerPlayerPackets();
    }

    private void registerPlayerPackets() {
        PLAYER_PACKETS.registerPacket(new DBCRequestFormWheel());
        PLAYER_PACKETS.registerPacket(new DBCRequestAura());
        PLAYER_PACKETS.registerPacket(new DBCSelectAura());
        PLAYER_PACKETS.registerPacket(new DBCRequestForm());
        PLAYER_PACKETS.registerPacket(new DBCSetAura());
        PLAYER_PACKETS.registerPacket(new DBCSelectForm());
        PLAYER_PACKETS.registerPacket(new DBCSaveFormWheel());
        PLAYER_PACKETS.registerPacket(new DBCSetFlight());
        PLAYER_PACKETS.registerPacket(new DBCRequestOutline());
        PLAYER_PACKETS.registerPacket(new TurboPacket());
        PLAYER_PACKETS.registerPacket(new TransformPacket());
        PLAYER_PACKETS.registerPacket(new StopSound());
        PLAYER_PACKETS.registerPacket(new SendChat());
        PLAYER_PACKETS.registerPacket(new SaveFormCustomization());
        PLAYER_PACKETS.registerPacket(new PlaySound());
        PLAYER_PACKETS.registerPacket(new PingPacket());
        PLAYER_PACKETS.registerPacket(new PingFormColorPacket());
        PLAYER_PACKETS.registerPacket(new NPCUpdateForcedColors());
        PLAYER_PACKETS.registerPacket(new LoginInfo());
        PLAYER_PACKETS.registerPacket(new DBCUpdateLockOn());
        PLAYER_PACKETS.registerPacket(new DBCSetValPacket());
    }

    private void registerGetPackets() {
        GET_PACKETS.registerPacket(new DBCGetAura());
        GET_PACKETS.registerPacket(new DBCGetForm());
        GET_PACKETS.registerPacket(new DBCGetOutline());
        GET_PACKETS.registerPacket(new CapsuleInfo());
        GET_PACKETS.registerPacket(new DBCInfoSyncPacket());
    }

    private void registerRequestPackets() {
        REQUEST_PACKETS.registerPacket(new DBCRemoveAura());
        REQUEST_PACKETS.registerPacket(new DBCSaveAura());
        REQUEST_PACKETS.registerPacket(new DBCRemoveForm());
        REQUEST_PACKETS.registerPacket(new DBCSaveForm());
        REQUEST_PACKETS.registerPacket(new DBCRemoveOutline());
        REQUEST_PACKETS.registerPacket(new DBCSaveOutline());
    }

    public void registerChannels() {
        for (PacketChannel channel : packetChannels) {
            FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channel.getChannelName());
            eventChannel.register((Object)this);
            this.channels.put(channel.getChannelType(), eventChannel);
        }
    }

    public PacketChannel getPacketChannel(EnumChannelType type) {
        return packetChannels.stream().filter(channel -> channel.getChannelType() == type).findFirst().orElse(null);
    }

    public FMLEventChannel getEventChannel(AbstractPacket abstractPacket) {
        PacketChannel packetChannel = this.getPacketChannel(abstractPacket.getChannel().getChannelType());
        if (packetChannel == null) {
            return null;
        }
        return this.channels.get((Object)packetChannel.getChannelType());
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.handlePacket(event.packet, (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b, Side.SERVER);
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.handlePacket(event.packet, CustomNpcs.proxy.getPlayer(), Side.CLIENT);
    }

    private void handlePacket(FMLProxyPacket packet, EntityPlayer player, Side side) {
        ByteBuf buf = packet.payload();
        try {
            int packetTypeOrdinal = buf.readInt();
            EnumChannelType packetType = EnumChannelType.values()[packetTypeOrdinal];
            PacketChannel packetChannel = this.getPacketChannel(packetType);
            if (packetChannel == null) {
                LogWriter.error((Object)("Error: Packet channel is null for packet type: " + (Object)((Object)packetType)));
                return;
            }
            int packetId = buf.readInt();
            AbstractPacket abstractPacket = packetChannel.packets.get(packetId);
            if (abstractPacket == null) {
                LogWriter.error((Object)("Error: Abstract packet is null for packet ID: " + packetId));
                return;
            }
            if (side == Side.SERVER) {
                if (abstractPacket.getChannel() == REQUEST_PACKETS && ConfigMain.OpsOnly && !NoppesUtilServer.isOp((EntityPlayer)player)) {
                    LogWriter.error((Object)String.format("%s tried to use CNPC+ without being an op", player.func_70005_c_()));
                    return;
                }
                if (abstractPacket.getPermission() != null && !CustomNpcsPermissions.hasPermission((EntityPlayer)player, (CustomNpcsPermissions.Permission)abstractPacket.getPermission())) {
                    return;
                }
                EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                if (abstractPacket.needsNPC() && npc == null) {
                    return;
                }
                abstractPacket.setNPC(npc);
            }
            abstractPacket.receiveData(buf, player);
        }
        catch (IndexOutOfBoundsException e) {
            LogWriter.error((Object)("Error: IndexOutOfBoundsException in handlePacket: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (Exception e) {
            LogWriter.error((Object)("Error: Exception in handlePacket: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void sendAllPackets(AbstractPacket packet, SendAction action) {
        List<FMLProxyPacket> proxyPackets = packet.generatePackets();
        if (proxyPackets.isEmpty()) {
            LogWriter.error((Object)("Warning: No packets generated for " + packet.getClass().getName()));
        }
        for (FMLProxyPacket proxy : proxyPackets) {
            action.send(proxy);
        }
    }

    public void sendToPlayer(AbstractPacket packet, EntityPlayerMP player) {
        FMLEventChannel eventChannel = this.getEventChannel(packet);
        if (eventChannel == null) {
            LogWriter.error((Object)("Error: Event channel is null for packet: " + packet.getClass().getName()));
            return;
        }
        this.sendAllPackets(packet, p -> eventChannel.sendTo(p, player));
    }

    public void sendToServer(AbstractPacket packet) {
        FMLEventChannel eventChannel = this.getEventChannel(packet);
        if (eventChannel == null) {
            LogWriter.error((Object)("Error: Event channel is null for packet: " + packet.getClass().getName()));
            return;
        }
        this.sendAllPackets(packet, arg_0 -> ((FMLEventChannel)eventChannel).sendToServer(arg_0));
    }

    public void sendToAll(AbstractPacket packet) {
        FMLEventChannel eventChannel = this.getEventChannel(packet);
        if (eventChannel == null) {
            LogWriter.error((Object)("Error: Event channel is null for packet: " + packet.getClass().getName()));
            return;
        }
        this.sendAllPackets(packet, arg_0 -> ((FMLEventChannel)eventChannel).sendToAll(arg_0));
    }

    public void sendToDimension(AbstractPacket packet, int dimensionId) {
        FMLEventChannel eventChannel = this.getEventChannel(packet);
        if (eventChannel == null) {
            LogWriter.error((Object)("Error: Event channel is null for packet: " + packet.getClass().getName()));
            return;
        }
        this.sendAllPackets(packet, p -> eventChannel.sendToDimension(p, dimensionId));
    }

    public void sendTracking(AbstractPacket packet, Entity entity) {
        FMLEventChannel eventChannel = this.getEventChannel(packet);
        if (eventChannel == null) {
            LogWriter.error((Object)("Error: Event channel is null for packet: " + packet.getClass().getName()));
            return;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 60.0);
        this.sendAllPackets(packet, p -> eventChannel.sendToAllAround(p, point));
    }

    static {
        REQUEST_PACKETS = new PacketChannel("NPCDBC|REQUEST", EnumChannelType.REQUEST);
        GET_PACKETS = new PacketChannel("NPCDBC|GET", EnumChannelType.GET);
        PLAYER_PACKETS = new PacketChannel("NPCDBC|PLAYER", EnumChannelType.PLAYER);
        packetChannels = new ArrayList<PacketChannel>();
    }

    private static interface SendAction {
        public void send(FMLProxyPacket var1);
    }
}

