/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.effects;

import java.util.LinkedList;

public class SenzuConsumptionData {
    private final LinkedList<Long> consumptionTimestamps = new LinkedList();
    private long lastConsumptionTimestamp;

    public void addConsumption(long timestamp) {
        this.consumptionTimestamps.add(timestamp);
        this.lastConsumptionTimestamp = timestamp;
    }

    public void cleanOldConsumption(long currentTime, int decreaseTime) {
        long timeWindow = (long)decreaseTime * 50L;
        while (!this.consumptionTimestamps.isEmpty() && currentTime - this.consumptionTimestamps.peek() > timeWindow) {
            this.consumptionTimestamps.poll();
        }
    }

    public int getExcessConsumption(int threshold) {
        int currentConsumption = this.consumptionTimestamps.size();
        return Math.max(0, currentConsumption - threshold);
    }

    public int getCurrentConsumption() {
        return this.consumptionTimestamps.size();
    }

    public void decreaseConsumption(int decreaseTime) {
        if (!this.consumptionTimestamps.isEmpty()) {
            this.consumptionTimestamps.poll();
        }
    }
}

