/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.dbcdata;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import kamkeel.npcdbc.client.ClientCache;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.config.ConfigClient;
import noppes.npcs.util.CacheHashMap;

public class DBCDataUniversal {
    public static final CacheHashMap<String, CacheHashMap.CachedObject<DBCData>> dbcDataCache = new CacheHashMap((long)ConfigClient.CacheLife * 60L * 1000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBCData getData(EntityPlayer player) {
        CacheHashMap<String, CacheHashMap.CachedObject<DBCData>> cacheHashMap = dbcDataCache;
        synchronized (cacheHashMap) {
            if (!dbcDataCache.containsKey((Object)player.func_70005_c_())) {
                dbcDataCache.put((Object)player.func_70005_c_(), (Object)new CacheHashMap.CachedObject((Object)new DBCData(player)));
            }
            return (DBCData)dbcDataCache.get((Object)player.func_70005_c_()).getObject();
        }
    }

    public static DBCData get(EntityPlayer player) {
        DBCData data;
        if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K) {
            data = ClientCache.getClientData(player);
        } else {
            assert (player != null);
            data = DBCDataUniversal.getData(player);
            data.loadNBTData(false);
        }
        if (data != null) {
            data.player = player;
        }
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public static DBCData getClient() {
        return DBCDataUniversal.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public static Aura getAura(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        DBCData dbcData = DBCDataUniversal.get(player);
        if (dbcData == null) {
            return null;
        }
        int form = dbcData.auraID;
        if (form == -1) {
            return null;
        }
        return (Aura)AuraController.getInstance().get(form);
    }

    public static Form getForm(EntityPlayer p) {
        if (Utility.isServer((Entity)p)) {
            return PlayerDataUtil.getDBCInfo(p) != null ? PlayerDataUtil.getDBCInfo(p).getCurrentForm() : null;
        }
        DBCData dbcData = DBCDataUniversal.get(p);
        if (dbcData == null) {
            return null;
        }
        int form = dbcData.addonFormID;
        if (form == -1) {
            return null;
        }
        return dbcData.getForm();
    }

    public static float getFormLevel(EntityPlayer player) {
        DBCData dbcData = DBCDataUniversal.get(player);
        if (dbcData == null) {
            return 0.0f;
        }
        return dbcData.addonFormLevel;
    }

    public static void fusePlayers(EntityPlayer controller, EntityPlayer spectator, float time) {
        DBCDataUniversal.fusePlayers(DBCDataUniversal.get(controller), DBCDataUniversal.get(spectator), time);
    }

    private static void fusePlayers(DBCData controller, DBCData spectator, float time) {
        controller.fuseWith(spectator, time);
    }
}

