/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.dbcdata;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DBCDataBonus {
    private final DBCData data;

    public DBCDataBonus(DBCData dbcData) {
        this.data = dbcData;
    }

    public Map<String, PlayerBonus> getCurrentBonuses() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.data.currentBonuses == null) {
                this.data.currentBonuses = new HashMap<String, PlayerBonus>();
            }
            return this.data.currentBonuses;
        }
        return BonusController.getInstance().getPlayerBonus(this.data.player);
    }

    public BonusTotals calculateTotals() {
        float[] multi = new float[5];
        float[] flat = new float[5];
        for (PlayerBonus playerBonus : this.getCurrentBonuses().values()) {
            if (playerBonus.type == 0) {
                multi[0] = multi[0] + playerBonus.strength;
                multi[1] = multi[1] + playerBonus.dexterity;
                multi[2] = multi[2] + playerBonus.willpower;
                multi[3] = multi[3] + playerBonus.constituion;
                multi[4] = multi[4] + playerBonus.spirit;
                continue;
            }
            if (playerBonus.type != 1) continue;
            flat[0] = flat[0] + playerBonus.strength;
            flat[1] = flat[1] + playerBonus.dexterity;
            flat[2] = flat[2] + playerBonus.willpower;
            flat[3] = flat[3] + playerBonus.constituion;
            flat[4] = flat[4] + playerBonus.spirit;
        }
        return new BonusTotals(multi, flat);
    }

    public float[] getMultiBonus() {
        return this.calculateTotals().copyMultipliers();
    }

    public float[] getFlatBonus() {
        return this.calculateTotals().copyFlatAdditions();
    }

    public float getMultiBonusForAttribute(int attributeID) {
        return this.calculateTotals().getMultiplier(attributeID);
    }

    public float getFlatBonusForAttribute(int attributeID) {
        return this.calculateTotals().getFlat(attributeID);
    }

    public void saveBonusNBT(NBTTagCompound nbt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (PlayerBonus bonus : this.getCurrentBonuses().values()) {
            nbttaglist.func_74742_a((NBTBase)bonus.writeBonusData(new NBTTagCompound()));
        }
        nbt.func_74782_a("addonBonus", (NBTBase)nbttaglist);
    }

    private static int toBonusIndex(int attributeID) {
        switch (attributeID) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        return -1;
    }

    public static final class BonusTotals {
        private final float[] multipliers;
        private final float[] flatAdditions;

        private BonusTotals(float[] multipliers, float[] flatAdditions) {
            this.multipliers = multipliers;
            this.flatAdditions = flatAdditions;
        }

        public float[] copyMultipliers() {
            return (float[])this.multipliers.clone();
        }

        public float[] copyFlatAdditions() {
            return (float[])this.flatAdditions.clone();
        }

        public float getMultiplier(int attributeID) {
            return this.getValue(attributeID, this.multipliers);
        }

        public float getFlat(int attributeID) {
            return this.getValue(attributeID, this.flatAdditions);
        }

        private float getValue(int attributeID, float[] values) {
            int index = DBCDataBonus.toBonusIndex(attributeID);
            return index >= 0 ? values[index] : 0.0f;
        }
    }
}

