/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.playertab.client;

import com.mojang.authlib.GameProfile;
import io.github.cruciblemc.necrotempus.api.playertab.PlayerTab;
import io.github.cruciblemc.necrotempus.api.playertab.TabCell;
import io.github.cruciblemc.necrotempus.modules.features.playertab.client.render.PlayerTabGui;
import io.github.cruciblemc.necrotempus.utils.NetHandlerPlayClientNT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.StringUtils;

public class DefaultPlayerTab
extends PlayerTab {
    private static PlayerTab instance;
    private static Long lastCellsUpdate;
    private static List<TabCell> cachedList;

    public static PlayerTab getInstance() {
        return instance != null ? instance : new DefaultPlayerTab();
    }

    private DefaultPlayerTab() {
        instance = this;
    }

    @Override
    public IChatComponent getHeader() {
        return null;
    }

    @Override
    public IChatComponent getFooter() {
        return null;
    }

    @Override
    public List<TabCell> getCellList() {
        long time;
        if (lastCellsUpdate != null && (time = System.currentTimeMillis() - lastCellsUpdate) <= 250L && cachedList != null) {
            return cachedList;
        }
        lastCellsUpdate = System.currentTimeMillis();
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<TabCell> tabCells = new ArrayList<TabCell>();
        NetHandlerPlayClientNT handlerWrapper = NetHandlerPlayClientNT.of(minecraft.field_71439_g.field_71174_a);
        for (GuiPlayerInfo guiPlayerInfo : handlerWrapper.getServerPlayers()) {
            EntityPlayer entityPlayer = minecraft.field_71441_e.func_72924_a(guiPlayerInfo.field_78831_a);
            String name = guiPlayerInfo.field_78831_a;
            if (StringUtils.isBlank((CharSequence)name)) continue;
            GameProfile gameProfile = entityPlayer != null ? entityPlayer.func_146103_bH() : new GameProfile(null, name);
            tabCells.add(new TabCell((IChatComponent)new ChatComponentText(PlayerTabGui.getFormattedPlayerName(guiPlayerInfo.field_78831_a, minecraft)), guiPlayerInfo.field_78831_a, gameProfile, true, guiPlayerInfo.field_78829_b));
        }
        cachedList = tabCells;
        return tabCells;
    }

    @Override
    public boolean isDrawPlayerHeads() {
        return true;
    }
}

