/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import kamkeel.hextext.config.HexTextConfig;

public class SyncConfigMessage
implements IMessage {
    public boolean universalAmpersand;
    public boolean chatAmpersands;
    public boolean signAmpersands;
    public boolean repairAmpersands;
    public boolean allowSignEditing;
    public boolean enableHtmlFormat;

    public SyncConfigMessage() {
    }

    public SyncConfigMessage(boolean universalAmpersand, boolean chatAmpersands, boolean signAmpersands, boolean repairAmpersands, boolean allowSignEditing, boolean enableHtmlFormat) {
        this.universalAmpersand = universalAmpersand;
        this.chatAmpersands = chatAmpersands;
        this.signAmpersands = signAmpersands;
        this.repairAmpersands = repairAmpersands;
        this.allowSignEditing = allowSignEditing;
        this.enableHtmlFormat = enableHtmlFormat;
    }

    public static SyncConfigMessage fromServerConfig() {
        return new SyncConfigMessage(HexTextConfig.isUniversalAmpersandEnabled(), HexTextConfig.isChatAmpersandConversionEnabled(), HexTextConfig.isSignAmpersandConversionEnabled(), HexTextConfig.isRepairAmpersandConversionEnabled(), HexTextConfig.isSignEditingAllowed(), HexTextConfig.isRgbHtmlFormatEnabled());
    }

    public void fromBytes(ByteBuf buf) {
        this.universalAmpersand = buf.readBoolean();
        this.chatAmpersands = buf.readBoolean();
        this.signAmpersands = buf.readBoolean();
        this.repairAmpersands = buf.readBoolean();
        this.allowSignEditing = buf.readBoolean();
        this.enableHtmlFormat = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.universalAmpersand);
        buf.writeBoolean(this.chatAmpersands);
        buf.writeBoolean(this.signAmpersands);
        buf.writeBoolean(this.repairAmpersands);
        buf.writeBoolean(this.allowSignEditing);
        buf.writeBoolean(this.enableHtmlFormat);
    }
}

