/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.mixin.early.impl.sign;

import kamkeel.hextext.HexText;
import kamkeel.hextext.api.sign.IHexTextSign;
import kamkeel.hextext.api.sign.SignSide;
import kamkeel.hextext.common.sign.SignSyncPacket;
import kamkeel.hextext.common.util.SignTextHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S33PacketUpdateSign;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntitySign.class})
public abstract class MixinTileEntitySign
extends TileEntity
implements IHexTextSign {
    @Unique
    private boolean isWaxed = false;
    @Shadow
    public String[] field_145915_a;
    @Shadow
    private boolean field_145916_j;
    @Unique
    private boolean[] glowStates = new boolean[SignSide.values().length];
    @Unique
    private boolean[] outlineStates = new boolean[SignSide.values().length];
    @Unique
    private String[] backSignText = new String[]{"", "", "", ""};
    @Unique
    SignSide editSide = SignSide.FRONT;

    @Inject(method={"readFromNBT"}, at={@At(value="RETURN")})
    private void hextext$clampLoadedLines(NBTTagCompound compound, CallbackInfo ci) {
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return;
        }
        if (this.field_145915_a != null) {
            this.hextext$clampLines(this.field_145915_a);
        }
        this.isWaxed = compound.func_74767_n("HexTextWaxed");
        this.glowStates[SignSide.FRONT.ordinal()] = compound.func_74767_n("HexTextGlowFront");
        this.glowStates[SignSide.BACK.ordinal()] = compound.func_74767_n("HexTextGlowBack");
        this.outlineStates[SignSide.FRONT.ordinal()] = compound.func_74767_n("HexTextOutlineFront");
        this.outlineStates[SignSide.BACK.ordinal()] = compound.func_74767_n("HexTextOutlineBack");
        if (compound.func_74764_b("HexTextBackText0")) {
            for (int i = 0; i < this.backSignText.length; ++i) {
                this.backSignText[i] = compound.func_74779_i("HexTextBackText" + i);
            }
        }
        this.hextext$clampLines(this.backSignText);
        this.field_145916_j = !this.isWaxed;
    }

    @Inject(method={"writeToNBT"}, at={@At(value="RETURN")})
    private void hextext$writeCustomData(NBTTagCompound compound, CallbackInfo ci) {
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return;
        }
        compound.func_74757_a("HexTextWaxed", this.isWaxed);
        compound.func_74757_a("HexTextGlowFront", this.glowStates[SignSide.FRONT.ordinal()]);
        compound.func_74757_a("HexTextGlowBack", this.glowStates[SignSide.BACK.ordinal()]);
        compound.func_74757_a("HexTextOutlineFront", this.outlineStates[SignSide.FRONT.ordinal()]);
        compound.func_74757_a("HexTextOutlineBack", this.outlineStates[SignSide.BACK.ordinal()]);
        for (int i = 0; i < this.backSignText.length; ++i) {
            compound.func_74778_a("HexTextBackText" + i, this.backSignText[i]);
        }
        this.field_145916_j = !this.isWaxed;
    }

    @Override
    @Unique
    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    @Unique
    public void setWaxed(boolean waxed) {
        if (this.isWaxed != waxed) {
            this.isWaxed = waxed;
            this.func_70296_d();
        }
    }

    @Override
    @Unique
    public boolean isGlowing(SignSide side) {
        return this.glowStates[side.ordinal()];
    }

    @Override
    @Unique
    public boolean setGlowing(SignSide side, boolean glowing) {
        int index = side.ordinal();
        boolean changed = this.glowStates[index] != glowing;
        this.glowStates[index] = glowing;
        if (changed) {
            this.func_70296_d();
        }
        return changed;
    }

    @Override
    @Unique
    public boolean isOutlined(SignSide side) {
        return this.outlineStates[side.ordinal()];
    }

    @Override
    @Unique
    public boolean setOutlined(SignSide side, boolean outlined) {
        int index = side.ordinal();
        boolean changed = this.outlineStates[index] != outlined;
        this.outlineStates[index] = outlined;
        if (changed) {
            this.func_70296_d();
        }
        return changed;
    }

    @Override
    @Unique
    public void setEditSide(SignSide side) {
        this.editSide = side;
    }

    @Override
    @Unique
    public SignSide getEditSide() {
        return this.editSide;
    }

    @Override
    @Unique
    public String[] getLines(SignSide side) {
        return side == SignSide.FRONT ? this.field_145915_a : this.backSignText;
    }

    @Inject(method={"getDescriptionPacket"}, at={@At(value="RETURN")})
    private void hextext$appendCustomSyncData(CallbackInfoReturnable<Packet> cir) {
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return;
        }
        Packet packet = (Packet)cir.getReturnValue();
        if (!(packet instanceof S33PacketUpdateSign)) {
            return;
        }
        SignSyncPacket sync = (SignSyncPacket)packet;
        sync.setBackText(this.backSignText);
        sync.setGlowing(SignSide.FRONT, this.glowStates[SignSide.FRONT.ordinal()]);
        sync.setGlowing(SignSide.BACK, this.glowStates[SignSide.BACK.ordinal()]);
        sync.setOutlined(SignSide.FRONT, this.outlineStates[SignSide.FRONT.ordinal()]);
        sync.setOutlined(SignSide.BACK, this.outlineStates[SignSide.BACK.ordinal()]);
        sync.setWaxed(this.isWaxed);
    }

    @Unique
    private void hextext$clampLines(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = SignTextHelper.clampToVisibleLimit(lines[i]);
        }
    }
}

