/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.mixin.early.impl.sign;

import java.util.Set;
import kamkeel.hextext.HexText;
import kamkeel.hextext.api.HexTextApi;
import kamkeel.hextext.api.sign.IHexTextSign;
import kamkeel.hextext.api.sign.SignInteractionType;
import kamkeel.hextext.api.sign.SignSide;
import kamkeel.hextext.common.sign.SignSideHelper;
import kamkeel.hextext.common.util.ItemHelper;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockSign;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockSign.class})
public abstract class MixinBlockSign
extends BlockContainer {
    protected MixinBlockSign(Material p_i45386_1_) {
        super(p_i45386_1_);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        Set<SignInteractionType> interactions;
        if (player == null || player.func_70093_af()) {
            return false;
        }
        if (!HexText.getActiveProxy().isRemoteHexTextPresent()) {
            return false;
        }
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntitySign)) {
            return false;
        }
        TileEntitySign sign = (TileEntitySign)tileEntity;
        IHexTextSign hexTextSign = (IHexTextSign)sign;
        if (hexTextSign.isWaxed()) {
            return true;
        }
        SignSide clickedSide = SignSideHelper.determineSide(sign, player.field_70165_t, player.field_70161_v, subX, subZ);
        ItemStack stack = player.func_71045_bC();
        if (stack != null && !(interactions = HexTextApi.signInteractions().getInteractions(stack)).isEmpty()) {
            boolean changed;
            if (worldIn.field_72995_K) {
                return true;
            }
            boolean consumed = false;
            boolean updated = false;
            if (interactions.contains((Object)SignInteractionType.CLEANSE)) {
                changed = false;
                changed |= hexTextSign.setGlowing(clickedSide, false);
                if (changed |= hexTextSign.setOutlined(clickedSide, false)) {
                    updated = true;
                    if (!consumed) {
                        ItemHelper.consumeItem(player, stack);
                        consumed = true;
                    }
                }
            }
            if (interactions.contains((Object)SignInteractionType.WAX) && !hexTextSign.isWaxed()) {
                hexTextSign.setWaxed(true);
                updated = true;
                if (!consumed) {
                    ItemHelper.consumeItem(player, stack);
                    consumed = true;
                }
            }
            if (interactions.contains((Object)SignInteractionType.GLOW) && (changed = hexTextSign.setGlowing(clickedSide, true))) {
                updated = true;
                if (!consumed) {
                    ItemHelper.consumeItem(player, stack);
                    consumed = true;
                }
            }
            if (interactions.contains((Object)SignInteractionType.OUTLINE) && (changed = hexTextSign.setOutlined(clickedSide, true))) {
                updated = true;
                if (!consumed) {
                    ItemHelper.consumeItem(player, stack);
                    consumed = true;
                }
            }
            if (updated) {
                worldIn.func_147471_g(x, y, z);
                tileEntity.func_70296_d();
            }
            return true;
        }
        if (stack != null) {
            return false;
        }
        if (!HexText.getActiveProxy().allowSignEditing()) {
            return false;
        }
        sign.func_145912_a(player);
        if (worldIn.field_72995_K) {
            hexTextSign.setEditSide(clickedSide);
            player.func_146100_a((TileEntity)sign);
        }
        return true;
    }
}

