/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.util;

import java.util.ArrayDeque;
import kamkeel.hextext.common.util.ColorCodeUtils;

public final class StringUtils {
    public static char SECTION_SIGN = (char)167;

    private StringUtils() {
    }

    public static String normalizeForRawDisplay(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder builder = null;
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current == '\u00a7') {
                if (builder == null) {
                    builder = new StringBuilder(text.length() + 8);
                    builder.append(text, 0, i);
                }
                if (i + 1 < text.length()) {
                    builder.append('&');
                    builder.append(text.charAt(++i));
                    continue;
                }
                builder.append('\u00a7');
                continue;
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static String convertAmpersandsToSectionSigns(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder builder = null;
        int index = 0;
        while (index < text.length()) {
            int codeLen;
            char current = text.charAt(index);
            if (current == '&' && ((codeLen = ColorCodeUtils.detectAmpersandFormattingCodeLength(text, index)) == 2 || codeLen == 8)) {
                if (builder == null) {
                    builder = new StringBuilder(text.length());
                    builder.append(text, 0, index);
                }
                builder.append(SECTION_SIGN);
                builder.append(text, index + 1, index + codeLen);
                index += codeLen;
                continue;
            }
            if (builder != null) {
                builder.append(current);
            }
            ++index;
        }
        return builder == null ? text : builder.toString();
    }

    public static String convertSectionSignsToAmpersands(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder builder = null;
        int index = 0;
        ColorCodeUtils.FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        while (index < text.length()) {
            int codeLen;
            char current = text.charAt(index);
            if (current == SECTION_SIGN && ((codeLen = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, index, env)) == 2 || codeLen == 8)) {
                if (builder == null) {
                    builder = new StringBuilder(text.length());
                    builder.append(text, 0, index);
                }
                builder.append('&');
                builder.append(text, index + 1, Math.min(index + codeLen, text.length()));
                index += codeLen;
                continue;
            }
            if (builder != null) {
                builder.append(current);
            }
            ++index;
        }
        return builder == null ? text : builder.toString();
    }

    public static String extractFormatFromString(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        String currentColorCode = null;
        StringBuilder styleCodes = new StringBuilder();
        ArrayDeque<String> colorStack = new ArrayDeque<String>();
        ColorCodeUtils.FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        int i = 0;
        while (i < str.length()) {
            int codeLen = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(str, i, env);
            if (codeLen > 0) {
                char firstChar = str.charAt(i);
                String code = str.substring(i, i + codeLen);
                if (codeLen == 8 && (firstChar == '&' || firstChar == '\u00a7')) {
                    currentColorCode = code;
                    colorStack.clear();
                    styleCodes.setLength(0);
                } else if (codeLen == 8 && firstChar == '<') {
                    if (currentColorCode != null) {
                        colorStack.push(currentColorCode);
                    }
                    currentColorCode = code;
                    styleCodes.setLength(0);
                } else if (codeLen == 9 && firstChar == '<') {
                    currentColorCode = colorStack.isEmpty() ? null : (String)colorStack.pop();
                    styleCodes.setLength(0);
                } else if (codeLen == 2) {
                    char fmt = Character.toLowerCase(str.charAt(i + 1));
                    if (ColorCodeUtils.isMinecraftColorCode(fmt) || fmt == 'g') {
                        currentColorCode = code;
                        colorStack.clear();
                        styleCodes.setLength(0);
                    } else if (ColorCodeUtils.isResetCode(fmt)) {
                        currentColorCode = null;
                        colorStack.clear();
                        styleCodes.setLength(0);
                    } else if (ColorCodeUtils.isStyleCode(fmt) || ColorCodeUtils.isEffectCode(fmt)) {
                        styleCodes.append(code);
                    }
                }
                i += codeLen;
                continue;
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        if (currentColorCode != null) {
            result.append(currentColorCode);
        }
        if (styleCodes.length() > 0) {
            result.append((CharSequence)styleCodes);
        }
        return result.toString();
    }

    public static String stripColorCodes(CharSequence input) {
        if (input == null) {
            return null;
        }
        return StringUtils.stripTokens(input, (text, start, codeLen) -> true);
    }

    public static String stripExtras(CharSequence input) {
        return StringUtils.stripColorCodes(input);
    }

    public static String stripHexColors(CharSequence input) {
        if (input == null) {
            return null;
        }
        return StringUtils.stripTokens(input, ColorCodeUtils::isHexColorToken);
    }

    public static String stripColors(CharSequence input) {
        if (input == null) {
            return null;
        }
        return StringUtils.stripTokens(input, ColorCodeUtils::isStandardColorToken);
    }

    public static String stripStyles(CharSequence input) {
        if (input == null) {
            return null;
        }
        return StringUtils.stripTokens(input, ColorCodeUtils::isStyleOrEffectToken);
    }

    public static boolean containsFormattingCodes(CharSequence input) {
        return ColorCodeUtils.containsFormattingCodes(input);
    }

    private static String stripTokens(CharSequence input, TokenClassifier classifier) {
        if (input == null) {
            return null;
        }
        StringBuilder builder = null;
        int index = 0;
        ColorCodeUtils.FormattingEnvironment env = ColorCodeUtils.captureFormattingEnvironment(false);
        while (index < input.length()) {
            int codeLen = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(input, index, env);
            if (codeLen > 0) {
                if (classifier.shouldStrip(input, index, codeLen)) {
                    if (builder == null) {
                        builder = new StringBuilder(input.length());
                        builder.append(input, 0, index);
                    }
                    index += codeLen;
                    continue;
                }
                if (builder != null) {
                    builder.append(input, index, index + codeLen);
                }
                index += codeLen;
                continue;
            }
            if (builder != null) {
                builder.append(input.charAt(index));
            }
            ++index;
        }
        return builder == null ? input.toString() : builder.toString();
    }

    @FunctionalInterface
    private static interface TokenClassifier {
        public boolean shouldStrip(CharSequence var1, int var2, int var3);
    }
}

