/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.util;

public final class ColorMath {
    private ColorMath() {
    }

    public static int scaleBrightness(int color, float factor) {
        float clampedFactor = ColorMath.clamp(factor, 0.0f, 8.0f);
        int red = ColorMath.clampChannel((float)(color >> 16 & 0xFF) * clampedFactor);
        int green = ColorMath.clampChannel((float)(color >> 8 & 0xFF) * clampedFactor);
        int blue = ColorMath.clampChannel((float)(color & 0xFF) * clampedFactor);
        return red << 16 | green << 8 | blue;
    }

    public static int blend(int first, int second, float ratio) {
        float clampedRatio = ColorMath.clamp(ratio, 0.0f, 1.0f);
        float inverse = 1.0f - clampedRatio;
        int red = ColorMath.clampChannel((float)(first >> 16 & 0xFF) * inverse + (float)(second >> 16 & 0xFF) * clampedRatio);
        int green = ColorMath.clampChannel((float)(first >> 8 & 0xFF) * inverse + (float)(second >> 8 & 0xFF) * clampedRatio);
        int blue = ColorMath.clampChannel((float)(first & 0xFF) * inverse + (float)(second & 0xFF) * clampedRatio);
        return red << 16 | green << 8 | blue;
    }

    private static int clampChannel(float value) {
        int rounded = Math.round(value);
        if (rounded < 0) {
            return 0;
        }
        if (rounded > 255) {
            return 255;
        }
        return rounded;
    }

    private static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

