/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.sign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kamkeel.hextext.api.sign.SignInteractionRegistry;
import kamkeel.hextext.api.sign.SignInteractionType;
import kamkeel.hextext.config.HexTextConfig;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class HexTextSignInteractions
implements SignInteractionRegistry {
    private final Map<Item, List<InteractionEntry>> registry = new IdentityHashMap<Item, List<InteractionEntry>>();
    private volatile boolean defaultsRegistered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDefaults() {
        if (this.defaultsRegistered) {
            return;
        }
        Map<Item, List<InteractionEntry>> map = this.registry;
        synchronized (map) {
            if (this.defaultsRegistered) {
                return;
            }
            if (HexTextConfig.isGlowstoneDustGlowEnabled()) {
                this.register(Items.field_151114_aO, Short.MAX_VALUE, EnumSet.of(SignInteractionType.GLOW));
            }
            if (HexTextConfig.isRedstoneDustOutlineEnabled()) {
                this.register(Items.field_151137_ax, Short.MAX_VALUE, EnumSet.of(SignInteractionType.OUTLINE));
            }
            if (HexTextConfig.isSlimeballWaxEnabled()) {
                this.register(Items.field_151123_aH, Short.MAX_VALUE, EnumSet.of(SignInteractionType.WAX));
            }
            if (HexTextConfig.isInkSacCleanseEnabled()) {
                this.register(Items.field_151100_aR, 0, EnumSet.of(SignInteractionType.CLEANSE));
            }
            this.defaultsRegistered = true;
        }
    }

    @Override
    public void register(ItemStack stack, SignInteractionType ... interactions) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        this.register(stack.func_77973_b(), stack.func_77960_j(), HexTextSignInteractions.toEnumSet(interactions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Item item, int metadata, Set<SignInteractionType> interactions) {
        if (item == null || interactions == null || interactions.isEmpty()) {
            return;
        }
        EnumSet<SignInteractionType> copy = EnumSet.copyOf(interactions);
        Map<Item, List<InteractionEntry>> map = this.registry;
        synchronized (map) {
            List entries = this.registry.computeIfAbsent(item, ignored -> new ArrayList());
            InteractionEntry entry = HexTextSignInteractions.findEntry(entries, metadata);
            if (entry == null) {
                entry = new InteractionEntry(metadata, copy);
                entries.add(entry);
            } else {
                entry.interactions.addAll(copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Item item, int metadata, SignInteractionType ... interactions) {
        if (item == null || interactions == null || interactions.length == 0) {
            return;
        }
        EnumSet<SignInteractionType> removal = HexTextSignInteractions.toEnumSet(interactions);
        Map<Item, List<InteractionEntry>> map = this.registry;
        synchronized (map) {
            List<InteractionEntry> entries = this.registry.get(item);
            if (entries == null) {
                return;
            }
            InteractionEntry entry = HexTextSignInteractions.findEntry(entries, metadata);
            if (entry == null) {
                return;
            }
            entry.interactions.removeAll(removal);
            if (entry.interactions.isEmpty()) {
                entries.remove(entry);
                if (entries.isEmpty()) {
                    this.registry.remove(item);
                }
            }
        }
    }

    @Override
    public boolean provides(ItemStack stack, SignInteractionType type) {
        if (stack == null || type == null) {
            return false;
        }
        return this.getInteractions(stack).contains((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SignInteractionType> getInteractions(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return Collections.emptySet();
        }
        EnumSet<SignInteractionType> result = EnumSet.noneOf(SignInteractionType.class);
        Item item = stack.func_77973_b();
        int metadata = stack.func_77960_j();
        Map<Item, List<InteractionEntry>> map = this.registry;
        synchronized (map) {
            List<InteractionEntry> entries = this.registry.get(item);
            if (entries == null) {
                return Collections.emptySet();
            }
            for (InteractionEntry entry : entries) {
                if (!entry.matches(metadata)) continue;
                result.addAll(entry.interactions);
            }
        }
        return result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result);
    }

    private static InteractionEntry findEntry(List<InteractionEntry> entries, int metadata) {
        for (InteractionEntry entry : entries) {
            if (entry.metadata != metadata) continue;
            return entry;
        }
        return null;
    }

    private static EnumSet<SignInteractionType> toEnumSet(SignInteractionType ... interactions) {
        EnumSet<SignInteractionType> set = EnumSet.noneOf(SignInteractionType.class);
        if (interactions != null) {
            Collections.addAll(set, interactions);
        }
        return set;
    }

    private static final class InteractionEntry {
        private final int metadata;
        private final EnumSet<SignInteractionType> interactions;

        private InteractionEntry(int metadata, EnumSet<SignInteractionType> interactions) {
            this.metadata = metadata;
            this.interactions = interactions;
        }

        private boolean matches(int stackMeta) {
            return this.metadata == Short.MAX_VALUE || this.metadata == stackMeta;
        }
    }
}

