/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.common.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kamkeel.hextext.HexText;
import kamkeel.hextext.api.rendering.RenderDirective;
import kamkeel.hextext.api.rendering.RenderPlan;
import kamkeel.hextext.common.render.RenderDirectiveImpl;
import kamkeel.hextext.common.render.RenderPlanImpl;
import kamkeel.hextext.common.util.ColorCodeUtils;
import kamkeel.hextext.common.util.StringUtils;

public final class RenderTextProcessor {
    private RenderTextProcessor() {
    }

    public static RenderPlan prepare(String text, boolean rawMode) {
        if (text == null || text.isEmpty()) {
            return RenderPlanImpl.unchanged();
        }
        String processed = rawMode ? StringUtils.normalizeForRawDisplay(text) : text;
        StringBuilder sanitized = new StringBuilder(processed.length() + (rawMode ? 16 : 0));
        Map<Integer, List<RenderDirective>> directives = null;
        boolean modified = rawMode && !processed.equals(text);
        boolean allowHtml = HexText.getActiveProxy() == null || HexText.getActiveProxy().allowHtmlFormatting();
        boolean allowAmpersand = rawMode || HexText.getActiveProxy() == null || HexText.getActiveProxy().allowUniversalAmpersand();
        for (int i = 0; i < processed.length(); ++i) {
            boolean usingAmpersand;
            char current = processed.charAt(i);
            boolean usingSectionSign = current == '\u00a7';
            boolean bl = usingAmpersand = current == '&';
            if ((usingSectionSign || usingAmpersand && allowAmpersand) && i + 1 < processed.length()) {
                FormatCategory category;
                int rgb;
                int hexStart;
                int directiveIndex = sanitized.length();
                if (processed.charAt(i + 1) == '#' && (hexStart = i + 2) + 6 <= processed.length() && ColorCodeUtils.isValidHexString(processed, hexStart) && (rgb = ColorCodeUtils.parseHexColor(processed, hexStart)) != -1) {
                    directives = RenderTextProcessor.ensureDirectiveMap(directives);
                    directives.computeIfAbsent(directiveIndex, key -> new ArrayList()).add(RenderDirectiveImpl.apply(rgb, true));
                    if (rawMode) {
                        sanitized.append(current).append('#');
                        sanitized.append(processed, hexStart, hexStart + 6);
                    } else {
                        modified = true;
                    }
                    i += 7;
                    continue;
                }
                char next = processed.charAt(i + 1);
                char lower = Character.toLowerCase(next);
                if (ColorCodeUtils.isFormattingCode(lower) && (category = RenderTextProcessor.classifyFormatting(lower)) != null) {
                    boolean usingLiteral;
                    directives = RenderTextProcessor.ensureDirectiveMap(directives);
                    List bucket = directives.computeIfAbsent(directiveIndex, key -> new ArrayList());
                    RenderTextProcessor.emitFormattingDirective(bucket, category, lower, directiveIndex);
                    boolean bl2 = usingLiteral = rawMode || usingSectionSign;
                    if (usingLiteral) {
                        sanitized.append(current);
                        if (!category.consumesTrailingCode()) continue;
                        sanitized.append(next);
                        ++i;
                        continue;
                    }
                    if (category.keepWhenUsingAmpersand()) {
                        sanitized.append('\u00a7');
                        modified = true;
                        continue;
                    }
                    modified = true;
                    if (!category.consumesTrailingCode()) continue;
                    ++i;
                    continue;
                }
            }
            if (allowHtml && current == '<') {
                int rgb;
                if (i + 8 <= processed.length() && processed.charAt(i + 7) == '>' && ColorCodeUtils.isValidHexString(processed, i + 1) && (rgb = ColorCodeUtils.parseHexColor(processed, i + 1)) != -1) {
                    directives = RenderTextProcessor.ensureDirectiveMap(directives);
                    directives.computeIfAbsent(sanitized.length(), key -> new ArrayList()).add(RenderDirectiveImpl.push(rgb));
                    if (rawMode) {
                        sanitized.append(processed, i, i + 8);
                    } else {
                        modified = true;
                    }
                    i += 7;
                    continue;
                }
                if (i + 9 <= processed.length() && processed.charAt(i + 1) == '/' && processed.charAt(i + 8) == '>' && ColorCodeUtils.isValidHexString(processed, i + 2)) {
                    directives = RenderTextProcessor.ensureDirectiveMap(directives);
                    directives.computeIfAbsent(sanitized.length(), key -> new ArrayList()).add(RenderDirectiveImpl.pop());
                    if (rawMode) {
                        sanitized.append(processed, i, i + 9);
                    } else {
                        modified = true;
                    }
                    i += 8;
                    continue;
                }
            }
            sanitized.append(current);
        }
        Map<Integer, List<RenderDirective>> normalized = RenderTextProcessor.normalizeDirectives(directives);
        if (!modified && (normalized == null || normalized.isEmpty())) {
            return RenderPlanImpl.unchanged();
        }
        if (!modified && normalized != null) {
            return RenderPlanImpl.withInstructions(normalized);
        }
        return RenderPlanImpl.withDisplayText(sanitized.toString(), normalized);
    }

    private static Map<Integer, List<RenderDirective>> ensureDirectiveMap(Map<Integer, List<RenderDirective>> directives) {
        return directives != null ? directives : new HashMap();
    }

    private static FormatCategory classifyFormatting(char lower) {
        if (ColorCodeUtils.isMinecraftColorCode(lower)) {
            return FormatCategory.COLOR;
        }
        if (ColorCodeUtils.isResetCode(lower)) {
            return FormatCategory.RESET;
        }
        if (ColorCodeUtils.isStyleCode(lower)) {
            return FormatCategory.STYLE;
        }
        if (lower == 'g') {
            return FormatCategory.RAINBOW;
        }
        if (ColorCodeUtils.isEffectCode(lower)) {
            return FormatCategory.EFFECT;
        }
        return null;
    }

    private static void emitFormattingDirective(List<RenderDirective> bucket, FormatCategory category, char lower, int directiveIndex) {
        switch (category) {
            case COLOR: {
                int colorIndex = ColorCodeUtils.getMinecraftColorIndex(lower);
                if (colorIndex < 0) break;
                bucket.add(RenderDirectiveImpl.applyVanillaColor(colorIndex));
                break;
            }
            case RESET: {
                bucket.add(RenderDirectiveImpl.resetToBase());
                break;
            }
            case STYLE: {
                RenderTextProcessor.applyStyleDirective(bucket, lower);
                break;
            }
            case EFFECT: {
                RenderTextProcessor.applyEffectDirective(bucket, lower);
                break;
            }
            case RAINBOW: {
                bucket.add(RenderDirectiveImpl.setRainbow(true, directiveIndex));
                break;
            }
        }
    }

    private static void applyStyleDirective(List<RenderDirective> bucket, char lower) {
        switch (lower) {
            case 'k': {
                bucket.add(RenderDirectiveImpl.setRandom(true));
                break;
            }
            case 'l': {
                bucket.add(RenderDirectiveImpl.setBold(true));
                break;
            }
            case 'm': {
                bucket.add(RenderDirectiveImpl.setStrikethrough(true));
                break;
            }
            case 'n': {
                bucket.add(RenderDirectiveImpl.setUnderline(true));
                break;
            }
            case 'o': {
                bucket.add(RenderDirectiveImpl.setItalic(true));
                break;
            }
        }
    }

    private static void applyEffectDirective(List<RenderDirective> bucket, char lower) {
        switch (lower) {
            case 'h': {
                bucket.add(RenderDirectiveImpl.setDinnerbone(true));
                break;
            }
            case 'i': {
                bucket.add(RenderDirectiveImpl.setIgnite(true));
                break;
            }
            case 'j': {
                bucket.add(RenderDirectiveImpl.setShake(true));
                break;
            }
        }
    }

    private static Map<Integer, List<RenderDirective>> normalizeDirectives(Map<Integer, List<RenderDirective>> directives) {
        if (directives == null || directives.isEmpty()) {
            return null;
        }
        return directives;
    }

    private static enum FormatCategory {
        COLOR(true, false),
        RESET(true, false),
        STYLE(true, false),
        EFFECT(false, true),
        RAINBOW(false, true);

        private final boolean keepWhenAmpersand;
        private final boolean consumesTrailingCode;

        private FormatCategory(boolean keepWhenAmpersand, boolean consumesTrailingCode) {
            this.keepWhenAmpersand = keepWhenAmpersand;
            this.consumesTrailingCode = consumesTrailingCode;
        }

        boolean keepWhenUsingAmpersand() {
            return this.keepWhenAmpersand;
        }

        boolean consumesTrailingCode() {
            return this.consumesTrailingCode;
        }
    }
}

