/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render.font;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kamkeel.hextext.api.rendering.HighlightSpan;
import kamkeel.hextext.api.rendering.RenderDirective;
import kamkeel.hextext.api.rendering.RenderPlan;
import kamkeel.hextext.client.render.ColorStateTracker;
import kamkeel.hextext.client.render.FontRenderContext;
import kamkeel.hextext.client.render.FontRendererUtils;
import kamkeel.hextext.client.render.TextEffectController;
import kamkeel.hextext.client.render.TokenHighlightUtils;
import kamkeel.hextext.client.render.font.FontRendererBridge;
import kamkeel.hextext.client.render.font.GlowingTextRenderer;
import kamkeel.hextext.client.render.font.GlyphRenderer;
import kamkeel.hextext.common.render.HighlightSpanImpl;
import kamkeel.hextext.common.render.RenderDirectiveImpl;
import kamkeel.hextext.common.render.RenderTextProcessor;
import kamkeel.hextext.common.util.ColorCodeUtils;
import kamkeel.hextext.common.util.StringUtils;
import org.lwjgl.opengl.GL11;

public final class FontRendererRenderPipeline {
    private final FontRendererBridge bridge;
    private final ColorStateTracker colorState = new ColorStateTracker();
    private final TextEffectController effects = new TextEffectController();
    private final List<HighlightSpan> pendingHighlights = new ArrayList<HighlightSpan>();
    private static final int DEFAULT_OUTLINE_FALLBACK = 0x2E2E2E;
    private RenderPlan renderData;
    private boolean shadowPass;
    private boolean renderingShadow;
    private int rawTokenSkip;
    private int visibleGlyphIndex;
    private int pendingRenderColor;
    private boolean hasPendingRenderColor;
    private int outlineGlyphIndex = -1;
    private boolean outlineDrawnForCurrentGlyph;
    private ColorCodeUtils.FormattingEnvironment formattingEnvironmentIgnoreRaw;

    public FontRendererRenderPipeline(FontRendererBridge bridge) {
        this.bridge = bridge;
    }

    public void capturePreparedColor(int color) {
        this.pendingRenderColor = color & 0xFFFFFF;
        this.hasPendingRenderColor = true;
    }

    public void begin(String text, boolean shadow) {
        boolean rawMode = FontRenderContext.isRawTextRendering();
        this.renderData = RenderTextProcessor.prepare(text, rawMode);
        this.shadowPass = shadow;
        this.renderingShadow = shadow;
        this.formattingEnvironmentIgnoreRaw = ColorCodeUtils.captureFormattingEnvironment(false);
        int initialColor = this.resolveInitialColor();
        this.colorState.begin(initialColor, shadow);
        this.bridge.hexText$setTextColor(initialColor);
        this.effects.begin(initialColor);
        if (rawMode) {
            this.bridge.hexText$resetFormattingStyles();
        }
        this.pendingHighlights.clear();
        this.rawTokenSkip = 0;
        this.visibleGlyphIndex = 0;
        this.outlineGlyphIndex = -1;
        this.outlineDrawnForCurrentGlyph = false;
    }

    public String adjustRenderText(String text) {
        if (this.renderData != null && this.renderData.shouldReplaceText()) {
            return this.renderData.getDisplayText();
        }
        return text;
    }

    public void applyInstructions(String text, int index, char currentChar) {
        if (!this.renderingShadow && FontRenderContext.isRawTextRendering()) {
            if (this.rawTokenSkip > 0) {
                --this.rawTokenSkip;
            } else {
                int tokenLength;
                ColorCodeUtils.FormattingEnvironment env = this.formattingEnvironmentIgnoreRaw;
                if (env == null) {
                    this.formattingEnvironmentIgnoreRaw = env = ColorCodeUtils.captureFormattingEnvironment(false);
                }
                if ((tokenLength = ColorCodeUtils.detectColorCodeLengthIgnoringRaw(text, index, env)) == 0) {
                    tokenLength = ColorCodeUtils.detectAmpersandFormattingCodeLength(text, index);
                }
                if (tokenLength > 0 && text.charAt(index) != '\u00a7') {
                    float width = TokenHighlightUtils.measureLiteralWidth(this.bridge.hexText$getFontRenderer(), (CharSequence)text, index, tokenLength);
                    if (width > 0.0f) {
                        this.pendingHighlights.add(new HighlightSpanImpl(this.bridge.hexText$getPosX(), this.bridge.hexText$getPosY(), width, TokenHighlightUtils.getTokenHighlightColor(text, index)));
                    }
                    this.rawTokenSkip = Math.max(tokenLength - 1, 0);
                }
            }
        }
        if (this.renderData == null || !this.renderData.hasInstructions()) {
            return;
        }
        Map<Integer, List<RenderDirective>> instructionsByIndex = this.renderData.getInstructions();
        if (instructionsByIndex == null) {
            return;
        }
        List<RenderDirective> instructions = instructionsByIndex.remove(index);
        if (instructions == null) {
            return;
        }
        for (RenderDirective instruction : instructions) {
            if (!(instruction instanceof RenderDirectiveImpl)) continue;
            this.executeInstruction((RenderDirectiveImpl)instruction);
        }
    }

    public void end() {
        this.renderData = null;
        if (!this.renderingShadow && !this.pendingHighlights.isEmpty()) {
            TokenHighlightUtils.drawHighlights(this.pendingHighlights, this.bridge.hexText$getFontHeight());
            this.pendingHighlights.clear();
        }
    }

    public int computeStringWidth(String text) {
        boolean rawMode = FontRenderContext.isRawTextRendering();
        return Math.round(FontRendererUtils.calculateMaxLineWidth(this.bridge.hexText$getFontRenderer(), text, rawMode));
    }

    public int computeLineBreakIndex(String text, int maxWidth) {
        boolean rawMode = FontRenderContext.isRawTextRendering();
        return FontRendererUtils.computeLineBreakIndex(this.bridge.hexText$getFontRenderer(), text, maxWidth, rawMode);
    }

    public String trimStringToWidth(String text, int width, boolean reverse) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        boolean rawMode = FontRenderContext.isRawTextRendering();
        if (!reverse) {
            int endIndex = FontRendererUtils.computeLineBreakIndex(this.bridge.hexText$getFontRenderer(), text, width, rawMode);
            return text.substring(0, Math.min(endIndex, text.length()));
        }
        return FontRendererUtils.trimStringFromEnd(this.bridge.hexText$getFontRenderer(), text, width, rawMode);
    }

    public String wrapFormattedString(String text, int width) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        boolean rawMode = FontRenderContext.isRawTextRendering();
        return FontRendererUtils.wrapFormattedString(this.bridge.hexText$getFontRenderer(), text, width, rawMode);
    }

    public String extractFormatFromString(String text) {
        return StringUtils.extractFormatFromString(text);
    }

    public float renderGlyph(char glyph, boolean italic, boolean unicode, int defaultIndex, char unicodeChar, GlyphRenderer glyphRenderer) {
        this.updateOutlineTracking();
        int baseColor = this.bridge.hexText$getTextColor();
        if (this.effects.hasActiveEffects()) {
            int targetColor = this.effects.computeColor(this.visibleGlyphIndex);
            int appliedColor = this.shadowPass ? ColorCodeUtils.calculateShadowColor(targetColor) : targetColor;
            this.setColorFromInt(appliedColor);
            this.effects.beforeGlyph(this.bridge.hexText$getFontRenderer(), glyph, this.visibleGlyphIndex, this.bridge.hexText$getPosX(), this.bridge.hexText$getPosY(), this.bridge.hexText$getFontHeight());
            float width = this.renderGlyphWithColor(appliedColor, italic, unicode, defaultIndex, unicodeChar, glyphRenderer);
            this.effects.afterGlyph();
            return width;
        }
        return this.renderGlyphWithColor(baseColor, italic, unicode, defaultIndex, unicodeChar, glyphRenderer);
    }

    public void advanceGlyphIndex() {
        ++this.visibleGlyphIndex;
    }

    private float renderGlyphWithColor(int color, boolean italic, boolean unicode, int defaultIndex, char unicodeChar, GlyphRenderer glyphRenderer) {
        if (!this.renderingShadow && GlowingTextRenderer.isOutlineEnabled()) {
            if (!this.outlineDrawnForCurrentGlyph) {
                this.drawGlyphOutline(color, italic, unicode, defaultIndex, unicodeChar, glyphRenderer);
                this.outlineDrawnForCurrentGlyph = true;
            }
            this.applyTemporaryColor(color);
            return this.renderGlyphInternal(unicode, defaultIndex, unicodeChar, italic, glyphRenderer);
        }
        return this.renderGlyphInternal(unicode, defaultIndex, unicodeChar, italic, glyphRenderer);
    }

    private void drawGlyphOutline(int baseColor, boolean italic, boolean unicode, int defaultIndex, char unicodeChar, GlyphRenderer glyphRenderer) {
        int outlineColor = this.resolveOutlineColor(baseColor);
        this.applyTemporaryColor(outlineColor);
        for (float[] offset : GlowingTextRenderer.getOutlineOffsets()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)offset[0], (float)offset[1], (float)0.0f);
            this.renderGlyphInternal(unicode, defaultIndex, unicodeChar, italic, glyphRenderer);
            GL11.glPopMatrix();
        }
    }

    private float renderGlyphInternal(boolean unicode, int defaultIndex, char unicodeChar, boolean italic, GlyphRenderer glyphRenderer) {
        return unicode ? glyphRenderer.renderUnicode(unicodeChar, italic) : glyphRenderer.renderDefault(defaultIndex, italic);
    }

    private void applyTemporaryColor(int rgb) {
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        this.bridge.hexText$applyColorComponents(red, green, blue, this.bridge.hexText$getAlpha());
    }

    private int resolveOutlineColor(int baseColor) {
        int outlineColor = GlowingTextRenderer.computeOutlineColor(baseColor);
        if ((outlineColor & 0xFFFFFF) == 0) {
            return 0x2E2E2E;
        }
        return outlineColor;
    }

    private void executeInstruction(RenderDirectiveImpl instruction) {
        boolean resetStyles = instruction.resetsFormatting();
        RenderDirectiveImpl.Type type = instruction.getType();
        switch (type) {
            case APPLY_RGB: {
                int appliedRgb = this.colorState.applyRgb(instruction.getRgb(), instruction.shouldClearStack(), this.effects, this.renderingShadow);
                this.setColorFromInt(appliedRgb);
                break;
            }
            case APPLY_VANILLA_COLOR: {
                int vanillaColor = this.colorState.applyVanillaColor(instruction.getParameter(), this.bridge.hexText$getColorCodePalette(), instruction.shouldClearStack(), this.effects, this.renderingShadow);
                this.setColorFromInt(vanillaColor);
                break;
            }
            case PUSH_RGB: {
                int pushedColor = this.colorState.push(instruction.getRgb(), this.effects, this.renderingShadow);
                this.setColorFromInt(pushedColor);
                break;
            }
            case POP_COLOR: {
                int restoredColor = this.colorState.pop(this.effects, this.renderingShadow);
                this.setColorFromInt(restoredColor);
                break;
            }
            case RESET_TO_BASE: {
                int baseColor = this.colorState.resetToBase(this.effects, this.renderingShadow);
                this.setColorFromInt(baseColor);
                break;
            }
            case SET_RANDOM: {
                this.bridge.hexText$setRandomStyle(instruction.isEnabled());
                break;
            }
            case SET_BOLD: {
                this.bridge.hexText$setBoldStyle(instruction.isEnabled());
                break;
            }
            case SET_STRIKETHROUGH: {
                this.bridge.hexText$setStrikethroughStyle(instruction.isEnabled());
                break;
            }
            case SET_UNDERLINE: {
                this.bridge.hexText$setUnderlineStyle(instruction.isEnabled());
                break;
            }
            case SET_ITALIC: {
                this.bridge.hexText$setItalicStyle(instruction.isEnabled());
                break;
            }
            case SET_RAINBOW: {
                if (instruction.shouldClearStack()) {
                    this.colorState.clearStacks();
                }
                this.effects.resetDynamicEffects();
                this.effects.setRainbow(instruction.isEnabled(), this.visibleGlyphIndex);
                if (!this.renderingShadow) {
                    this.effects.updateBaseColor(this.bridge.hexText$getTextColor());
                }
                resetStyles = true;
                break;
            }
            case SET_DINNERBONE: {
                this.effects.setDinnerbone(instruction.isEnabled());
                break;
            }
            case SET_IGNITE: {
                if (instruction.isEnabled() && !this.renderingShadow) {
                    this.effects.updateBaseColor(this.bridge.hexText$getTextColor());
                }
                this.effects.setIgnite(instruction.isEnabled());
                break;
            }
            case SET_SHAKE: {
                this.effects.setShake(instruction.isEnabled());
            }
        }
        if (resetStyles) {
            this.bridge.hexText$resetFormattingStyles();
        }
    }

    private void setColorFromInt(int rgb) {
        int masked = rgb & 0xFFFFFF;
        this.bridge.hexText$setTextColor(masked);
        this.colorState.setCurrentColor(masked);
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        this.bridge.hexText$applyColorComponents(red, green, blue, this.bridge.hexText$getAlpha());
    }

    private void updateOutlineTracking() {
        if (this.visibleGlyphIndex != this.outlineGlyphIndex) {
            this.outlineGlyphIndex = this.visibleGlyphIndex;
            this.outlineDrawnForCurrentGlyph = false;
        }
    }

    private int resolveInitialColor() {
        if (this.hasPendingRenderColor) {
            this.hasPendingRenderColor = false;
            return this.pendingRenderColor & 0xFFFFFF;
        }
        int r = Math.round(this.bridge.hexText$getRedComponent() * 255.0f);
        int g = Math.round(this.bridge.hexText$getGreenComponent() * 255.0f);
        int b = Math.round(this.bridge.hexText$getBlueComponent() * 255.0f);
        return r << 16 | g << 8 | b;
    }
}

