/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import kamkeel.hextext.common.util.ColorMath;
import kamkeel.hextext.common.util.TextEffectMath;
import kamkeel.hextext.config.HexTextConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public final class TextEffectController {
    private static final float RAINBOW_SPREAD = 12.0f;
    private static final float SHAKE_VERTICAL_RANGE = 1.05f;
    private static final long SHAKE_Y_SALT = -4132994306676758123L;
    private static final float IGNITE_MIN_FACTOR = 0.35f;
    private boolean rainbowActive;
    private boolean dinnerboneActive;
    private boolean igniteActive;
    private boolean shakeActive;
    private int rainbowAnchorIndex;
    private int baseColor;
    private boolean transformApplied;
    private boolean cullFaceTemporarilyDisabled;

    public void begin(int initialColor) {
        this.baseColor = initialColor;
        this.resetDynamicEffects();
        this.transformApplied = false;
        this.cullFaceTemporarilyDisabled = false;
    }

    public void updateBaseColor(int color) {
        this.baseColor = color;
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public void resetDynamicEffects() {
        this.rainbowActive = false;
        this.dinnerboneActive = false;
        this.igniteActive = false;
        this.shakeActive = false;
        this.rainbowAnchorIndex = 0;
    }

    public void setRainbow(boolean enabled, int anchorIndex) {
        this.rainbowActive = enabled;
        if (enabled) {
            this.rainbowAnchorIndex = Math.max(0, anchorIndex);
        }
    }

    public void setDinnerbone(boolean enabled) {
        this.dinnerboneActive = enabled;
    }

    public void setIgnite(boolean enabled) {
        this.igniteActive = enabled;
    }

    public void setShake(boolean enabled) {
        this.shakeActive = enabled;
    }

    public boolean hasActiveEffects() {
        return this.rainbowActive || this.dinnerboneActive || this.igniteActive || this.shakeActive;
    }

    public int computeColor(int charIndex) {
        int color = this.baseColor;
        long now = this.currentTime();
        if (this.rainbowActive) {
            color = TextEffectMath.computeRainbowColor(now, HexTextConfig.getRainbowSpeed(), charIndex, this.rainbowAnchorIndex, 12.0f);
        }
        if (this.igniteActive) {
            float brightness = TextEffectMath.computeIgniteBrightness(now, HexTextConfig.getIgniteInterval(), 0.35f);
            color = ColorMath.scaleBrightness(color, brightness);
        }
        return color;
    }

    public void beforeGlyph(FontRenderer fontRenderer, char glyph, int charIndex, float posX, float posY, int fontHeight) {
        if (!this.dinnerboneActive && !this.shakeActive) {
            this.transformApplied = false;
            return;
        }
        GL11.glPushMatrix();
        this.transformApplied = true;
        this.cullFaceTemporarilyDisabled = false;
        if (this.shakeActive) {
            this.applyShake(charIndex);
        }
        if (this.dinnerboneActive) {
            if (GL11.glIsEnabled((int)2884)) {
                GL11.glDisable((int)2884);
                this.cullFaceTemporarilyDisabled = true;
            }
            float width = Math.max(1.0f, (float)fontRenderer.func_78263_a(glyph));
            float glyphHeight = Math.max(1.0f, (float)fontHeight - 1.0f);
            float pivotX = posX + width * 0.5f;
            float pivotY = posY + glyphHeight * 0.5f;
            float baselineOffset = Math.max(0.0f, (float)fontHeight - glyphHeight);
            GL11.glTranslatef((float)pivotX, (float)pivotY, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glTranslatef((float)(-pivotX), (float)(-pivotY + baselineOffset), (float)0.0f);
        }
    }

    public void afterGlyph() {
        if (this.transformApplied) {
            if (this.cullFaceTemporarilyDisabled) {
                GL11.glEnable((int)2884);
                this.cullFaceTemporarilyDisabled = false;
            }
            GL11.glPopMatrix();
            this.transformApplied = false;
        }
    }

    private void applyShake(int charIndex) {
        long now = this.currentTime();
        long frameWindow = Math.max(1L, (long)HexTextConfig.getShakeInterval());
        long seed = TextEffectMath.computeShakeSeed(charIndex, now, frameWindow);
        float offsetY = TextEffectMath.computeShakeOffset(seed ^ 0xC6A4A7935BD1E995L, 1.05f);
        GL11.glTranslatef((float)0.0f, (float)offsetY, (float)0.0f);
    }

    private long currentTime() {
        return Minecraft.func_71386_F();
    }
}

