/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.client.render;

import kamkeel.hextext.common.util.ColorCodeUtils;

public final class FormattedTextMetrics {
    private FormattedTextMetrics() {
    }

    public static float calculateMaxLineWidth(CharSequence text, boolean rawMode, CharWidthFunction charWidthFunc, float glyphSpacing, float boldExtra) {
        if (text == null || text.length() == 0) {
            return 0.0f;
        }
        float maxWidth = 0.0f;
        float currentLineWidth = 0.0f;
        boolean isBold = false;
        int length = text.length();
        ColorCodeUtils.FormattingEnvironment env = rawMode ? null : ColorCodeUtils.captureFormattingEnvironment(false);
        int index = 0;
        while (index < length) {
            char character;
            char fmt;
            char marker;
            if (!rawMode) {
                int codeLen = ColorCodeUtils.detectColorCodeLength(text, index, false, env);
                if (codeLen > 0) {
                    if (codeLen == 2 && index + 1 < length) {
                        char fmt2 = Character.toLowerCase(text.charAt(index + 1));
                        if (fmt2 == 'l') {
                            isBold = true;
                        } else if (fmt2 == 'r') {
                            isBold = false;
                        } else if (fmt2 >= '0' && fmt2 <= '9' || fmt2 >= 'a' && fmt2 <= 'f') {
                            isBold = false;
                        }
                    }
                    index += codeLen;
                    continue;
                }
            } else if (index + 1 < length && ((marker = text.charAt(index)) == '\u00a7' || marker == '&') && ColorCodeUtils.isFormattingCode(fmt = Character.toLowerCase(text.charAt(index + 1)))) {
                if (fmt == 'l') {
                    isBold = true;
                } else if (fmt == 'r' || ColorCodeUtils.isMinecraftColorCode(fmt)) {
                    isBold = false;
                }
            }
            if ((character = text.charAt(index)) == '\n') {
                maxWidth = Math.max(maxWidth, currentLineWidth);
                currentLineWidth = 0.0f;
                ++index;
                continue;
            }
            float charWidth = charWidthFunc.getWidth(character);
            if (charWidth > 0.0f) {
                currentLineWidth += charWidth;
                if (isBold) {
                    currentLineWidth += boldExtra;
                }
                maxWidth = Math.max(maxWidth, currentLineWidth += glyphSpacing);
            }
            ++index;
        }
        return Math.max(maxWidth, currentLineWidth);
    }

    public static int computeLineBreakIndex(CharSequence text, int maxWidth, boolean rawMode, CharWidthFunction charWidthFunc, float glyphSpacing, float boldExtra) {
        if (text == null || text.length() == 0 || maxWidth <= 0) {
            return 0;
        }
        int lastSafePosition = 0;
        int lastSpacePosition = -1;
        float currentWidth = 0.0f;
        boolean isBold = false;
        int length = text.length();
        ColorCodeUtils.FormattingEnvironment env = rawMode ? null : ColorCodeUtils.captureFormattingEnvironment(false);
        int index = 0;
        while (index < length) {
            float charWidth;
            char character;
            char marker;
            char fmt;
            if (!rawMode) {
                int codeLen = ColorCodeUtils.detectColorCodeLength(text, index, false, env);
                if (codeLen > 0) {
                    if (codeLen == 2 && index + 1 < length) {
                        fmt = Character.toLowerCase(text.charAt(index + 1));
                        if (fmt == 'l') {
                            isBold = true;
                        } else if (fmt == 'r') {
                            isBold = false;
                        } else if (fmt >= '0' && fmt <= '9' || fmt >= 'a' && fmt <= 'f') {
                            isBold = false;
                        }
                    }
                    lastSafePosition = index += codeLen;
                    continue;
                }
            } else if (index + 1 < length && ((marker = text.charAt(index)) == '\u00a7' || marker == '&') && ColorCodeUtils.isFormattingCode(fmt = Character.toLowerCase(text.charAt(index + 1)))) {
                if (fmt == 'l') {
                    isBold = true;
                } else if (fmt == 'r' || ColorCodeUtils.isMinecraftColorCode(fmt)) {
                    isBold = false;
                }
            }
            if ((character = text.charAt(index)) == '\n') {
                return index;
            }
            if (character == ' ') {
                lastSpacePosition = index;
            }
            if ((charWidth = charWidthFunc.getWidth(character)) < 0.0f) {
                charWidth = 0.0f;
            }
            float nextWidth = currentWidth;
            if (charWidth > 0.0f) {
                nextWidth += charWidth;
                if (isBold) {
                    nextWidth += boldExtra;
                }
                nextWidth += glyphSpacing;
            }
            if (nextWidth > (float)maxWidth) {
                if (lastSpacePosition >= 0) {
                    return lastSpacePosition;
                }
                return Math.min(lastSafePosition, length);
            }
            currentWidth = nextWidth;
            lastSafePosition = ++index;
        }
        return length;
    }

    @FunctionalInterface
    public static interface CharWidthFunction {
        public float getWidth(char var1);
    }
}

