/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.hextext.api.sign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kamkeel.hextext.api.sign.SignInteractionRegistry;
import kamkeel.hextext.api.sign.SignInteractionType;
import kamkeel.hextext.config.HexTextConfig;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class HexTextSignInteractions {
    private static final SignInteractionRegistry REGISTRY_ADAPTER = new SignInteractionRegistry(){

        @Override
        public void registerDefaults() {
            HexTextSignInteractions.registerDefaults();
        }

        @Override
        public void register(ItemStack stack, SignInteractionType ... interactions) {
            HexTextSignInteractions.register(stack, interactions);
        }

        @Override
        public void register(Item item, int metadata, Set<SignInteractionType> interactions) {
            HexTextSignInteractions.register(item, metadata, interactions);
        }

        @Override
        public void unregister(Item item, int metadata, SignInteractionType ... interactions) {
            HexTextSignInteractions.unregister(item, metadata, interactions);
        }

        @Override
        public boolean provides(ItemStack stack, SignInteractionType type) {
            return HexTextSignInteractions.provides(stack, type);
        }

        @Override
        public Set<SignInteractionType> getInteractions(ItemStack stack) {
            return HexTextSignInteractions.getInteractions(stack);
        }
    };
    public static final int ANY_META = Short.MAX_VALUE;
    private static final Map<Item, List<InteractionEntry>> REGISTRY = new IdentityHashMap<Item, List<InteractionEntry>>();
    private static volatile boolean defaultsRegistered = false;

    public static SignInteractionRegistry registry() {
        return REGISTRY_ADAPTER;
    }

    private HexTextSignInteractions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDefaults() {
        if (defaultsRegistered) {
            return;
        }
        Map<Item, List<InteractionEntry>> map = REGISTRY;
        synchronized (map) {
            if (defaultsRegistered) {
                return;
            }
            if (HexTextConfig.isGlowstoneDustGlowEnabled()) {
                HexTextSignInteractions.register(Items.field_151114_aO, Short.MAX_VALUE, EnumSet.of(SignInteractionType.GLOW));
            }
            if (HexTextConfig.isRedstoneDustOutlineEnabled()) {
                HexTextSignInteractions.register(Items.field_151137_ax, Short.MAX_VALUE, EnumSet.of(SignInteractionType.OUTLINE));
            }
            if (HexTextConfig.isSlimeballWaxEnabled()) {
                HexTextSignInteractions.register(Items.field_151123_aH, Short.MAX_VALUE, EnumSet.of(SignInteractionType.WAX));
            }
            if (HexTextConfig.isInkSacCleanseEnabled()) {
                HexTextSignInteractions.register(Items.field_151100_aR, 0, EnumSet.of(SignInteractionType.CLEANSE));
            }
            defaultsRegistered = true;
        }
    }

    public static void register(ItemStack stack, SignInteractionType ... interactions) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        HexTextSignInteractions.register(stack.func_77973_b(), stack.func_77960_j(), HexTextSignInteractions.toEnumSet(interactions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Item item, int metadata, Set<SignInteractionType> interactions) {
        if (item == null || interactions == null || interactions.isEmpty()) {
            return;
        }
        EnumSet<SignInteractionType> copy = EnumSet.copyOf(interactions);
        Map<Item, List<InteractionEntry>> map = REGISTRY;
        synchronized (map) {
            List entries = REGISTRY.computeIfAbsent(item, ignored -> new ArrayList());
            InteractionEntry entry = HexTextSignInteractions.findEntry(entries, metadata);
            if (entry == null) {
                entry = new InteractionEntry(metadata, copy);
                entries.add(entry);
            } else {
                entry.interactions.addAll(copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Item item, int metadata, SignInteractionType ... interactions) {
        if (item == null || interactions == null || interactions.length == 0) {
            return;
        }
        EnumSet<SignInteractionType> removal = HexTextSignInteractions.toEnumSet(interactions);
        Map<Item, List<InteractionEntry>> map = REGISTRY;
        synchronized (map) {
            List<InteractionEntry> entries = REGISTRY.get(item);
            if (entries == null) {
                return;
            }
            InteractionEntry entry = HexTextSignInteractions.findEntry(entries, metadata);
            if (entry == null) {
                return;
            }
            entry.interactions.removeAll(removal);
            if (entry.interactions.isEmpty()) {
                entries.remove(entry);
                if (entries.isEmpty()) {
                    REGISTRY.remove(item);
                }
            }
        }
    }

    public static boolean provides(ItemStack stack, SignInteractionType type) {
        if (stack == null || type == null) {
            return false;
        }
        return HexTextSignInteractions.getInteractions(stack).contains((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SignInteractionType> getInteractions(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return Collections.emptySet();
        }
        EnumSet<SignInteractionType> result = EnumSet.noneOf(SignInteractionType.class);
        Item item = stack.func_77973_b();
        int metadata = stack.func_77960_j();
        Map<Item, List<InteractionEntry>> map = REGISTRY;
        synchronized (map) {
            List<InteractionEntry> entries = REGISTRY.get(item);
            if (entries == null) {
                return Collections.emptySet();
            }
            for (InteractionEntry entry : entries) {
                if (!entry.matches(metadata)) continue;
                result.addAll(entry.interactions);
            }
        }
        return result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result);
    }

    private static InteractionEntry findEntry(List<InteractionEntry> entries, int metadata) {
        for (InteractionEntry entry : entries) {
            if (entry.metadata != metadata) continue;
            return entry;
        }
        return null;
    }

    private static EnumSet<SignInteractionType> toEnumSet(SignInteractionType ... interactions) {
        EnumSet<SignInteractionType> set = EnumSet.noneOf(SignInteractionType.class);
        if (interactions != null) {
            Collections.addAll(set, interactions);
        }
        return set;
    }

    private static final class InteractionEntry {
        private final int metadata;
        private final EnumSet<SignInteractionType> interactions;

        private InteractionEntry(int metadata, EnumSet<SignInteractionType> interactions) {
            this.metadata = metadata;
            this.interactions = interactions;
        }

        private boolean matches(int stackMeta) {
            return this.metadata == Short.MAX_VALUE || this.metadata == stackMeta;
        }
    }
}

