/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrowHP;

import com.DarknessCrowHP.crowConfig;
import com.DarknessCrowHP.mainRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class HealthBarRenderer {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!mainRegistry.isHealthBarVisible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (crowConfig.renderInF1 || Minecraft.func_71382_s()) {
            EntityLivingBase cameraEntity = mc.field_71451_h;
            Vec3 renderingVector = cameraEntity.func_70666_h(event.partialTicks);
            Frustrum frustrum = new Frustrum();
            double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)event.partialTicks;
            double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)event.partialTicks;
            double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)event.partialTicks;
            frustrum.func_78547_a(viewX, viewY, viewZ);
            WorldClient client = mc.field_71441_e;
            Set entities = (Set)ReflectionHelper.getPrivateValue(WorldClient.class, (Object)client, (String[])new String[]{"entityList", "field_73032_d", "J"});
            Iterator var14 = entities.iterator();
            while (true) {
                if (!var14.hasNext()) {
                    return;
                }
                Entity entity = (Entity)var14.next();
                if (entity == null || !(entity instanceof EntityLiving) || !entity.func_145770_h(renderingVector.field_72450_a, renderingVector.field_72448_b, renderingVector.field_72449_c) || !entity.field_70158_ak && !frustrum.func_78546_a(entity.field_70121_D) || !entity.func_70089_S()) continue;
                this.renderHealthBar((EntityLivingBase)((EntityLiving)entity), event.partialTicks, (Entity)cameraEntity);
            }
        }
    }

    public void renderHealthBar(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint) {
        if (passedEntity.field_70153_n == null) {
            EntityLivingBase entity = passedEntity;
            while (entity.field_70154_o != null && entity.field_70154_o instanceof EntityLivingBase) {
                entity = (EntityLivingBase)entity.field_70154_o;
            }
            Minecraft mc = Minecraft.func_71410_x();
            float pastTranslate = 0.0f;
            while (entity != null) {
                Entity riddenBy;
                float distance = passedEntity.func_70032_d(viewPoint);
                if (!(distance > (float)crowConfig.maxDistance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || !crowConfig.showOnBosses && entity instanceof IBossDisplayData || !crowConfig.showOnPlayers && entity instanceof EntityPlayer)) {
                    double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
                    double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
                    double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
                    float scale = 0.026666673f;
                    float maxHealth = entity.func_110138_aP();
                    float health = Math.min(maxHealth, entity.func_110143_aJ());
                    if (!(maxHealth <= 2.0f)) {
                        float namel;
                        float s;
                        boolean useHue;
                        float percent = health / maxHealth * 100.0f;
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)((float)(x - RenderManager.field_78725_b)), (float)((float)(y - RenderManager.field_78726_c + (double)passedEntity.field_70131_O + crowConfig.heightAbove + (double)0.4f)), (float)((float)(z - RenderManager.field_78723_d)));
                        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
                        GL11.glDisable((int)2896);
                        GL11.glDepthMask((boolean)false);
                        GL11.glDisable((int)2929);
                        GL11.glDisable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        Tessellator tessellator = Tessellator.field_78398_a;
                        float padding = crowConfig.backgroundPadding;
                        int bgHeight = crowConfig.backgroundHeight;
                        int barHeight = crowConfig.barHeight;
                        float size = crowConfig.plateSize;
                        int r = 0;
                        int g = 255;
                        int b = 0;
                        Object stack = null;
                        int armor = entity.func_70658_aO();
                        boolean bl = useHue = !crowConfig.colorByType;
                        if (useHue) {
                            s = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                            Color color = Color.getHSBColor(s, 1.0f, 1.0f);
                            r = color.getRed();
                            g = color.getGreen();
                            b = color.getBlue();
                        }
                        GL11.glTranslatef((float)0.0f, (float)pastTranslate, (float)0.0f);
                        s = 0.5f;
                        String name = StatCollector.func_74838_a((String)("entity." + EntityList.func_75621_b((Entity)entity) + ".name"));
                        if (entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM()) {
                            name = EnumChatFormatting.ITALIC + ((EntityLiving)entity).func_94057_bL();
                        }
                        NBTTagCompound nbt = new NBTTagCompound();
                        passedEntity.func_70109_d(nbt);
                        if (nbt.func_150297_b("Name", 8)) {
                            name = nbt.func_74779_i("Name");
                        }
                        if ((namel = (float)mc.field_71466_p.func_78256_a(name) * s) + 20.0f > size * 2.0f) {
                            size = namel / 2.0f + 10.0f;
                        }
                        float healthSize = size * (health / maxHealth);
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)0.2f, (float)0.2f, (float)1.0f);
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        float percentWidth = health / maxHealth;
                        int fullBarWidth = 322;
                        int fullBarHeight = 152;
                        mc.field_71446_o.func_110577_a(new ResourceLocation("crowhpbar", "textures/gui/hp_bar.png"));
                        Tessellator tess = Tessellator.field_78398_a;
                        tess.func_78382_b();
                        tess.func_78374_a((double)(-fullBarWidth / 2), 0.0, 0.0, 0.0, 0.0);
                        tess.func_78374_a((double)(-fullBarWidth / 2), (double)fullBarHeight, 0.0, 0.0, 1.0);
                        tess.func_78374_a((double)(fullBarWidth / 2), (double)fullBarHeight, 0.0, 1.0, 1.0);
                        tess.func_78374_a((double)(fullBarWidth / 2), 0.0, 0.0, 1.0, 0.0);
                        tess.func_78381_a();
                        mc.field_71446_o.func_110577_a(new ResourceLocation("crowhpbar", "textures/gui/hp_fill.png"));
                        float fillStartU = 0.2826087f;
                        float fillEndU = 0.89751554f;
                        float uvWidth = fillEndU - fillStartU;
                        int barPixelWidth = 198;
                        int displayedWidth = (int)((float)barPixelWidth * (health / maxHealth));
                        float currentEndU = fillStartU + uvWidth * (health / maxHealth);
                        int offsetX = -fullBarWidth / 2 + 91;
                        tess.func_78382_b();
                        tess.func_78374_a((double)offsetX, 0.0, 0.0, (double)fillStartU, 0.0);
                        tess.func_78374_a((double)offsetX, (double)fullBarHeight, 0.0, (double)fillStartU, 1.0);
                        tess.func_78374_a((double)(offsetX + displayedWidth), (double)fullBarHeight, 0.0, (double)currentEndU, 1.0);
                        tess.func_78374_a((double)(offsetX + displayedWidth), 0.0, 0.0, (double)currentEndU, 0.0);
                        tess.func_78381_a();
                        GL11.glPopMatrix();
                        GL11.glEnable((int)3553);
                        float s1 = 0.5f;
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3553);
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)5.5f, (float)-4.5f, (float)0.0f);
                        if (name != null && !name.isEmpty()) {
                            GL11.glPushMatrix();
                            float nameScale = 0.5f;
                            GL11.glScalef((float)nameScale, (float)nameScale, (float)nameScale);
                            int nameWidth = mc.field_71466_p.func_78256_a(name);
                            int nameX = -nameWidth / 2;
                            int nameY = 30;
                            mc.field_71466_p.func_78276_b(name, nameX, nameY, 0xFFFFFF);
                            GL11.glPopMatrix();
                        }
                        if (crowConfig.showPercentage) {
                            GL11.glPushMatrix();
                            float percScale = 0.45f;
                            GL11.glScalef((float)percScale, (float)percScale, (float)percScale);
                            String percStr = String.format("%.1f%%", Float.valueOf(percent));
                            int percWidth = mc.field_71466_p.func_78256_a(percStr);
                            int percX = -percWidth / 2;
                            int percY = 50;
                            mc.field_71466_p.func_78276_b(percStr, percX, percY, 0xFFFFFF);
                            GL11.glPopMatrix();
                        }
                        GL11.glPushMatrix();
                        float hpScale = 0.4f;
                        GL11.glScalef((float)hpScale, (float)hpScale, (float)hpScale);
                        String hpStr = this.formatHealth(health);
                        String maxHpStr = this.formatHealth(maxHealth);
                        String hpDisplay = "HP: " + hpStr + " / " + maxHpStr;
                        int hpDisplayWidth = mc.field_71466_p.func_78256_a(hpDisplay);
                        int hpX = -hpDisplayWidth / 2;
                        int hpY = 25;
                        mc.field_71466_p.func_78276_b(hpDisplay, hpX, hpY, 0xFFFFFF);
                        GL11.glPopMatrix();
                        GL11.glPopMatrix();
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        int off = 0;
                        s1 = 0.5f;
                        GL11.glScalef((float)s1, (float)s1, (float)s1);
                        GL11.glTranslatef((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
                        mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
                        if (stack != null && crowConfig.showAttributes) {
                            RenderItem.getInstance().func_94149_a(off, 0, stack.func_77954_c(), 16, 16);
                            off -= 16;
                        }
                        GL11.glEnable((int)2929);
                        GL11.glDepthMask((boolean)true);
                        GL11.glEnable((int)2896);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                        pastTranslate = -((float)(bgHeight + barHeight) + padding);
                    }
                }
                if (!((riddenBy = entity.field_70153_n) instanceof EntityLivingBase)) {
                    return;
                }
                entity = (EntityLivingBase)riddenBy;
            }
        }
    }

    public String formatHealth2(float health) {
        if (health >= 1.0E12f) {
            return String.format("%.1fT", Float.valueOf(health / 1.0E12f));
        }
        if (health >= 1.0E9f) {
            return String.format("%.1fB", Float.valueOf(health / 1.0E9f));
        }
        if (health >= 1000000.0f) {
            return String.format("%.1fM", Float.valueOf(health / 1000000.0f));
        }
        if (health >= 1000.0f) {
            return String.format("%.1fK", Float.valueOf(health / 1000.0f));
        }
        return String.format("%.0f", Float.valueOf(health));
    }

    public String formatHealth(double num) {
        double n;
        if (num == 0.0) {
            return "0";
        }
        String[] sufixos = new String[]{"", "K", "M", "B", "T"};
        int i = 0;
        for (n = num; n >= 1000.0 && i < sufixos.length - 1; n /= 1000.0, ++i) {
        }
        return String.format("%.1f", n) + sufixos[i];
    }
}

