/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.config.ConfigScript;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.INpcScriptHandler;

public class LinkedItemScript
implements INpcScriptHandler {
    public ScriptContainer container;
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        if (this.container != null) {
            compound.func_74782_a("ScriptContent", (NBTBase)this.container.writeToNBT(new NBTTagCompound()));
        }
        return compound;
    }

    public LinkedItemScript readFromNBT(NBTTagCompound compound) {
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
        if (compound.func_150297_b("ScriptContent", 10)) {
            this.container = new ScriptContainer(this);
            this.container.readFromNBT(compound.func_74775_l("ScriptContent"));
        }
        return this;
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && this.container != null && ConfigScript.ScriptingEnabled;
    }

    @Override
    public void callScript(EnumScriptType type, Event event) {
        this.callScript(type.function, event);
    }

    @Override
    public void callScript(String s, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        this.container.run(s, (Object)event);
    }

    @Override
    public boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String s) {
        this.scriptLanguage = s;
    }

    @Override
    public void setScripts(List<ScriptContainer> list) {
        if (list == null || list.isEmpty()) {
            this.container = null;
            return;
        }
        this.container = list.get(0);
    }

    @Override
    public List<ScriptContainer> getScripts() {
        if (this.container == null) {
            return new ArrayList<ScriptContainer>();
        }
        return Collections.singletonList(this.container);
    }

    @Override
    public String noticeString() {
        return "LinkedItem";
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> longStringEntry : script.console.entrySet()) {
                map.put(longStringEntry.getKey(), " tab " + tab + ":\n" + longStringEntry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    public void saveScript(ByteBuf buffer) throws IOException {
        int tab = buffer.readInt();
        int totalScripts = buffer.readInt();
        if (totalScripts == 0) {
            this.container = null;
        }
        if (tab == 0) {
            NBTTagCompound tabCompound = ByteBufUtils.readNBT(buffer);
            ScriptContainer script = new ScriptContainer(this);
            script.readFromNBT(tabCompound);
            this.container = script;
        } else {
            NBTTagCompound compound = ByteBufUtils.readNBT(buffer);
            this.setLanguage(compound.func_74779_i("ScriptLanguage"));
            if (!ScriptController.Instance.languages.containsKey(this.getLanguage())) {
                if (!ScriptController.Instance.languages.isEmpty()) {
                    this.setLanguage((String)ScriptController.Instance.languages.keySet().toArray()[0]);
                } else {
                    this.setLanguage("ECMAScript");
                }
            }
            this.setEnabled(compound.func_74767_n("ScriptEnabled"));
        }
    }
}

