/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import kamkeel.npcs.network.PacketClient;
import kamkeel.npcs.network.packets.player.CheckPlayerValue;
import kamkeel.npcs.network.packets.player.InputDevicePacket;
import kamkeel.npcs.network.packets.player.ScreenSizePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.ScriptSoundController;
import noppes.npcs.client.gui.hud.ClientHudManager;
import noppes.npcs.client.gui.hud.CompassHudComponent;
import noppes.npcs.client.gui.hud.EnumHudComponent;
import noppes.npcs.client.gui.hud.HudComponent;
import noppes.npcs.client.gui.player.inventory.GuiCNPCInventory;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.EntityNPCInterface;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import tconstruct.client.tabs.InventoryTabCustomNpc;

public class ClientTickHandler {
    private World prevWorld;
    private int prevWidth = 0;
    private int prevHeight = 0;
    private boolean otherContainer = false;
    private int buttonPressed = -1;
    private long buttonTime = 0L;
    private final int[] ignoreKeys = new int[]{157, 29, 54, 42, 184, 56, 220, 219};
    private final int SCAN_RANGE = 128;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((this.prevWorld == null || mc.field_71441_e == null) && this.prevWorld != mc.field_71441_e) {
            if (mc.field_71441_e == null) {
                ClientCacheHandler.clearCache();
            }
            this.prevWorld = mc.field_71441_e;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (mc.field_71439_g != null && mc.field_71441_e != null && !mc.func_147113_T() && ClientEventHandler.hasOverlays((EntityPlayer)mc.field_71439_g)) {
                ClientEventHandler.renderCNPCPlayer.itemRenderer.func_78441_a();
            }
            return;
        }
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof ContainerPlayer) {
            if (this.otherContainer) {
                PacketClient.sendClient(new CheckPlayerValue(CheckPlayerValue.Type.CheckQuestCompletion));
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        ++CustomNpcs.ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (MusicController.Instance.isPlaying() && MusicController.Instance.getEntity() != null) {
            Entity entity = MusicController.Instance.getEntity();
            if (MusicController.Instance.getOffRange() > 0 && (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.func_70032_d(entity) > (float)MusicController.Instance.getOffRange() || entity.field_71093_bK != Minecraft.func_71410_x().field_71439_g.field_71093_bK)) {
                MusicController.Instance.stopMusic();
            }
        }
        MusicController.Instance.onUpdate();
        ScriptSoundController.Instance.onUpdate();
        if (Minecraft.func_71410_x().field_71439_g != null && (this.prevWidth != mc.field_71443_c || this.prevHeight != mc.field_71440_d)) {
            this.prevWidth = mc.field_71443_c;
            this.prevHeight = mc.field_71440_d;
            PacketClient.sendClient(new ScreenSizePacket(mc.field_71443_c, mc.field_71440_d));
        }
        if (mc.field_71441_e == null) {
            return;
        }
        if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
            this.updateCompassMarks();
        }
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() == -1 && Mouse.getEventDWheel() == 0) {
            return;
        }
        InputDevicePacket.sendMouse(Mouse.getEventButton(), Mouse.getEventDWheel(), Mouse.isButtonDown((int)Mouse.getEventButton()));
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (ClientProxy.NPCButton.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null) {
                InventoryTabCustomNpc.tabHelper();
            } else if (mc.field_71462_r instanceof GuiCNPCInventory) {
                mc.func_71381_h();
            }
        }
        if (!Keyboard.isRepeatEvent()) {
            int key = Keyboard.getEventKey();
            boolean keyDown = Keyboard.isKeyDown((int)key);
            InputDevicePacket.sendKeyboard(key, keyDown);
        }
    }

    private boolean isIgnoredKey(int key) {
        for (int i : this.ignoreKeys) {
            if (i != key) continue;
            return true;
        }
        return false;
    }

    private void updateCompassMarks() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return;
        }
        if (ClientHudManager.getInstance() == null || ClientHudManager.getInstance().getHudComponents() == null) {
            return;
        }
        HudComponent compass = ClientHudManager.getInstance().getHudComponents().get((Object)EnumHudComponent.QuestCompass);
        if (!(compass instanceof CompassHudComponent)) {
            return;
        }
        if (!compass.enabled) {
            return;
        }
        ArrayList<CompassHudComponent.MarkTargetEntry> marks = new ArrayList<CompassHudComponent.MarkTargetEntry>();
        block0: for (Object entity : mc.field_71441_e.field_72996_f) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            EntityNPCInterface npc = (EntityNPCInterface)((Object)entity);
            if (npc.field_71093_bK != player.field_71093_bK || player.func_70032_d((Entity)npc) > 128.0f) continue;
            MarkData markData = MarkData.get(npc);
            for (MarkData.Mark mark : markData.marks) {
                if (mark.getType() == 0 || !mark.availability.isAvailable((EntityPlayer)player)) continue;
                marks.add(new CompassHudComponent.MarkTargetEntry(npc.field_70165_t, npc.field_70161_v, mark.getType(), mark.color));
                continue block0;
            }
        }
        ((CompassHudComponent)compass).updateMarkTargets(marks);
    }
}

