/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.api;

import io.github.cruciblemc.omniconfig.OmniconfigCore;
import io.github.cruciblemc.omniconfig.api.annotation.IAnnotationConfigRegistry;
import io.github.cruciblemc.omniconfig.api.builders.IOmniconfigBuilder;
import io.github.cruciblemc.omniconfig.api.core.IOmniconfigRegistry;
import io.github.cruciblemc.omniconfig.api.core.SidedConfigType;
import io.github.cruciblemc.omniconfig.api.lib.Environment;
import io.github.cruciblemc.omniconfig.api.lib.Version;
import io.github.cruciblemc.omniconfig.core.Omniconfig;
import io.github.cruciblemc.omniconfig.core.OmniconfigRegistry;
import io.github.cruciblemc.omniconfig.gconfig.AnnotationConfigCore;
import java.io.File;

public class OmniconfigAPI {
    private OmniconfigAPI() {
    }

    public static IOmniconfigBuilder configBuilder(String fileName) {
        return Omniconfig.builder(OmniconfigCore.INSTANCE.sanitizeName(fileName), new Version("1.0.0"), true, SidedConfigType.COMMON);
    }

    public static IOmniconfigBuilder configBuilder(String fileName, Version version) {
        return Omniconfig.builder(OmniconfigCore.INSTANCE.sanitizeName(fileName), version, true, SidedConfigType.COMMON);
    }

    public static IOmniconfigBuilder configBuilder(String fileName, Version version, SidedConfigType sidedType) {
        return Omniconfig.builder(OmniconfigCore.INSTANCE.sanitizeName(fileName), version, true, sidedType);
    }

    public static void registerAnnotationConfig(Class<?> annotationConfigClass) {
        AnnotationConfigCore.INSTANCE.addAnnotationConfig(annotationConfigClass);
    }

    public static IOmniconfigRegistry getOmniconfigRegistry() {
        return OmniconfigRegistry.INSTANCE;
    }

    public static IAnnotationConfigRegistry getAnnotationConfigRegistry() {
        return AnnotationConfigCore.INSTANCE;
    }

    public static File getConfigFolder() {
        return OmniconfigCore.INSTANCE.getConfigFolder();
    }

    public static Environment getEnvironment() {
        return OmniconfigCore.INSTANCE.getEnvironment();
    }
}

