/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.cruciblemc.omniconfig.api.lib.Environment;
import io.github.cruciblemc.omniconfig.backing.Configuration;
import io.github.cruciblemc.omniconfig.core.Omniconfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OmniconfigCore {
    public static final Logger logger = LogManager.getLogger((String)"Omniconfig");
    public static final String FILE_SEPARATOR = File.separator;
    public static boolean onRemoteServer = false;
    public static final OmniconfigCore INSTANCE = new OmniconfigCore();
    private File mcLocation;
    private File configFolder;
    private File dataFolder;
    private File defaultConfigsArchive;
    private File defaultConfigsJson;
    private Environment side;
    private static final char[] LOOKUP_TABLE_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] LOOKUP_TABLE_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private OmniconfigCore() {
    }

    public void init(File mcLocation, Environment onSide) {
        logger.info("Initializing Omniconfig.");
        this.side = onSide;
        this.mcLocation = mcLocation;
        this.configFolder = new File(this.mcLocation, "config");
        this.dataFolder = new File(this.mcLocation, "mcdata");
        this.defaultConfigsArchive = new File(this.dataFolder, "defaultconfigs");
        this.defaultConfigsJson = new File(this.dataFolder, "defaultconfigs.json");
        this.configFolder.mkdirs();
        this.dataFolder.mkdirs();
    }

    public String sanitizeName(String configName) {
        String newName = configName.replace("/", FILE_SEPARATOR);
        if (newName.endsWith(".cfg")) {
            newName = newName.substring(0, newName.length() - 4);
        }
        return newName;
    }

    public void backUpDefaultCopy(Omniconfig cfg) {
        Configuration backingConfig = cfg.getBackingConfig();
        if (this.defaultConfigsArchive.exists() && this.defaultConfigsArchive.isFile() && !this.compareMD5()) {
            logger.info("Deleting defaultconfigs archive...");
            this.defaultConfigsArchive.delete();
        }
        if (!this.defaultConfigsArchive.exists() || !this.defaultConfigsArchive.isFile()) {
            try {
                ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(this.defaultConfigsArchive.toPath(), new OpenOption[0]));
                out.close();
                this.updateMemorizedMD5Digest();
                logger.info("Made new defaultconfigs archive: {}", new Object[]{this.defaultConfigsArchive.getCanonicalPath()});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            File trueConfig = cfg.getFile();
            File tempConfig = File.createTempFile(trueConfig.getName(), null);
            backingConfig.setFile(tempConfig);
            backingConfig.forceDefault(true);
            backingConfig.save();
            this.updateFileWithinArchive(this.defaultConfigsArchive, cfg.getFile(), cfg.getFileID().replace(FILE_SEPARATOR, "/"));
            tempConfig.delete();
            backingConfig.setFile(trueConfig);
            backingConfig.forceDefault(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateFileWithinArchive(File zipFile, File fileToUpdate, String zipEntryName) throws IOException {
        int len;
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        try {
            Files.move(zipFile.toPath(), tempFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath(), e);
        }
        byte[] buf = new byte[1024];
        ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(tempFile.toPath(), new OpenOption[0]));
        ZipOutputStream zipOutput = new ZipOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]));
        ZipEntry entry = zipInput.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (zipEntryName.equals(entryName)) {
                entry = zipInput.getNextEntry();
                continue;
            }
            zipOutput.putNextEntry(new ZipEntry(entryName));
            while ((len = zipInput.read(buf)) > 0) {
                zipOutput.write(buf, 0, len);
            }
            entry = zipInput.getNextEntry();
        }
        zipInput.close();
        InputStream updateInput = Files.newInputStream(fileToUpdate.toPath(), new OpenOption[0]);
        zipOutput.putNextEntry(new ZipEntry(zipEntryName));
        while ((len = updateInput.read(buf)) > 0) {
            zipOutput.write(buf, 0, len);
        }
        zipOutput.closeEntry();
        updateInput.close();
        zipOutput.close();
        tempFile.delete();
        this.updateMemorizedMD5Digest();
    }

    private boolean compareMD5() {
        String memorized = this.getMemorizedMD5Digest();
        String current = this.getArchiveMD5Digest();
        boolean equals = Objects.equals(memorized, current);
        return equals;
    }

    private String getArchiveMD5Digest() {
        return OmniconfigCore.getMD5Digest(this.defaultConfigsArchive);
    }

    @Nullable
    private String getMemorizedMD5Digest() {
        try {
            if (this.defaultConfigsArchive.exists() && this.defaultConfigsArchive.isFile() && this.defaultConfigsJson.exists() && this.defaultConfigsJson.isFile()) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                FileInputStream fileInput = new FileInputStream(this.defaultConfigsJson);
                InputStreamReader streamReader = new InputStreamReader((InputStream)fileInput, StandardCharsets.UTF_8);
                HashMap map = (HashMap)gson.fromJson((Reader)streamReader, HashMap.class);
                String hash = (String)map.get("md5");
                streamReader.close();
                fileInput.close();
                return hash;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void updateMemorizedMD5Digest() {
        this.updateMemorizedMD5Digest(this.getArchiveMD5Digest());
    }

    private void updateMemorizedMD5Digest(String hash) {
        try {
            FileOutputStream fileOutput = new FileOutputStream(this.defaultConfigsJson);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)fileOutput, StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("md5", hash);
            gson.toJson(map, (Appendable)streamWriter);
            streamWriter.close();
            fileOutput.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public File extractDefaultCopy(String fileID) {
        try {
            if (this.defaultConfigsArchive.exists() && this.defaultConfigsArchive.isFile()) {
                if (this.compareMD5()) {
                    File defaultCopy = File.createTempFile(UUID.randomUUID().toString(), null);
                    defaultCopy.delete();
                    ZipFile archive = new ZipFile(this.defaultConfigsArchive);
                    ZipEntry entry = archive.getEntry(fileID.replace(FILE_SEPARATOR, "/"));
                    if (entry != null) {
                        InputStream inputStream = archive.getInputStream(entry);
                        Files.copy(inputStream, defaultCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        inputStream.close();
                    }
                    archive.close();
                    return defaultCopy;
                }
                logger.info("Deleting defaultconfigs archive...");
                this.defaultConfigsArchive.delete();
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5Digest(File file) {
        if (!file.exists()) return null;
        if (!file.isFile()) return null;
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = OmniconfigCore.md5Hex(stream);
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get MD5Digest from file " + file.getAbsolutePath(), ex);
        }
    }

    public static String encodeHex(byte[] byteArray, boolean upperCase, ByteOrder byteOrder) {
        char[] buffer = new char[byteArray.length * 2];
        char[] lookup = upperCase ? LOOKUP_TABLE_UPPER : LOOKUP_TABLE_LOWER;
        for (int i = 0; i < byteArray.length; ++i) {
            int index = byteOrder == ByteOrder.BIG_ENDIAN ? i : byteArray.length - i - 1;
            buffer[i << 1] = lookup[byteArray[index] >> 4 & 0xF];
            buffer[(i << 1) + 1] = lookup[byteArray[index] & 0xF];
        }
        return new String(buffer);
    }

    public static String encodeHex(byte[] byteArray) {
        return OmniconfigCore.encodeHex(byteArray, false, ByteOrder.BIG_ENDIAN);
    }

    public static String md5Hex(InputStream stream) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        while (stream.available() > 0) {
            digest.update((byte)stream.read());
        }
        return OmniconfigCore.encodeHex(digest.digest());
    }

    public Environment getEnvironment() {
        return this.side;
    }

    public static void executeInEnvironment(Environment side, Supplier<Runnable> supplier) {
        side.execute(supplier);
    }

    public File getConfigFolder() {
        return this.configFolder;
    }
}

