/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.outline;

import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.client.utils.Color;
import kamkeel.npcdbc.controllers.OutlineController;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.util.ValueUtil;

public class Outline
implements IOutline {
    public int id = -1;
    public String name = "";
    public String menuName = "\u00a7aNEW";
    public Color innerColor = new Color(65535, 1.0f);
    public Color outerColor = new Color(0xFFFFFF, 1.0f);
    public float size = 1.0f;
    public float speed = 1.0f;
    public float noiseSize = 1.0f;
    public float colorSmoothness = 0.2f;
    public float colorInterpolation = 0.55f;
    public float pulsingSpeed = 0.0f;

    public Outline() {
    }

    public Outline(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("menuName", this.name);
        compound.func_74776_a("size", this.size);
        compound.func_74776_a("speed", this.speed);
        compound.func_74776_a("noiseSize", this.noiseSize);
        compound.func_74776_a("colorSmoothness", this.colorSmoothness);
        compound.func_74776_a("colorInterpolation", this.colorInterpolation);
        compound.func_74776_a("pulsingSpeed", this.pulsingSpeed);
        this.innerColor.writeToNBT(compound, "inner");
        this.outerColor.writeToNBT(compound, "outer");
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.id = compound.func_74764_b("ID") ? compound.func_74762_e("ID") : OutlineController.Instance.getUnusedId();
        this.name = compound.func_74779_i("name");
        this.menuName = compound.func_74779_i("menuName");
        this.size = compound.func_74760_g("size");
        this.speed = compound.func_74760_g("speed");
        this.noiseSize = compound.func_74760_g("noiseSize");
        this.colorSmoothness = compound.func_74760_g("colorSmoothness");
        this.colorInterpolation = compound.func_74760_g("colorInterpolation");
        this.pulsingSpeed = compound.func_74760_g("pulsingSpeed");
        this.innerColor.readFromNBT(compound, "inner");
        this.outerColor.readFromNBT(compound, "outer");
    }

    @Override
    public void setInnerColor(int color, float alpha) {
        this.innerColor.setColor(color, ValueUtil.clamp((float)alpha, (float)0.0f, (float)1.0f));
    }

    @Override
    public void setOuterColor(int color, float alpha) {
        this.outerColor.setColor(color, ValueUtil.clamp((float)alpha, (float)0.0f, (float)1.0f));
    }

    @Override
    public IOutline setSize(float size) {
        this.size = ValueUtil.clamp((float)size, (float)0.0f, (float)5.0f);
        return this;
    }

    @Override
    public IOutline setNoiseSize(float size) {
        this.noiseSize = ValueUtil.clamp((float)size, (float)0.0f, (float)50.0f);
        return this;
    }

    @Override
    public IOutline setSpeed(float speed) {
        this.speed = ValueUtil.clamp((float)this.size, (float)0.0f, (float)50.0f);
        return this;
    }

    @Override
    public IOutline setPulsingSpeed(float speed) {
        this.pulsingSpeed = ValueUtil.clamp((float)speed, (float)0.0f, (float)50.0f);
        return this;
    }

    @Override
    public IOutline setColorSmoothness(float smoothness) {
        this.colorSmoothness = ValueUtil.clamp((float)smoothness, (float)0.0f, (float)1.0f);
        return this;
    }

    @Override
    public IOutline setColorInterpolation(float interp) {
        this.colorInterpolation = ValueUtil.clamp((float)interp, (float)0.0f, (float)1.0f);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMenuName() {
        return this.menuName;
    }

    @Override
    public void setMenuName(String name) {
        if (name.contains("&")) {
            name = name.replace("&", "\u00a7");
        }
        this.menuName = name;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int newID) {
        this.id = newID;
    }

    @Override
    public IOutline clone() {
        Outline outline = new Outline();
        outline.readFromNBT(this.writeToNBT());
        outline.id = OutlineController.Instance.getUnusedId();
        return outline;
    }

    @Override
    public IOutline save() {
        return OutlineController.Instance.saveOutline(this);
    }
}

